/*
 * Decompiled with CFR 0.152.
 */
package com.corwinjv.mobtotems.blocks;

import com.corwinjv.mobtotems.blocks.ModBlock;
import com.corwinjv.mobtotems.blocks.tiles.OfferingBoxTileEntity;
import com.corwinjv.mobtotems.blocks.tiles.SacredLightTileEntity;
import com.corwinjv.mobtotems.blocks.tiles.TotemTileEntity;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SacredLightBlock
extends ModBlock
implements ITileEntityProvider {
    public SacredLightBlock() {
        super(Material.field_151594_q);
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.field_149758_A = true;
    }

    public boolean isVisuallyOpaque() {
        return false;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        double d0 = (double)pos.func_177958_n() + 0.5;
        double d1 = (double)pos.func_177956_o() + 0.7;
        double d2 = (double)pos.func_177952_p() + 0.5;
        worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + 0.27 * (double)EnumFacing.UP.func_82601_c(), d1 + 0.22, d2 + 0.27 * (double)EnumFacing.UP.func_82599_e(), 0.0, 0.0, 0.0, new int[0]);
        worldIn.func_175688_a(EnumParticleTypes.FLAME, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
    }

    public int getLightValue(@Nullable IBlockState state, @Nullable IBlockAccess world, @Nullable BlockPos pos) {
        return 15;
    }

    private boolean canPlaceOn(World worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos);
        if (state.isSideSolid((IBlockAccess)worldIn, pos, EnumFacing.UP)) {
            return true;
        }
        return state.func_177230_c().canPlaceTorchOnTop(state, (IBlockAccess)worldIn, pos);
    }

    public void func_176206_d(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity master;
        super.func_176206_d(worldIn, pos, state);
        TileEntity te = worldIn.func_175625_s(new BlockPos(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p()));
        if (te != null && te instanceof TotemTileEntity && (master = (TileEntity)((TotemTileEntity)te).getMaster()) != null && master instanceof OfferingBoxTileEntity) {
            ((OfferingBoxTileEntity)master).invalidateSlaves();
            ((OfferingBoxTileEntity)master).verifyMultiblock();
        }
    }

    public boolean func_176196_c(World worldIn, @Nonnull BlockPos pos) {
        return this.canPlaceAt(worldIn, pos, EnumFacing.UP);
    }

    private boolean canPlaceAt(World worldIn, BlockPos pos, EnumFacing facing) {
        BlockPos blockpos = pos.func_177972_a(facing.func_176734_d());
        return this.canPlaceOn(worldIn, blockpos);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.checkForDrop(worldIn, pos, state);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos p_189540_5_) {
        this.checkForDrop(worldIn, pos, state);
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(world, pos, neighbor);
    }

    private boolean checkForDrop(World worldIn, BlockPos pos, IBlockState state) {
        if (this.canPlaceAt(worldIn, pos, EnumFacing.UP)) {
            return true;
        }
        if (worldIn.func_180495_p(pos).func_177230_c() == this) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
        return false;
    }

    @Nonnull
    public TileEntity func_149915_a(@Nullable World worldIn, int meta) {
        return new SacredLightTileEntity();
    }
}

