/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.projectintelligence.docmanagement;

import com.brandon3055.projectintelligence.client.gui.PIConfig;
import com.brandon3055.projectintelligence.docmanagement.DocumentationManager;
import com.brandon3055.projectintelligence.docmanagement.DocumentationPage;
import com.brandon3055.projectintelligence.docmanagement.ModStructurePage;
import com.brandon3055.projectintelligence.docmanagement.PIUpdateManager;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.LinkedList;
import net.minecraft.client.resources.I18n;

public class RootPage
extends DocumentationPage {
    public static final String ROOT_URI = "[pi_root_page]";

    protected RootPage() {
        super(null, ROOT_URI, "0.0.0", false);
    }

    public void addModPage(ModStructurePage page) {
        this.subPages.add(page);
        page.parent = this;
    }

    public DocumentationPage getHomePage() {
        DocumentationPage page = DocumentationManager.getPage(PIConfig.homePage);
        return page instanceof RootPage ? null : page;
    }

    @Override
    public File getMarkdownFile() {
        DocumentationPage homePage = this.getHomePage();
        if (homePage != null) {
            return homePage.getMarkdownFile();
        }
        return new File(DocumentationManager.getDocDirectory(), "Invalid-Home-Page");
    }

    @Override
    public LinkedList<String> getMarkdownLines() {
        DocumentationPage homePage = this.getHomePage();
        if (homePage == null) {
            if (!PIConfig.downloadsAllowed) {
                return new LinkedList<String>(Lists.newArrayList((Object[])new String[]{"Waiting for permission to download documentation..."}));
            }
            if (PIUpdateManager.updateStage != PIUpdateManager.UpdateStage.INACTIVE) {
                return new LinkedList<String>(Lists.newArrayList((Object[])new String[]{"Documentation download in progress..."}));
            }
            return new LinkedList<String>(Lists.newArrayList((Object[])new String[]{"The specified home page \"" + PIConfig.homePage + "\" does not exist!", "To set a new home page right-click on a page in the navigation pane and select \"Set as home page\""}));
        }
        return homePage.getMarkdownLines();
    }

    @Override
    public String getPageId() {
        return this.getModid();
    }

    @Override
    public String getPageURI() {
        return ROOT_URI;
    }

    @Override
    public String getDisplayName() {
        return I18n.func_135052_a((String)"pi.root_page.name", (Object[])new Object[0]);
    }

    @Override
    public void loadFromJson(JsonObject jObj) {
    }

    @Override
    public JsonObject writeToJson() {
        return new JsonObject();
    }

    @Override
    public void deletePage() {
    }
}

