/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.projectintelligence.client.gui;

import com.brandon3055.projectintelligence.client.gui.PIGuiOverlay;
import com.brandon3055.projectintelligence.registry.GuiDocRegistry;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiInGuiRenderer {
    public static GuiInGuiRenderer instance = new GuiInGuiRenderer();
    private PIGuiOverlay overlay = null;
    private GuiScreen activeScreen = null;
    private GuiDocRegistry.GuiDocHelper guiDocHelper = null;
    private int eventButton = -1;
    private long lastMouseEvent = 0L;

    public void guiOpened(@Nullable GuiScreen gui) {
        if (gui != null && GuiDocRegistry.INSTANCE.doesGuiHaveDoc(gui)) {
            this.activeScreen = gui;
            this.guiDocHelper = GuiDocRegistry.INSTANCE.getDocHelper(gui);
        } else {
            this.activeScreen = null;
            this.overlay = null;
        }
    }

    public void guiInit(GuiScreen gui) {
        if (this.isActiveScreen(gui)) {
            this.overlay = new PIGuiOverlay(gui, this.guiDocHelper);
        }
    }

    public void drawScreen(GuiScreen gui) {
        if (this.isActiveScreen(gui) && this.overlay != null) {
            int mouseX = this.getMouseX(gui);
            int mouseY = this.getMouseY(gui);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)500.0f);
            this.overlay.renderElements(mouseX, mouseY, gui.field_146297_k.func_184121_ak());
            this.overlay.renderOverlayLayer(mouseX, mouseY, gui.field_146297_k.func_184121_ak());
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-500.0f);
        }
    }

    public void drawScreenPost(GuiScreen gui) {
        if (this.isActiveScreen(gui) && this.overlay != null) {
            int mouseX = this.getMouseX(gui);
            int mouseY = this.getMouseY(gui);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)500.0f);
            this.overlay.renderOverlayLayer(mouseX, mouseY, gui.field_146297_k.func_184121_ak());
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-500.0f);
        }
    }

    public void updateScreen() {
        if (this.activeScreen != null && this.overlay != null) {
            this.overlay.updateScreen();
        }
    }

    public boolean handleMouseInput(GuiScreen gui) throws IOException {
        if (this.isActiveScreen(gui) && this.overlay != null) {
            int mouseX = this.getMouseX(gui);
            int mouseY = this.getMouseY(gui);
            int button = Mouse.getEventButton();
            if (this.overlay.handleMouseInput()) {
                return true;
            }
            if (Mouse.getEventButtonState()) {
                this.eventButton = button;
                this.lastMouseEvent = Minecraft.func_71386_F();
                return this.overlay.mouseClicked(mouseX, mouseY, button);
            }
            if (button != -1) {
                this.eventButton = -1;
                this.overlay.mouseReleased(mouseX, mouseY, button);
            } else if (this.eventButton != -1 && this.lastMouseEvent > 0L) {
                long timeClicked = Minecraft.func_71386_F() - gui.field_146288_g;
                this.overlay.mouseClickMove(mouseX, mouseY, this.eventButton, timeClicked);
            }
        }
        return false;
    }

    public boolean handleKeyboardInput(GuiScreen gui) throws IOException {
        if (this.isActiveScreen(gui) && this.overlay != null) {
            char c0 = Keyboard.getEventCharacter();
            if (Keyboard.getEventKey() == 0 && c0 >= ' ' || Keyboard.getEventKeyState()) {
                return this.overlay.keyTyped(c0, Keyboard.getEventKey());
            }
        }
        return false;
    }

    public boolean isActiveScreen(GuiScreen gui) {
        return gui != null && gui == this.activeScreen && this.guiDocHelper != null;
    }

    private int getMouseX(GuiScreen gui) {
        return Mouse.getEventX() * gui.field_146294_l / gui.field_146297_k.field_71443_c;
    }

    private int getMouseY(GuiScreen gui) {
        return gui.field_146295_m - Mouse.getEventY() * gui.field_146295_m / gui.field_146297_k.field_71440_d - 1;
    }

    public boolean blockToolTip(GuiScreen currentScreen) {
        return this.isActiveScreen(currentScreen) && this.overlay != null && this.overlay.isMouseOver(this.getMouseX(currentScreen), this.getMouseY(currentScreen));
    }

    public List<Rectangle> getJeiExclusionAreas() {
        GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
        if (this.isActiveScreen(screen) && this.overlay != null && this.overlay.getDocBounds() != null) {
            return Collections.singletonList(new Rectangle(this.overlay.getDocBounds()));
        }
        return Collections.emptyList();
    }
}

