/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.entity;

import epicsquid.mysticalworld.init.ModSounds;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIOcelotAttack;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityLavaCat
extends EntityOcelot {
    public static ResourceLocation LOOT_TABLE = new ResourceLocation("mysticalworld", "entity/lava_cat");
    private static final DataParameter<Boolean> IS_LAVA = EntityDataManager.func_187226_a(EntityLavaCat.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final UUID OBSIDIAN_SPEED_DEBUFF_ID = UUID.fromString("f58f95e9-fb51-4604-a66d-89433c9dd8a5");
    private static final AttributeModifier OBSIDIAN_SPEED_DEBUFF = new AttributeModifier(OBSIDIAN_SPEED_DEBUFF_ID, "Speed debuff for being obsidian", -0.1, 0).func_111168_a(false);
    private EntityAITempt aiTempt;

    public EntityLavaCat(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.75f, 0.875f);
    }

    protected void func_184651_r() {
        this.field_70911_d = new EntityAISit((EntityTameable)this);
        this.aiTempt = new EntityAITempt((EntityCreature)this, 0.6, Items.field_151072_bj, true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.aiTempt);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFollowOwner((EntityTameable)this, 1.0, 10.0f, 5.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.3f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIOcelotAttack((EntityLiving)this));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 0.8));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8, 1));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 10.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_LAVA, (Object)true);
    }

    public void func_70619_bc() {
        if (this.func_70605_aq().func_75640_a()) {
            double d0 = this.func_70605_aq().func_75638_b();
            if (d0 == 0.6) {
                this.func_70095_a(true);
                this.func_70031_b(false);
            } else if (d0 == 1.33) {
                this.func_70095_a(false);
                this.func_70031_b(true);
            } else {
                this.func_70095_a(false);
                this.func_70031_b(false);
            }
        } else {
            this.func_70095_a(false);
            this.func_70031_b(false);
        }
    }

    protected boolean func_70692_ba() {
        return !this.func_70909_n() && this.field_70173_aa > 2400;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        if (this.func_70909_n()) {
            if (this.func_70880_s()) {
                return ModSounds.LavaCat.PURR;
            }
            return this.field_70146_Z.nextInt(4) == 0 ? ModSounds.LavaCat.PURREOW : ModSounds.LavaCat.AMBIENT;
        }
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return ModSounds.LavaCat.HURT;
    }

    protected SoundEvent func_184615_bR() {
        return ModSounds.LavaCat.DEATH;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    public boolean func_70652_k(Entity entityIn) {
        EntityDamageSource damage = new EntityDamageSource("mob", (Entity)this);
        damage.func_76351_m();
        float amount = 3.0f;
        if (this.getIsLava()) {
            damage.func_76361_j().func_76348_h();
        } else {
            amount = 6.0f;
        }
        return entityIn.func_70097_a((DamageSource)damage, amount);
    }

    public void func_70015_d(int seconds) {
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (this.field_70911_d != null) {
            this.field_70911_d.func_75270_a(false);
        }
        if (source != null && source.func_76347_k()) {
            return false;
        }
        if (source == DamageSource.field_82727_n || source == DamageSource.field_82728_o) {
            return false;
        }
        boolean lava = this.getIsLava();
        if (!(lava || source != null && source.func_82725_o())) {
            amount /= 2.0f;
        }
        if (lava && source != null && source.func_82725_o()) {
            amount /= 2.0f;
        }
        if (this.func_70909_n() && source != null && source.func_76346_g() != null && source.func_76346_g() == this.func_70902_q() && !source.func_76346_g().func_70093_af()) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public void func_70690_d(PotionEffect potioneffectIn) {
        Potion type = potioneffectIn.func_188419_a();
        if (type == MobEffects.field_76436_u || type == MobEffects.field_82731_v) {
            return;
        }
        super.func_70690_d(potioneffectIn);
    }

    @Nullable
    public ResourceLocation func_184647_J() {
        return LOOT_TABLE;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (this.func_70909_n()) {
            if (this.func_152114_e((EntityLivingBase)player) && !this.field_70170_p.field_72995_K && !this.func_70877_b(itemstack)) {
                this.field_70911_d.func_75270_a(!this.func_70906_o());
            }
        } else if ((this.aiTempt == null || this.aiTempt.func_75277_f()) && itemstack.func_77973_b() == Items.field_151072_bj && player.func_70068_e((Entity)this) < 9.0) {
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.field_70146_Z.nextInt(3) == 0 && !ForgeEventFactory.onAnimalTame((EntityAnimal)this, (EntityPlayer)player)) {
                    this.func_193101_c(player);
                    this.func_70908_e(true);
                    this.field_70911_d.func_75270_a(true);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                } else {
                    this.func_70908_e(false);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                }
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public EntityLavaCat createChild(EntityAgeable ageable) {
        EntityLavaCat lavacat = new EntityLavaCat(this.field_70170_p);
        if (this.func_70909_n()) {
            lavacat.func_184754_b(this.func_184753_b());
            lavacat.func_70903_f(true);
            lavacat.setIsLava(this.getIsLava());
        }
        return lavacat;
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151072_bj;
    }

    public boolean func_70878_b(EntityAnimal otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (!this.func_70909_n()) {
            return false;
        }
        if (!(otherAnimal instanceof EntityLavaCat)) {
            return false;
        }
        EntityLavaCat lavacat = (EntityLavaCat)otherAnimal;
        if (!lavacat.func_70909_n()) {
            return false;
        }
        return this.func_70880_s() && lavacat.func_70880_s();
    }

    public int func_70913_u() {
        return 0;
    }

    public void func_70912_b(int skinId) {
    }

    public boolean getIsLava() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_LAVA);
    }

    public void setIsLava(boolean val) {
        this.field_70180_af.func_187227_b(IS_LAVA, (Object)val);
        this.field_70180_af.func_187217_b(IS_LAVA);
        IAttributeInstance attr = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
        if (val) {
            attr.func_111124_b(OBSIDIAN_SPEED_DEBUFF);
        } else {
            attr.func_111121_a(OBSIDIAN_SPEED_DEBUFF);
        }
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.field_73012_v.nextInt(3) != 0;
    }

    public boolean func_70058_J() {
        if (this.field_70170_p.func_72917_a(this.func_174813_aQ(), (Entity)this) && this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && !this.field_70170_p.func_72953_d(this.func_174813_aQ())) {
            BlockPos blockpos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
            IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos.func_177977_b());
            return iblockstate.isSideSolid((IBlockAccess)this.field_70170_p, blockpos, EnumFacing.UP);
        }
        return false;
    }

    protected void func_175544_ck() {
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.getIsLava() && this.field_70170_p.func_175727_C(this.func_180425_c()) && this.field_70170_p.func_175678_i(this.func_180425_c()) && this.field_70146_Z.nextInt(30) == 0) {
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, ModSounds.LavaCat.SIZZLE, SoundCategory.NEUTRAL, 0.2f, 1.3f);
        }
        if (this.getIsLava() && this.field_70171_ac) {
            this.setIsLava(false);
        } else if (!this.getIsLava() && this.func_180799_ab()) {
            this.setIsLava(true);
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setIsLava(compound.func_74767_n("IsLava"));
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("IsLava", this.getIsLava());
    }

    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        return this.getIsLava() ? I18n.func_74838_a((String)"entity.entity_lava_cat.name") : I18n.func_74838_a((String)"entity.entity_obsidian_cat.name");
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111121_a(new AttributeModifier("Random spawn bonus", this.field_70146_Z.nextGaussian() * 0.05, 1));
        if (this.field_70146_Z.nextFloat() < 0.05f) {
            this.func_184641_n(true);
        } else {
            this.func_184641_n(false);
        }
        if (this.func_70913_u() == 0 && this.field_70170_p.field_73012_v.nextInt(7) == 0) {
            for (int i = 0; i < 2; ++i) {
                EntityLavaCat entitylavacat = new EntityLavaCat(this.field_70170_p);
                entitylavacat.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
                entitylavacat.func_70873_a(-24000);
                this.field_70170_p.func_72838_d((Entity)entitylavacat);
            }
        }
        return livingdata;
    }
}

