/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.entity;

import epicsquid.mysticalworld.init.ModSounds;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITargetNonTamed;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityFox
extends EntityTameable {
    public static final ResourceLocation LOOT_TABLE = new ResourceLocation("mysticalworld", "entity/fox");
    private static final DataParameter<Float> DATA_HEALTH_ID = EntityDataManager.func_187226_a(EntityFox.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> SLEEPING = EntityDataManager.func_187226_a(EntityFox.class, (DataSerializer)DataSerializers.field_187198_h);
    private EntityAISleep aiSleep;

    public EntityFox(@Nonnull World worldIn) {
        super(worldIn);
        this.func_70105_a(0.75f, 0.75f);
        this.func_70903_f(false);
        this.field_70728_aV = 5;
    }

    public boolean func_70877_b(@Nonnull ItemStack stack) {
        return stack.func_77973_b() == Items.field_151034_e;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return ModSounds.Fox.BARK;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return ModSounds.Fox.DEATH;
    }

    protected void func_184651_r() {
        this.field_70911_d = new EntityAISit((EntityTameable)this);
        this.aiSleep = new EntityAISleep(this);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.aiSleep);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.25, Items.field_151034_e, false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIFollowOwner((EntityTameable)this, 1.0, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetNonTamed((EntityTameable)this, EntityChicken.class, false, p_apply_1_ -> p_apply_1_ instanceof EntityChicken));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetNonTamed((EntityTameable)this, EntityRabbit.class, false, p_apply_1_ -> p_apply_1_ instanceof EntityRabbit));
    }

    public void func_98054_a(boolean child) {
        this.func_98055_j(child ? 0.5f : 1.0f);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        if (this.func_70909_n()) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.3f);
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
            this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.2f);
            this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
        }
    }

    public void func_70624_b(@Nullable EntityLivingBase entitylivingbaseIn) {
        super.func_70624_b(entitylivingbaseIn);
        if (entitylivingbaseIn == null) {
            this.setAngry(false);
        } else if (!this.func_70909_n()) {
            this.setAngry(true);
        }
    }

    protected void func_70619_bc() {
        this.field_70180_af.func_187227_b(DATA_HEALTH_ID, (Object)Float.valueOf(this.func_110143_aJ()));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_HEALTH_ID, (Object)Float.valueOf(this.func_110143_aJ()));
        this.field_70180_af.func_187214_a(SLEEPING, (Object)false);
    }

    protected float func_70599_aP() {
        return 0.3f;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("Angry", this.isAngry());
        compound.func_74757_a("Sleeping", this.isSleeping());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setAngry(compound.func_74767_n("Angry"));
        if (compound.func_74764_b("Sleeping")) {
            this.setSleeping(compound.func_74767_n("Sleeping"));
            if (this.aiSleep != null) {
                this.aiSleep.setSleeping(this.isSleeping());
            }
        }
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        if (this.isAngry()) {
            return ModSounds.Fox.AGGRO;
        }
        if (this.isSleeping()) {
            return ModSounds.Fox.SLEEP;
        }
        return ModSounds.Fox.IDLE;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.isAngry() && this.isSleeping()) {
            this.setSleeping(false);
        }
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() == null && this.isAngry()) {
            this.setAngry(false);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (this.isSleeping()) {
            this.setSleeping(false);
        }
        if (this.field_70911_d != null) {
            this.field_70911_d.func_75270_a(false);
        }
        if (entity != null && !(entity instanceof EntityPlayer) && !(entity instanceof EntityArrow)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
        if (flag) {
            this.func_174815_a((EntityLivingBase)this, entityIn);
            this.func_184185_a(ModSounds.Fox.BITE, 1.0f, 1.0f);
        }
        return flag;
    }

    public void func_70903_f(boolean tamed) {
        super.func_70903_f(tamed);
        if (tamed) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        }
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (this.func_70909_n()) {
            if (!itemstack.func_190926_b() && (itemstack.func_77973_b() == Items.field_151034_e || itemstack.func_77973_b() == Items.field_151153_ao) && ((Float)this.field_70180_af.func_187225_a(DATA_HEALTH_ID)).floatValue() < 20.0f) {
                this.func_70691_i(((ItemFood)itemstack.func_77973_b()).func_150905_g(itemstack));
                if (!player.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
                return true;
            }
            if (this.func_152114_e((EntityLivingBase)player) && !this.field_70170_p.field_72995_K && !this.func_70877_b(itemstack)) {
                this.field_70911_d.func_75270_a(!this.func_70906_o());
                this.field_70703_bu = false;
                this.field_70699_by.func_75499_g();
                this.func_70624_b(null);
            }
        } else if (itemstack.func_77973_b() == Items.field_151034_e && !this.isAngry()) {
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.field_70146_Z.nextInt(3) == 0 && !ForgeEventFactory.onAnimalTame((EntityAnimal)this, (EntityPlayer)player)) {
                    this.func_193101_c(player);
                    this.field_70699_by.func_75499_g();
                    this.func_70624_b(null);
                    this.field_70911_d.func_75270_a(true);
                    this.func_70606_j(20.0f);
                    this.func_70908_e(true);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                } else {
                    this.func_70908_e(false);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                }
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public boolean isAngry() {
        return ((Byte)this.field_70180_af.func_187225_a(field_184755_bv) & 2) != 0;
    }

    public void setAngry(boolean angry) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(field_184755_bv);
        if (angry) {
            this.field_70180_af.func_187227_b(field_184755_bv, (Object)((byte)(b0 | 2)));
        } else {
            this.field_70180_af.func_187227_b(field_184755_bv, (Object)((byte)(b0 & 0xFFFFFFFD)));
        }
    }

    public boolean isSleeping() {
        try {
            return (Boolean)this.field_70180_af.func_187225_a(SLEEPING);
        }
        catch (ClassCastException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setSleeping(boolean sleeping) {
        this.field_70180_af.func_187227_b(SLEEPING, (Object)sleeping);
    }

    public boolean func_142018_a(EntityLivingBase target, EntityLivingBase owner) {
        if (!(target instanceof EntityCreeper) && !(target instanceof EntityGhast)) {
            EntityFox entityfox;
            if (target instanceof EntityFox && (entityfox = (EntityFox)target).func_70909_n() && entityfox.func_70902_q() == owner) {
                return false;
            }
            if (target instanceof EntityPlayer && owner instanceof EntityPlayer && !((EntityPlayer)owner).func_96122_a((EntityPlayer)target)) {
                return false;
            }
            return !(target instanceof AbstractHorse) || !((AbstractHorse)target).func_110248_bS();
        }
        return false;
    }

    public boolean func_184652_a(EntityPlayer player) {
        return !this.isAngry() && super.func_184652_a(player);
    }

    @Nonnull
    public EntityAgeable func_90011_a(@Nonnull EntityAgeable ageable) {
        EntityFox bebe = new EntityFox(ageable.field_70170_p);
        if (this.func_70909_n()) {
            bebe.func_70903_f(true);
            bebe.func_184754_b(this.func_184753_b());
        }
        return bebe;
    }

    @Nonnull
    public ResourceLocation func_184647_J() {
        return LOOT_TABLE;
    }

    public static class EntityAISleep
    extends EntityAIBase {
        private final EntityFox tameable;
        private boolean isSleeping;

        public EntityAISleep(EntityFox entityIn) {
            this.tameable = entityIn;
            this.func_75248_a(5);
        }

        public boolean func_75250_a() {
            if (!this.tameable.func_70909_n()) {
                return false;
            }
            if (this.tameable.func_70090_H()) {
                return false;
            }
            if (!this.tameable.field_70122_E) {
                return false;
            }
            EntityLivingBase entitylivingbase = this.tameable.func_70902_q();
            if (entitylivingbase == null) {
                return true;
            }
            return !(this.tameable.func_70068_e((Entity)entitylivingbase) < 144.0 && entitylivingbase.func_70643_av() != null || !this.isSleeping);
        }

        public void func_75249_e() {
            this.tameable.func_70661_as().func_75499_g();
            this.tameable.setSleeping(true);
        }

        public void func_75251_c() {
            this.tameable.setSleeping(false);
        }

        public void setSleeping(boolean sleeping) {
            this.isSleeping = sleeping;
        }
    }
}

