/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compatmod.immersiveengineering;

import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import techreborn.api.recipe.Fuels;
import techreborn.api.recipe.Recipes;
import techreborn.compat.ICompatModule;
import techreborn.init.recipes.RecipeMethods;

@RebornRegistry(modOnly="immersiveengineering", modID="techreborn")
public class ImmersiveEngineeringCompat
implements ICompatModule {
    @ConfigRegistry(config="compat", category="immersive_engineering", key="EnableCompressorImmersiveEngineeringRecipes", comment="Enable compressor recipes related to Immersive Engineering content")
    public static boolean enableCompressorImmersiveEngineeringRecipes = true;
    @ConfigRegistry(config="compat", category="immersive_engineering", key="EnableImmersiveEngineeringFuels", comment="Allow Immersive Engineering fuels to be used in the fuel generators")
    public static boolean enableImmersiveEngineeringFuels = true;

    public void init(FMLInitializationEvent event) {
        Item material;
        if (enableCompressorImmersiveEngineeringRecipes && (material = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("immersiveengineering:material"))) != null) {
            Recipes.compressor.createRecipe().withInput("dustCoke").withOutput(RecipeMethods.getStack((Item)material, (int)1, (int)18)).withEnergyCostPerTick(4).withOperationDuration(300).register();
        }
    }

    public void postInit(FMLPostInitializationEvent event) {
        Fluid creosote;
        if (enableImmersiveEngineeringFuels && (creosote = FluidRegistry.getFluid((String)"creosote")) != null) {
            Fuels.semiFluidGenerator.addFuel().addFluidSource(creosote).withEnergyOutput(3.0).withEnergyPerTick(3.0).register();
        }
    }
}

