/*
 * Decompiled with CFR 0.152.
 */
package org.softc.armoryexpansion.common.integration.aelib.plugins.tinkersconstruct.material;

import org.softc.armoryexpansion.common.integration.aelib.config.MaterialConfigOptions;
import org.softc.armoryexpansion.common.integration.aelib.plugins.general.material.BasicMaterial;
import org.softc.armoryexpansion.common.integration.aelib.plugins.tinkersconstruct.material.IToolMaterial;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;

public class ToolMaterial
extends BasicMaterial
implements IToolMaterial {
    protected HeadMaterialStats headMaterialStats;
    protected HandleMaterialStats handleMaterialStats;
    protected ExtraMaterialStats extraMaterialStats;

    @Override
    public HeadMaterialStats getHeadMaterialStats() {
        return this.headMaterialStats;
    }

    @Override
    public HandleMaterialStats getHandleMaterialStats() {
        return this.handleMaterialStats;
    }

    @Override
    public ExtraMaterialStats getExtraMaterialStats() {
        return this.extraMaterialStats;
    }

    @Override
    public boolean isToolMaterial() {
        return null != this.headMaterialStats || null != this.handleMaterialStats || null != this.extraMaterialStats;
    }

    @Override
    public boolean isArmorMaterial() {
        return false;
    }

    @Override
    public boolean isRangedMaterial() {
        return false;
    }

    @Override
    public boolean registerTinkersMaterialStats(MaterialConfigOptions properties) {
        if (properties.materialEnabled() && properties.isToolEnabled()) {
            Material material = TinkerRegistry.getMaterial((String)this.getIdentifier());
            this.registerToolStats(material, properties);
            return true;
        }
        return false;
    }

    void registerToolStats(Material material, MaterialConfigOptions properties) {
        if (this.isToolMaterial()) {
            this.registerHeadStats(material, properties);
            this.registerHandleStats(material, properties);
            this.registerExtraStats(material, properties);
        }
    }

    private void registerHeadStats(Material material, MaterialConfigOptions properties) {
        if (null == material.getStats("head") && null != this.headMaterialStats && properties.isHeadEnabled()) {
            TinkerRegistry.addMaterialStats((Material)material, (IMaterialStats)this.headMaterialStats);
        }
    }

    private void registerHandleStats(Material material, MaterialConfigOptions properties) {
        if (null == material.getStats("handle") && null != this.handleMaterialStats && properties.isHandleEnabled()) {
            TinkerRegistry.addMaterialStats((Material)material, (IMaterialStats)this.handleMaterialStats);
        }
    }

    private void registerExtraStats(Material material, MaterialConfigOptions properties) {
        if (null == material.getStats("extra") && null != this.extraMaterialStats && properties.isExtraEnabled()) {
            TinkerRegistry.addMaterialStats((Material)material, (IMaterialStats)this.extraMaterialStats);
        }
    }
}

