/*
 * Decompiled with CFR 0.152.
 */
package org.softc.armoryexpansion.common.integration.aelib.plugins.tinkersconstruct.material;

import org.softc.armoryexpansion.common.integration.aelib.config.MaterialConfigOptions;
import org.softc.armoryexpansion.common.integration.aelib.plugins.general.material.BasicMaterial;
import org.softc.armoryexpansion.common.integration.aelib.plugins.tinkersconstruct.material.IRangedMaterial;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.ArrowShaftMaterialStats;
import slimeknights.tconstruct.library.materials.BowMaterialStats;
import slimeknights.tconstruct.library.materials.BowStringMaterialStats;
import slimeknights.tconstruct.library.materials.FletchingMaterialStats;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.materials.ProjectileMaterialStats;

public class RangedMaterial
extends BasicMaterial
implements IRangedMaterial {
    protected BowMaterialStats bowMaterialStats;
    protected BowStringMaterialStats bowStringMaterialStats;
    protected ArrowShaftMaterialStats arrowShaftMaterialStats;
    protected FletchingMaterialStats fletchingMaterialStats;
    protected ProjectileMaterialStats projectileMaterialStats;

    @Override
    public BowMaterialStats getBowMaterialStats() {
        return this.bowMaterialStats;
    }

    @Override
    public BowStringMaterialStats getBowStringMaterialStats() {
        return this.bowStringMaterialStats;
    }

    @Override
    public ArrowShaftMaterialStats getArrowShaftMaterialStats() {
        return this.arrowShaftMaterialStats;
    }

    @Override
    public FletchingMaterialStats getFletchingMaterialStats() {
        return this.fletchingMaterialStats;
    }

    @Override
    public ProjectileMaterialStats getProjectileMaterialStats() {
        return this.projectileMaterialStats;
    }

    @Override
    public boolean isToolMaterial() {
        return false;
    }

    @Override
    public boolean isArmorMaterial() {
        return false;
    }

    @Override
    public boolean isRangedMaterial() {
        return null != this.arrowShaftMaterialStats || null != this.bowMaterialStats || null != this.bowStringMaterialStats || null != this.fletchingMaterialStats || null != this.projectileMaterialStats;
    }

    @Override
    public boolean registerTinkersMaterialStats(MaterialConfigOptions properties) {
        if (properties.materialEnabled()) {
            Material material = TinkerRegistry.getMaterial((String)this.getIdentifier());
            this.registerRangedStats(material, properties);
            return true;
        }
        return false;
    }

    protected void registerRangedStats(Material material, MaterialConfigOptions properties) {
        if (this.isRangedMaterial()) {
            this.registerBowStats(material, properties);
            this.registerBowStringStats(material, properties);
            this.registerFletchingStats(material, properties);
            this.registerProjectileStats(material, properties);
        }
    }

    protected void registerBowStats(Material material, MaterialConfigOptions properties) {
        if (null == material.getStats("bow") && null != this.bowMaterialStats && properties.isBowEnabled()) {
            TinkerRegistry.addMaterialStats((Material)material, (IMaterialStats)this.bowMaterialStats);
        }
    }

    protected void registerBowStringStats(Material material, MaterialConfigOptions properties) {
        if (null == material.getStats("bowstring") && null != this.bowStringMaterialStats && properties.isBowStringEnabled()) {
            TinkerRegistry.addMaterialStats((Material)material, (IMaterialStats)this.bowStringMaterialStats);
        }
    }

    protected void registerFletchingStats(Material material, MaterialConfigOptions properties) {
        if (null == material.getStats("fletching") && null != this.fletchingMaterialStats && properties.isFletchingEnabled()) {
            TinkerRegistry.addMaterialStats((Material)material, (IMaterialStats)this.fletchingMaterialStats);
        }
    }

    protected void registerProjectileStats(Material material, MaterialConfigOptions properties) {
        if (null == material.getStats("projectile") && null != this.projectileMaterialStats && properties.isProjectileEnabled()) {
            TinkerRegistry.addMaterialStats((Material)material, (IMaterialStats)this.projectileMaterialStats);
        }
    }
}

