/*
 * Decompiled with CFR 0.152.
 */
package org.softc.armoryexpansion.common.integration.aelib.integration;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Logger;
import org.softc.armoryexpansion.ArmoryExpansion;
import org.softc.armoryexpansion.common.integration.aelib.config.IntegrationConfig;
import org.softc.armoryexpansion.common.integration.aelib.config.MaterialConfigOptions;
import org.softc.armoryexpansion.common.integration.aelib.integration.IIntegration;
import org.softc.armoryexpansion.common.integration.aelib.plugins.constructsarmory.material.ArmorToolMaterial;
import org.softc.armoryexpansion.common.integration.aelib.plugins.constructsarmory.material.ArmorToolRangedMaterial;
import org.softc.armoryexpansion.common.integration.aelib.plugins.general.material.IBasicMaterial;
import org.softc.armoryexpansion.common.integration.aelib.plugins.general.oredictionary.BasicOreDictionary;
import org.softc.armoryexpansion.common.integration.aelib.plugins.general.oredictionary.IOreDictionary;
import org.softc.armoryexpansion.common.integration.aelib.plugins.general.traits.MaterialTraits;
import org.softc.armoryexpansion.common.integration.aelib.plugins.tinkersconstruct.alloys.Alloy;
import org.softc.armoryexpansion.common.integration.aelib.plugins.tinkersconstruct.alloys.IAlloy;
import org.softc.armoryexpansion.common.util.ConfigFileSuffixEnum;

public abstract class AbstractIntegration
implements IIntegration {
    protected Logger logger;
    protected String modId = "";
    protected String root = "";
    protected String configDir;
    protected IntegrationConfig integrationConfigHelper = new IntegrationConfig();
    protected Map<String, IBasicMaterial> materials = new HashMap<String, IBasicMaterial>();
    protected Map<String, MaterialTraits> materialTraits = new HashMap<String, MaterialTraits>();
    protected Map<String, IOreDictionary> oreDictionaryEntries = new HashMap<String, IOreDictionary>();
    protected Map<String, IAlloy> alloys = new HashMap<String, IAlloy>();

    protected AbstractIntegration() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    protected AbstractIntegration(String modId, String root) {
        this();
        this.modId = modId;
        this.root = root;
    }

    @Override
    public boolean isLoadable() {
        return Loader.isModLoaded((String)this.modId) && ArmoryExpansion.isIntegrationEnabled(this.modId);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        this.logger = event.getModLog();
        this.configDir = event.getModConfigurationDirectory().getPath();
        if (this.isLoadable()) {
            this.loadIntegrationData(this.configDir);
            this.integrationConfigHelper.syncConfig(this.materials);
            this.saveIntegrationData(this.configDir);
            this.registerMaterials();
            this.registerMaterialFluids();
        }
        ArmoryExpansion.getConfig().save();
    }

    @Override
    public void init(FMLInitializationEvent event) {
        if (this.isLoadable()) {
            this.oredictMaterials();
            this.updateMaterials();
            this.registerMaterialTraits();
        }
        ArmoryExpansion.getConfig().save();
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
    }

    @Override
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void registerItems(RegistryEvent<Item> event) {
        if (this.isLoadable()) {
            this.registerMaterialStats();
            this.registerMaterialFluidsIMC();
            this.registerAlloys();
        }
        ArmoryExpansion.getConfig().save();
    }

    @Override
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void registerBlocks(RegistryEvent.Register<? super Block> event) {
        if (ArmoryExpansion.isIntegrationEnabled(this.modId)) {
            this.registerFluidBlocks(event);
        }
    }

    protected void loadIntegrationData(String path) {
        this.loadConfig(path);
        this.loadMaterials(path);
        this.loadTraits(path);
        this.loadOreDictionaryEntries(path);
        this.loadAlloys(path);
    }

    protected void saveIntegrationData(String path) {
        this.saveConfig(path);
        this.saveMaterials(path);
        this.saveTraits(path);
        this.saveOreDictionaryEntries(path);
        this.saveAlloys(path);
    }

    protected void loadTraits(String path) {
        this.loadTraitsFromJson(new File(path), this.modId);
        this.logger.info("Done loading all material traits from local JSON files");
        this.loadTraitsFromSource();
        this.logger.info("Done loading all material traits from source");
    }

    protected void saveTraits(String path) {
        this.saveTraitsToJson(new File(path), this.modId, this.enableForceJsonCreation());
        this.logger.info("Done saving all material traits to local JSON files");
    }

    protected void saveTraitsToJson(File dir, String fileName, boolean forceCreate) {
        if (!this.materialTraits.values().isEmpty() || forceCreate) {
            Gson gson = new GsonBuilder().setPrettyPrinting().setLenient().create();
            File output = new File(this.getFilePath(dir, fileName, ConfigFileSuffixEnum.TRAITS_SUFFIX));
            output.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(output);){
                writer.write(gson.toJson(this.materialTraits.values()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void loadTraits(MaterialTraits[] jsonMaterials) {
        if (null != jsonMaterials) {
            for (MaterialTraits material : jsonMaterials) {
                this.materialTraits.putIfAbsent(material.getIdentifier(), material);
            }
        }
    }

    protected void loadTraitsFromJson(File dir, String fileName) {
        Gson gson = new GsonBuilder().setPrettyPrinting().setLenient().create();
        MaterialTraits[] jsonMaterials = new MaterialTraits[]{};
        try {
            File input = new File(this.getFilePath(dir, fileName, ConfigFileSuffixEnum.TRAITS_SUFFIX));
            if (input.exists()) {
                jsonMaterials = (MaterialTraits[])gson.fromJson((Reader)new FileReader(input), MaterialTraits[].class);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        this.loadTraits(jsonMaterials);
    }

    protected abstract void loadTraitsFromSource();

    protected void loadMaterials(String path) {
        this.loadMaterialsFromJson(new File(path), this.modId);
        this.logger.info("Done loading all materials from local JSON files");
        this.loadMaterialsFromSource();
        this.logger.info("Done loading all materials from source");
    }

    protected void saveMaterials(String path) {
        this.saveMaterialsToJson(new File(path), this.modId, this.enableForceJsonCreation());
        this.logger.info("Done saving all materials to local JSON files");
    }

    protected void saveMaterialsToJson(File dir, String fileName, boolean forceCreate) {
        if (!this.materials.values().isEmpty() || forceCreate) {
            Gson gson = new GsonBuilder().setPrettyPrinting().setLenient().create();
            File output = new File(this.getFilePath(dir, fileName, ConfigFileSuffixEnum.MATERIALS_SUFFIX));
            output.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(output);){
                writer.write(gson.toJson(this.materials.values()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void loadMaterials(ArmorToolMaterial[] jsonMaterials) {
        if (null != jsonMaterials) {
            for (ArmorToolMaterial material : jsonMaterials) {
                this.materials.putIfAbsent(material.getIdentifier(), material);
            }
        }
    }

    protected void loadMaterialsFromJson(File dir, String fileName) {
        Gson gson = new GsonBuilder().setPrettyPrinting().setLenient().create();
        ArmorToolMaterial[] jsonMaterials = new ArmorToolRangedMaterial[]{};
        try {
            File input = new File(this.getFilePath(dir, fileName, ConfigFileSuffixEnum.MATERIALS_SUFFIX));
            if (input.exists()) {
                jsonMaterials = (ArmorToolRangedMaterial[])gson.fromJson((Reader)new FileReader(input), ArmorToolRangedMaterial[].class);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        this.loadMaterials(jsonMaterials);
    }

    protected abstract void loadMaterialsFromSource();

    protected void loadOreDictionaryEntries(String path) {
        this.loadOreDictionaryEntriesFromJson(new File(path), this.modId);
        this.logger.info("Done loading all ore dictionary entries from local JSON files");
        this.loadOreDictionaryEntriesFromSource();
        this.logger.info("Done loading all ore dictionary entries from source");
    }

    protected void saveOreDictionaryEntries(String path) {
        this.saveOreDictionaryEntriesToJson(new File(path), this.modId, this.enableForceJsonCreation());
        this.logger.info("Done saving all ore dictionary entries to local JSON files");
    }

    protected void saveOreDictionaryEntriesToJson(File dir, String fileName, boolean forceCreate) {
        if (!this.oreDictionaryEntries.values().isEmpty() || forceCreate) {
            Gson gson = new GsonBuilder().setPrettyPrinting().setLenient().create();
            File output = new File(this.getFilePath(dir, fileName, ConfigFileSuffixEnum.ORE_DICT_ENTRIES_SUFFIX));
            output.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(output);){
                writer.write(gson.toJson(this.oreDictionaryEntries.values()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void loadOreDictionaryEntries(IOreDictionary[] jsonOreDicts) {
        if (null != jsonOreDicts) {
            for (IOreDictionary iOreDictionary : jsonOreDicts) {
                this.oreDictionaryEntries.putIfAbsent(iOreDictionary.getIdentifier(), iOreDictionary);
            }
        }
    }

    protected void loadOreDictionaryEntriesFromJson(File dir, String fileName) {
        Gson gson = new GsonBuilder().setPrettyPrinting().setLenient().create();
        IOreDictionary[] jsonMaterials = new BasicOreDictionary[]{};
        try {
            File input = new File(this.getFilePath(dir, fileName, ConfigFileSuffixEnum.ORE_DICT_ENTRIES_SUFFIX));
            if (input.exists()) {
                jsonMaterials = (IOreDictionary[])gson.fromJson((Reader)new FileReader(input), BasicOreDictionary[].class);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        this.loadOreDictionaryEntries(jsonMaterials);
    }

    protected abstract void loadOreDictionaryEntriesFromSource();

    protected void loadAlloys(String path) {
        this.loadAlloysFromJson(new File(path), this.modId);
        this.logger.info("Done loading all alloys from local JSON files");
        this.loadAlloysFromSource();
        this.logger.info("Done loading all alloys from source");
    }

    protected void saveAlloys(String path) {
        this.saveAlloysToJson(new File(path), this.modId, this.enableForceJsonCreation());
        this.logger.info("Done saving all alloys to local JSON files");
    }

    protected void saveAlloysToJson(File dir, String fileName, boolean forceCreate) {
        if (!this.alloys.values().isEmpty() || forceCreate) {
            Gson gson = new GsonBuilder().setPrettyPrinting().setLenient().create();
            File output = new File(this.getFilePath(dir, fileName, ConfigFileSuffixEnum.ALLOYS_SUFFIX));
            output.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(output);){
                writer.write(gson.toJson(this.alloys.values()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void loadAlloys(Alloy[] jsonAlloys) {
        if (null != jsonAlloys) {
            for (Alloy a : jsonAlloys) {
                this.alloys.putIfAbsent(a.getName(), a);
            }
        }
    }

    protected void loadAlloysFromJson(File dir, String fileName) {
        Gson gson = new GsonBuilder().setPrettyPrinting().setLenient().create();
        Alloy[] jsonAlloys = new Alloy[]{};
        try {
            File input = new File(this.getFilePath(dir, fileName, ConfigFileSuffixEnum.ALLOYS_SUFFIX));
            if (input.exists()) {
                jsonAlloys = (Alloy[])gson.fromJson((Reader)new FileReader(input), Alloy[].class);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        this.loadAlloys(jsonAlloys);
    }

    protected abstract void loadAlloysFromSource();

    protected void loadConfig(String path) {
        this.loadConfigFromJson(new File(path), this.modId);
        this.logger.info("Done loading config from local JSON file");
        this.loadConfigFromSource();
        this.logger.info("Done loading config from source");
    }

    protected void saveConfig(String path) {
        this.saveConfigToJson(new File(path), this.modId, this.enableForceJsonCreation());
        this.logger.info("Done saving config to local JSON file");
    }

    protected void saveConfigToJson(File dir, String fileName, boolean forceCreate) {
        if (!this.materials.values().isEmpty() || forceCreate) {
            Gson gson = new GsonBuilder().setPrettyPrinting().setLenient().create();
            File output = new File(this.getFilePath(dir, fileName, ConfigFileSuffixEnum.CONFIG_SUFFIX));
            output.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(output);){
                writer.write(gson.toJson((Object)this.integrationConfigHelper.getIntegrationMaterials().values().toArray()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void loadConfig(MaterialConfigOptions[] materialConfig) {
        if (null != materialConfig) {
            if (null == this.integrationConfigHelper) {
                this.integrationConfigHelper = new IntegrationConfig();
            }
            for (MaterialConfigOptions material : materialConfig) {
                this.integrationConfigHelper.insertMaterialConfigOptions(material);
            }
        }
    }

    protected void loadConfigFromJson(File dir, String fileName) {
        Gson gson = new GsonBuilder().setPrettyPrinting().setLenient().create();
        MaterialConfigOptions[] jsonConfig = new MaterialConfigOptions[]{};
        try {
            File input = new File(this.getFilePath(dir, fileName, ConfigFileSuffixEnum.CONFIG_SUFFIX));
            if (input.exists()) {
                jsonConfig = (MaterialConfigOptions[])gson.fromJson((Reader)new FileReader(input), MaterialConfigOptions[].class);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        this.loadConfig(jsonConfig);
    }

    protected abstract void loadConfigFromSource();

    @Override
    public void oredictMaterials() {
        this.materials.values().forEach(material -> {
            if (this.isMaterialEnabled(material.getIdentifier())) {
                IOreDictionary oreDictionary = this.oreDictionaryEntries.get(material.getIdentifier());
                if (null != oreDictionary) {
                    oreDictionary.registerOreDict();
                }
                this.logger.info("Oredicted material {" + material.getIdentifier() + "};");
            }
        });
    }

    @Override
    public void registerMaterials() {
        this.materials.values().forEach(material -> {
            if (material.registerTinkersMaterial(this.isMaterialEnabled(material.getIdentifier()))) {
                this.logger.info("Registered tinker's material {" + material.getIdentifier() + "};");
            }
        });
    }

    @Override
    public void registerMaterialFluids() {
        this.materials.values().forEach(material -> {
            if (material.registerTinkersFluid(this.isMaterialEnabled(material.getIdentifier()) && this.isMaterialFluidEnabled(material.getIdentifier()))) {
                this.logger.info("Registered fluid for material {" + material.getIdentifier() + "};");
            }
        });
    }

    @Override
    public void registerMaterialFluidsIMC() {
        this.materials.values().forEach(material -> {
            if (material.registerTinkersFluidIMC(this.isMaterialEnabled(material.getIdentifier()) && this.isMaterialFluidEnabled(material.getIdentifier()))) {
                this.logger.info("Sent IMC for tinker's fluid {" + material.getFluidName() + "};");
            }
        });
    }

    @Override
    public void registerFluidBlocks(RegistryEvent.Register<? super Block> event) {
        this.materials.values().forEach(material -> {
            if (material.isCastable()) {
                event.getRegistry().register((IForgeRegistryEntry)material.getFluidBlock());
                this.logger.info("Registered fluid block for material {" + material.getIdentifier() + "};");
            }
        });
    }

    @Override
    public void registerAlloys() {
        this.alloys.values().forEach(a -> {
            a.registerTiCAlloy();
            this.logger.info("Sent IMC for tinker's alloy {" + a.getName() + "};");
        });
    }

    @Override
    public void registerMaterialStats() {
        this.materials.values().forEach(material -> {
            if (material.registerTinkersMaterialStats(this.getProperties((IBasicMaterial)material))) {
                this.logger.info("Registered stats for tinker's material {" + material.getIdentifier() + "};");
            }
        });
    }

    @Override
    public void updateMaterials() {
        this.materials.values().forEach(material -> {
            IOreDictionary oreDictionaryEntry = this.oreDictionaryEntries.get(material.getIdentifier());
            if (null != oreDictionaryEntry && oreDictionaryEntry.updateTinkersMaterial(this.isMaterialEnabled(material.getIdentifier()))) {
                this.logger.info("Updated tinker's material {" + material.getIdentifier() + "};");
            }
        });
    }

    @Override
    public void registerMaterialTraits() {
        this.materialTraits.values().forEach(traits -> {
            if (traits.registerTinkersMaterialTraits(this.isMaterialEnabled(traits.getIdentifier()) && this.integrationConfigHelper.traitsEnabled(traits.getIdentifier()))) {
                this.logger.info("Registered traits for tinker's traits {" + traits.getIdentifier() + "};");
            }
        });
    }

    @Override
    public boolean isMaterialEnabled(String material) {
        return this.integrationConfigHelper.materialEnabled(material);
    }

    @Override
    public boolean isMaterialFluidEnabled(String material) {
        return this.integrationConfigHelper.fluidEnabled(material);
    }

    protected MaterialConfigOptions getProperties(IBasicMaterial material) {
        return this.integrationConfigHelper.getSafeMaterialConfigOptions(material.getIdentifier());
    }

    protected String getFilePath(File dir, String fileName, ConfigFileSuffixEnum suffix) {
        return dir.getPath() + "/" + this.root + "/" + fileName + "/" + fileName + suffix.getSuffix() + ".json";
    }

    protected boolean enableForceJsonCreation() {
        return false;
    }
}

