/*
 * Decompiled with CFR 0.152.
 */
package org.softc.armoryexpansion.common.integration.aelib.config;

import java.util.HashMap;
import java.util.Map;
import org.softc.armoryexpansion.common.integration.aelib.config.MaterialConfigOptions;
import org.softc.armoryexpansion.common.integration.aelib.plugins.general.material.IBasicMaterial;

public class IntegrationConfig {
    private static MaterialConfigOptions defaultMaterialConfigOptions;
    private Map<String, MaterialConfigOptions> integrationMaterials = new HashMap<String, MaterialConfigOptions>();

    private static MaterialConfigOptions getDefault() {
        if (null == defaultMaterialConfigOptions) {
            defaultMaterialConfigOptions = new MaterialConfigOptions();
        }
        return defaultMaterialConfigOptions;
    }

    public void insertMaterialConfigOptions(MaterialConfigOptions materialConfigOptions) {
        if (!this.integrationMaterials.containsKey(materialConfigOptions.name)) {
            this.integrationMaterials.put(materialConfigOptions.getName(), materialConfigOptions);
        }
    }

    public MaterialConfigOptions getSafeMaterialConfigOptions(String identifier) {
        return this.integrationMaterials.getOrDefault(identifier, IntegrationConfig.getDefault());
    }

    public Map<String, MaterialConfigOptions> getIntegrationMaterials() {
        return null == this.integrationMaterials ? new HashMap() : this.integrationMaterials;
    }

    public void syncConfig(Map<String, ? extends IBasicMaterial> materials) {
        materials.values().forEach(material -> this.insertMaterialConfigOptions(new MaterialConfigOptions((IBasicMaterial)material)));
    }

    public boolean materialEnabled(String material) {
        return this.getSafeMaterialConfigOptions(material).materialEnabled();
    }

    public boolean fluidEnabled(String material) {
        return this.getSafeMaterialConfigOptions(material).fluidEnabled();
    }

    public boolean traitsEnabled(String material) {
        return this.getSafeMaterialConfigOptions(material).traitsEnabled();
    }
}

