/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.world.sphere.structures;

import aroma1997.world.sphere.Sphere;
import aroma1997.world.sphere.sphereproviders.ISphereInfoProvider;
import java.util.Iterator;
import java.util.Optional;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStart;

public class MapGenVillageSphere
extends MapGenVillage {
    private final ISphereInfoProvider info;

    public MapGenVillageSphere(ISphereInfoProvider info) {
        this.info = info;
    }

    protected boolean func_75047_a(int chunkX, int chunkZ) {
        Optional<Sphere> sphere = this.info.getSphereStream(new ChunkPos(chunkX, chunkZ), 0).findAny();
        if (!sphere.isPresent()) {
            return false;
        }
        Sphere s = sphere.get();
        return s.hasVillage() && field_75055_e.contains(s.getBiome());
    }

    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        ChunkPos chunk = new ChunkPos(chunkX, chunkZ);
        StructureStart start = super.func_75049_b(chunkX, chunkZ);
        Iterator iter = start.func_186161_c().iterator();
        while (iter.hasNext()) {
            StructureComponent component = (StructureComponent)iter.next();
            StructureBoundingBox bb = component.func_74874_b();
            double xMid = (double)(bb.field_78893_d + bb.field_78897_a) / 2.0;
            double zMid = (double)(bb.field_78892_f + bb.field_78896_c) / 2.0;
            if (!this.info.getSphereStream(chunk, 20).noneMatch(sphere -> {
                double zDiff;
                BlockPos center = sphere.getCenter();
                double xDiff = xMid - (double)center.func_177958_n();
                return xDiff * xDiff + (zDiff = zMid - (double)center.func_177952_p()) * zDiff < ((double)sphere.getRadius() - 2.0) * ((double)sphere.getRadius() - 2.0);
            })) continue;
            iter.remove();
        }
        return start;
    }

    public BlockPos func_180706_b(World worldIn, BlockPos pos, boolean findUnexplored) {
        return this.info.getSphereStream(new ChunkPos(pos), 200).filter(Sphere::hasVillage).filter(sphere -> field_75055_e.contains(sphere.getBiome())).findFirst().map(Sphere::getCenter).orElse(null);
    }
}

