/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.world.sphere.sphereproviders;

import aroma1997.world.sphere.Sphere;
import aroma1997.world.sphere.sphereproviders.ISphereInfoProvider;
import java.util.Collection;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.stream.Stream;
import net.minecraft.util.math.ChunkPos;

public class BufferedSphereProvider
implements ISphereInfoProvider {
    private final ISphereInfoProvider delegate;
    private final Map<ChunkPos, Collection<Sphere>> buffer = new WeakHashMap<ChunkPos, Collection<Sphere>>();

    public BufferedSphereProvider(ISphereInfoProvider delegate) {
        this.delegate = delegate;
    }

    @Override
    public Collection<Sphere> getInfluencedSpheres(ChunkPos pos) {
        Collection<Sphere> list = this.buffer.get(pos);
        if (list == null) {
            list = this.delegate.getInfluencedSpheres(pos);
            this.buffer.put(pos, list);
        }
        return list;
    }

    @Override
    public Stream<Sphere> getSphereStream(ChunkPos center, int radius) {
        return this.delegate.getSphereStream(center, radius);
    }
}

