/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.world.sphere.dimension;

import aroma1997.world.sphere.Sphere;
import aroma1997.world.sphere.SphereHelper;
import aroma1997.world.sphere.sphereproviders.ISphereInfoProvider;
import aroma1997.world.sphere.structures.MapGenStrongholdSphere;
import aroma1997.world.sphere.structures.MapGenVillageSphere;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.MapGenCaves;
import net.minecraft.world.gen.MapGenRavine;
import net.minecraft.world.gen.structure.MapGenScatteredFeature;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class ChunkGeneratorSphere
implements IChunkGenerator {
    private final World world;
    private final long seed;
    private final ISphereInfoProvider spheres;
    private final List<MapGenBase> structures = new ArrayList<MapGenBase>();

    public ChunkGeneratorSphere(World world, ISphereInfoProvider sphereInfo, boolean generateStructures) {
        this.world = world;
        this.seed = world.func_72905_C();
        this.spheres = sphereInfo;
        if (generateStructures) {
            this.structures.add((MapGenBase)new MapGenCaves());
            this.structures.add((MapGenBase)new MapGenRavine());
            this.structures.add((MapGenBase)new MapGenVillageSphere(sphereInfo));
            this.structures.add((MapGenBase)new MapGenStrongholdSphere(sphereInfo));
            this.structures.add((MapGenBase)new MapGenScatteredFeature());
        }
    }

    public Chunk func_185932_a(int chunkX, int chunkZ) {
        Random rng = new Random((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L + this.seed);
        ChunkPrimer primer = new ChunkPrimer(){

            public void func_177855_a(int x, int y, int z, IBlockState state) {
                if (state.func_177230_c() != Blocks.field_150357_h) {
                    super.func_177855_a(x, y, z, state);
                }
            }
        };
        this.setBlocksInChunk(chunkX, chunkZ, primer);
        Biome[] biomes = this.world.func_72959_q().func_76937_a(null, chunkX << 4, chunkZ << 4, 16, 16);
        byte[] biomeArray = new byte[biomes.length];
        for (int xD = 0; xD < 16; ++xD) {
            int x = chunkX << 4 | xD;
            for (int zD = 0; zD < 16; ++zD) {
                int z = chunkZ << 4 | zD;
                int idx = xD << 4 | zD;
                biomes[idx].func_180622_a(this.world, rng, primer, x, z, 0.0);
                biomeArray[idx] = (byte)Biome.func_185362_a((Biome)biomes[idx]);
            }
        }
        for (MapGenBase gen : this.structures) {
            gen.func_186125_a(this.world, chunkX, chunkZ, primer);
        }
        Chunk chunk = new Chunk(this.world, primer, chunkX, chunkZ);
        chunk.func_76616_a(biomeArray);
        chunk.func_76603_b();
        return chunk;
    }

    public void setBlocksInChunk(int chunkX, int chunkZ, ChunkPrimer primer) {
        BlockPos.MutableBlockPos realPos = new BlockPos.MutableBlockPos();
        ArrayList<Sphere> influencedSpheres = new ArrayList<Sphere>(this.spheres.getInfluencedSpheres(new ChunkPos(chunkX, chunkZ)));
        Collections.sort(influencedSpheres, Comparator.comparingInt(sphere -> sphere.getCenter().func_177956_o()));
        for (Sphere sphere2 : influencedSpheres) {
            BlockPos center = sphere2.getCenter().func_177982_a(-(chunkX << 4), 0, -(chunkZ << 4));
            int r = sphere2.getRadius();
            BlockPos min = SphereHelper.limitBlockPosToChunk(center.func_177982_a(-r, -r, -r));
            BlockPos max = SphereHelper.limitBlockPosToChunk(center.func_177982_a(r + 1, r + 1, r + 1));
            Iterator<BlockPos> iter = SphereHelper.iteratePositions(min, max);
            while (iter.hasNext()) {
                BlockPos current = iter.next();
                if (!(center.func_177951_i((Vec3i)current) < (double)(r * r))) continue;
                realPos.func_181079_c(current.func_177958_n() + (chunkX << 4), current.func_177956_o(), current.func_177952_p() + (chunkZ << 4));
                IBlockState blockToSet = sphere2.getBlockState((BlockPos)realPos);
                if (blockToSet == null) continue;
                primer.func_177855_a(current.func_177958_n() & 0xF, current.func_177956_o(), current.func_177952_p() & 0xF, blockToSet);
            }
        }
    }

    public void func_185931_b(int chunkX, int chunkZ) {
        ChunkPos pos = new ChunkPos(chunkX, chunkZ);
        BlockFalling.field_149832_M = false;
        Random rng = new Random();
        rng.setSeed(this.world.func_72905_C());
        long k = rng.nextLong() / 2L * 2L + 1L;
        long l = rng.nextLong() / 2L * 2L + 1L;
        rng.setSeed((long)chunkX * k + (long)chunkZ * l ^ this.world.func_72905_C());
        BlockPos bottomLeft = new BlockPos(chunkX << 4, 0, chunkZ << 4);
        Biome biome = this.world.func_180494_b(bottomLeft.func_177982_a(16, 0, 16));
        ForgeEventFactory.onChunkPopulate((boolean)true, (IChunkGenerator)this, (World)this.world, (Random)rng, (int)chunkX, (int)chunkZ, (boolean)false);
        biome.func_180624_a(this.world, rng, bottomLeft);
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)rng, (int)chunkX, (int)chunkZ, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ANIMALS)) {
            WorldEntitySpawner.func_77191_a((World)this.world, (Biome)biome, (int)(bottomLeft.func_177958_n() + 8), (int)(bottomLeft.func_177952_p() + 8), (int)16, (int)16, (Random)rng);
            WorldEntitySpawner.func_77191_a((World)this.world, (Biome)biome, (int)(bottomLeft.func_177958_n() + 8), (int)(bottomLeft.func_177952_p() + 8), (int)16, (int)16, (Random)rng);
        }
        this.getStructures().forEach(gen -> gen.func_175794_a(this.world, rng, pos));
        ForgeEventFactory.onChunkPopulate((boolean)false, (IChunkGenerator)this, (World)this.world, (Random)rng, (int)chunkX, (int)chunkZ, (boolean)false);
        BlockFalling.field_149832_M = true;
    }

    public boolean func_185933_a(Chunk chunk, int chunkX, int chunkZ) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        return this.world.func_180494_b(pos).func_76747_a(creatureType);
    }

    @Nullable
    public BlockPos func_180513_a(World world, String name, BlockPos serachPos, boolean findUnexplored) {
        Optional<MapGenStructure> opt = this.getStructure(name);
        if (!opt.isPresent()) {
            return null;
        }
        MapGenStructure structure = opt.get();
        return structure.func_180706_b(world, serachPos, findUnexplored);
    }

    public void func_180514_a(Chunk chunk, int chunkX, int chunkZ) {
        this.getStructures().forEach(structure -> structure.func_186125_a(this.world, chunkX, chunkZ, null));
    }

    public boolean func_193414_a(World world, String name, BlockPos pos) {
        Optional<MapGenStructure> opt = this.getStructure(name);
        if (!opt.isPresent()) {
            return false;
        }
        return opt.get().func_175795_b(pos);
    }

    public Optional<MapGenStructure> getStructure(String name) {
        return this.getStructures().filter(struct -> struct.func_143025_a().equals(name)).findAny();
    }

    public Stream<MapGenStructure> getStructures() {
        return this.structures.stream().filter(gen -> gen instanceof MapGenStructure).map(gen -> (MapGenStructure)gen);
    }
}

