/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.world.dimension;

import aroma1997.world.Config;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.MapGenCaves;
import net.minecraft.world.gen.MapGenRavine;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.MapGenMineshaft;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class ChunkGeneratorMining
implements IChunkGenerator {
    private static final IBlockState STONE = Blocks.field_150348_b.func_176223_P();
    private final List<Tuple<? extends MapGenBase, BooleanSupplier>> mapGen = new ArrayList<Tuple<? extends MapGenBase, BooleanSupplier>>();
    private final List<Tuple<? extends WorldGenerator, BooleanSupplier>> worldGen = new ArrayList<Tuple<? extends WorldGenerator, BooleanSupplier>>();
    private final World world;
    private final long seed;
    private Random rng;

    public ChunkGeneratorMining(World world, long seed) {
        this.addMapGen(TerrainGen.getModdedMapGen((MapGenBase)new MapGenCaves(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.CAVE), () -> Config.INSTANCE.generateCaves);
        this.addMapGen(TerrainGen.getModdedMapGen((MapGenBase)new MapGenRavine(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.RAVINE), () -> Config.INSTANCE.generateRavines);
        this.addMapGen(TerrainGen.getModdedMapGen((MapGenBase)new MapGenMineshaft(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.MINESHAFT), () -> Config.INSTANCE.generateMineshafts);
        this.addMapGen(TerrainGen.getModdedMapGen((MapGenBase)new MapGenStronghold(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.STRONGHOLD), () -> Config.INSTANCE.generateStrongholds);
        this.addMapGen(TerrainGen.getModdedMapGen((MapGenBase)new MapGenVillage(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.VILLAGE), () -> Config.INSTANCE.generateVillages);
        this.world = world;
        this.seed = seed;
    }

    public void setBlocksInChunk(int chunkX, int chunkZ, ChunkPrimer primer) {
        int height = Config.INSTANCE.worldHeight;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < height; ++y) {
                    primer.func_177855_a(x, y, z, STONE);
                }
            }
        }
    }

    public Chunk func_185932_a(int chunkX, int chunkZ) {
        this.rng = new Random((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L + this.seed);
        ChunkPrimer primer = new ChunkPrimer();
        this.setBlocksInChunk(chunkX, chunkZ, primer);
        Biome[] biomes = this.world.func_72959_q().func_76937_a(null, chunkX << 4, chunkZ << 4, 16, 16);
        for (int xD = 0; xD < 16; ++xD) {
            int x = chunkX << 4 | xD;
            for (int zD = 0; zD < 16; ++zD) {
                int z = chunkZ << 4 | zD;
                biomes[xD << 4 | zD].func_180622_a(this.world, this.rng, primer, x, z, 0.0);
            }
        }
        for (Tuple<? extends MapGenBase, BooleanSupplier> gen : this.mapGen) {
            if (!((BooleanSupplier)gen.func_76340_b()).getAsBoolean()) continue;
            ((MapGenBase)gen.func_76341_a()).func_186125_a(this.world, chunkX, chunkZ, primer);
        }
        Chunk chunk = new Chunk(this.world, primer, chunkX, chunkZ);
        chunk.func_76603_b();
        return chunk;
    }

    public void func_185931_b(int chunkX, int chunkZ) {
        this.rng = new Random(this.world.func_72905_C());
        this.rng.setSeed((long)chunkX * 16L * (this.rng.nextLong() / 2L * 2L + 1L) + (long)chunkZ * 16L * (this.rng.nextLong() / 2L * 2L + 1L) ^ this.world.func_72905_C());
        BlockFalling.field_149832_M = false;
        ChunkPos pos = new ChunkPos(chunkX, chunkZ);
        for (Tuple<? extends MapGenBase, BooleanSupplier> t : this.mapGen) {
            if (!((BooleanSupplier)t.func_76340_b()).getAsBoolean() || !(t.func_76341_a() instanceof MapGenStructure)) continue;
            ((MapGenStructure)t.func_76341_a()).func_175794_a(this.world, this.rng, pos);
        }
        Random rng = new Random();
        rng.setSeed(this.world.func_72905_C());
        long k = rng.nextLong() / 2L * 2L + 1L;
        long l = rng.nextLong() / 2L * 2L + 1L;
        rng.setSeed((long)chunkX * k + (long)chunkZ * l ^ this.world.func_72905_C());
        BlockPos bottomLeft = new BlockPos(chunkX << 4, 0, chunkZ << 4);
        Biome biome = this.world.func_180494_b(bottomLeft);
        for (int i = 0; i < Config.INSTANCE.oreGenMultiplier; ++i) {
            ForgeEventFactory.onChunkPopulate((boolean)true, (IChunkGenerator)this, (World)this.world, (Random)rng, (int)chunkX, (int)chunkZ, (boolean)false);
            biome.func_180624_a(this.world, rng, bottomLeft);
            ForgeEventFactory.onChunkPopulate((boolean)false, (IChunkGenerator)this, (World)this.world, (Random)rng, (int)chunkX, (int)chunkZ, (boolean)false);
        }
        BlockFalling.field_149832_M = true;
    }

    public boolean func_185933_a(Chunk chunk, int chunkX, int chunkZ) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        if (Config.INSTANCE.mobsToSpawn.contains(creatureType)) {
            return this.world.func_180494_b(pos).func_76747_a(creatureType);
        }
        return Collections.emptyList();
    }

    @Nullable
    public BlockPos func_180513_a(World world, String name, BlockPos serachPos, boolean findUnexplored) {
        MapGenStructure structure = this.getStructure(name);
        if (structure == null) {
            return null;
        }
        return structure.func_180706_b(world, serachPos, findUnexplored);
    }

    public void func_180514_a(Chunk chunk, int chunkX, int chunkZ) {
        for (Tuple<? extends MapGenBase, BooleanSupplier> t : this.mapGen) {
            if (!(t.func_76341_a() instanceof MapGenStructure)) continue;
            ((MapGenBase)t.func_76341_a()).func_186125_a(this.world, chunkX, chunkZ, null);
        }
    }

    public boolean func_193414_a(World world, String name, BlockPos pos) {
        MapGenStructure structure = this.getStructure(name);
        if (structure == null) {
            return false;
        }
        return structure.func_175796_a(world, pos);
    }

    private void addMapGen(MapGenBase gen, BooleanSupplier active) {
        Tuple t = new Tuple((Object)gen, (Object)active);
        this.mapGen.add((Tuple<? extends MapGenBase, BooleanSupplier>)t);
    }

    private void addWorldGen(WorldGenerator gen, BooleanSupplier active) {
        Tuple t = new Tuple((Object)gen, (Object)active);
        this.worldGen.add((Tuple<? extends WorldGenerator, BooleanSupplier>)t);
    }

    private MapGenStructure getStructure(String name) {
        return this.mapGen.stream().filter(t -> t.func_76341_a() instanceof MapGenStructure && ((MapGenStructure)t.func_76341_a()).func_143025_a().equals(name) && ((BooleanSupplier)t.func_76340_b()).getAsBoolean()).map(Tuple::func_76341_a).findFirst().orElse(null);
    }
}

