/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.world;

import aroma1997.core.command.AromaBaseCommand;
import aroma1997.core.command.AromaSubCommand;
import aroma1997.core.util.ServerUtil;
import aroma1997.world.Config;
import aroma1997.world.DimensionalWorld;
import aroma1997.world.sphere.SphereHelper;
import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class DimensionalWorldCommand
extends AromaSubCommand {
    public DimensionalWorldCommand() {
        super(new String[0]);
        this.addSubCommand((CommandBase)new ReloadConfigCommand());
        this.addSubCommand((CommandBase)new FindStructureCommand());
        this.addSubCommand((CommandBase)new ChunkCompositionCommand());
    }

    public static class ChunkCompositionCommand
    extends AromaBaseCommand {
        public ChunkCompositionCommand() {
            super(new String[0]);
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            Chunk chunk = sender.func_130014_f_().func_175726_f(sender.func_180425_c());
            Map histogram = Streams.stream(() -> SphereHelper.iteratePositions(BlockPos.field_177992_a, new BlockPos(16, 256, 16))).map(arg_0 -> ((Chunk)chunk).func_177435_g(arg_0)).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
            histogram.remove(Blocks.field_150350_a.func_176223_P());
            ArrayList states = new ArrayList(histogram.keySet());
            Collections.sort(states, Comparator.comparing(histogram::get));
            Collections.reverse(states);
            for (IBlockState state : states) {
                sender.func_145747_a(ServerUtil.getChatForString((String)(state.func_177230_c().func_149732_F() + " : " + histogram.get(state))));
            }
        }
    }

    public static class FindStructureCommand
    extends AromaBaseCommand {
        public FindStructureCommand() {
            super(new String[0]);
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            if (args.length != 1) {
                throw new CommandException("Invalid amount of arguments,", new Object[0]);
            }
            Entity e = sender.func_174793_f();
            sender.func_145747_a(ServerUtil.getChatForString((String)("" + ((WorldServer)e.field_70170_p).func_72863_F().func_180513_a(e.field_70170_p, args[0], e.func_180425_c(), true))));
        }

        public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
            return ServerUtil.isPlayerAdmin((ICommandSender)sender);
        }

        public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
            if (args.length == 1) {
                return FindStructureCommand.func_71530_a((String[])args, (String[])new String[]{"Stronghold", "Mansion", "Monument", "Village", "Mineshaft", "Temple", "EndCity", "Fortress"});
            }
            return Collections.emptyList();
        }
    }

    public static class ReloadConfigCommand
    extends AromaBaseCommand {
        public ReloadConfigCommand() {
            super(new String[0]);
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            Config.INSTANCE.loadReloadablesFromDisc();
            DimensionalWorld.instance.ph.sendPacketToPlayers((IMessage)Config.INSTANCE);
        }
    }
}

