/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.handlers;

import com.feed_the_beast.ftblib.lib.math.ChunkDimPos;
import com.feed_the_beast.ftbutilities.FTBUtilitiesConfig;
import com.feed_the_beast.ftbutilities.data.ClaimedChunk;
import com.feed_the_beast.ftbutilities.data.ClaimedChunks;
import com.feed_the_beast.ftbutilities.data.FTBUtilitiesUniverseData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="ftbutilities")
public class FTBUtilitiesWorldEventHandler {
    @SubscribeEvent
    public static void onMobSpawned(EntityJoinWorldEvent event) {
        if (!event.getWorld().field_72995_K && !FTBUtilitiesWorldEventHandler.isEntityAllowed(event.getEntity())) {
            event.getEntity().func_70106_y();
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onDimensionUnload(WorldEvent.Unload event) {
        if (ClaimedChunks.isActive() && event.getWorld().field_73011_w.getDimension() != 0) {
            ClaimedChunks.instance.markDirty();
        }
    }

    private static boolean isEntityAllowed(Entity entity) {
        if (entity instanceof EntityPlayer) {
            return true;
        }
        if (FTBUtilitiesConfig.world.safe_spawn && FTBUtilitiesUniverseData.isInSpawn(entity.func_184102_h(), new ChunkDimPos(entity))) {
            if (entity instanceof IMob) {
                return false;
            }
            return !(entity instanceof EntityChicken) || entity.func_184188_bt().isEmpty();
        }
        return true;
    }

    @SubscribeEvent
    public static void onExplosionDetonate(ExplosionEvent.Detonate event) {
        World world = event.getWorld();
        Explosion explosion = event.getExplosion();
        if (world.field_72995_K || explosion.func_180343_e().isEmpty()) {
            return;
        }
        ArrayList list = new ArrayList(explosion.func_180343_e());
        explosion.func_180342_d();
        HashMap<ChunkDimPos, Boolean> map = new HashMap<ChunkDimPos, Boolean>();
        MinecraftServer server = event.getWorld().func_73046_m();
        Function<ChunkDimPos, Boolean> func = pos -> {
            if (pos.dim == 0 && FTBUtilitiesConfig.world.safe_spawn && FTBUtilitiesUniverseData.isInSpawn(server, pos)) {
                return false;
            }
            if (FTBUtilitiesConfig.world.enable_explosions.isDefault()) {
                ClaimedChunk chunk = ClaimedChunks.isActive() ? ClaimedChunks.instance.getChunk((ChunkDimPos)pos) : null;
                return chunk == null || chunk.hasExplosions();
            }
            return FTBUtilitiesConfig.world.enable_explosions.isTrue();
        };
        for (BlockPos pos2 : list) {
            if (!map.computeIfAbsent(new ChunkDimPos(pos2, world.field_73011_w.getDimension()), func).booleanValue()) continue;
            explosion.func_180343_e().add(pos2);
        }
    }
}

