/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimensions.world.terrain.lost;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mcjty.rftoolsdim.config.LostCityConfiguration;
import mcjty.rftoolsdim.dimensions.world.terrain.lost.Explosion;
import mcjty.rftoolsdim.dimensions.world.terrain.lost.Style;
import mcjty.rftoolsdim.varia.GeometryTools;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public class DamageArea {
    public static final float BLOCK_DAMAGE_CHANCE = 0.7f;
    private final long seed;
    private final int chunkX;
    private final int chunkZ;
    private final List<Explosion> explosions = new ArrayList<Explosion>();
    private final AxisAlignedBB chunkBox;

    public DamageArea(long seed, int chunkX, int chunkZ) {
        this.seed = seed;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.chunkBox = new AxisAlignedBB((double)(chunkX * 16), 0.0, (double)(chunkZ * 16), (double)(chunkX * 16 + 15), 256.0, (double)(chunkZ * 16 + 15));
        int offset = (LostCityConfiguration.EXPLOSION_MAXRADIUS + 15) / 16;
        for (int cx = chunkX - offset; cx <= chunkX + offset; ++cx) {
            for (int cz = chunkZ - offset; cz <= chunkZ + offset; ++cz) {
                Explosion explosion = this.getExplosionAt(cx, cz);
                if (explosion != null && this.intersectsWith(explosion.getCenter(), explosion.getRadius())) {
                    this.explosions.add(explosion);
                }
                if ((explosion = this.getMiniExplosionAt(cx, cz)) == null || !this.intersectsWith(explosion.getCenter(), explosion.getRadius())) continue;
                this.explosions.add(explosion);
            }
        }
    }

    public IBlockState damageBlock(IBlockState b, IBlockState replacement, Random rand, int x, int y, int z, int index, Style style) {
        float damage = this.getDamage(x, y, z);
        if (style.isEasyToDestroy(b)) {
            damage *= 2.5f;
        }
        if (style.isLiquid(b)) {
            damage *= 10.0f;
        }
        if (rand.nextFloat() <= damage) {
            b = damage < 0.7f && style.canBeDamagedToIronBars(b) ? (rand.nextFloat() < 0.7f ? Blocks.field_150411_aY.func_176223_P() : replacement) : replacement;
        }
        return b;
    }

    private boolean intersectsWith(BlockPos center, int radius) {
        double dmin = GeometryTools.squaredDistanceBoxPoint(this.chunkBox, center);
        return dmin <= (double)(radius * radius);
    }

    private Explosion getExplosionAt(int chunkX, int chunkZ) {
        Random rand = new Random(this.seed + (long)chunkZ * 295075153L + (long)chunkX * 797003437L);
        rand.nextFloat();
        rand.nextFloat();
        if (rand.nextFloat() < LostCityConfiguration.EXPLOSION_CHANCE) {
            return new Explosion(LostCityConfiguration.EXPLOSION_MINRADIUS + rand.nextInt(LostCityConfiguration.EXPLOSION_MAXRADIUS - LostCityConfiguration.EXPLOSION_MINRADIUS), new BlockPos(chunkX * 16 + rand.nextInt(16), LostCityConfiguration.EXPLOSION_MINHEIGHT + rand.nextInt(LostCityConfiguration.EXPLOSION_MAXHEIGHT - LostCityConfiguration.EXPLOSION_MINHEIGHT), chunkZ * 16 + rand.nextInt(16)));
        }
        return null;
    }

    private Explosion getMiniExplosionAt(int chunkX, int chunkZ) {
        Random rand = new Random(this.seed + (long)chunkZ * 1400305337L + (long)chunkX * 573259391L);
        rand.nextFloat();
        rand.nextFloat();
        if (rand.nextFloat() < LostCityConfiguration.MINI_EXPLOSION_CHANCE) {
            return new Explosion(LostCityConfiguration.MINI_EXPLOSION_MINRADIUS + rand.nextInt(LostCityConfiguration.MINI_EXPLOSION_MAXRADIUS - LostCityConfiguration.MINI_EXPLOSION_MINRADIUS), new BlockPos(chunkX * 16 + rand.nextInt(16), LostCityConfiguration.MINI_EXPLOSION_MINHEIGHT + rand.nextInt(LostCityConfiguration.MINI_EXPLOSION_MAXHEIGHT - LostCityConfiguration.MINI_EXPLOSION_MINHEIGHT), chunkZ * 16 + rand.nextInt(16)));
        }
        return null;
    }

    public boolean hasExplosions() {
        return !this.explosions.isEmpty();
    }

    public float getDamageFactor() {
        float damage = 0.0f;
        for (Explosion explosion : this.explosions) {
            double sq = explosion.getCenter().func_177954_c((double)(this.chunkX * 16), (double)explosion.getCenter().func_177956_o(), (double)(this.chunkZ * 16));
            if (!(sq < (double)explosion.getSqradius())) continue;
            double d = Math.sqrt(sq);
            damage = (float)((double)damage + 3.0 * ((double)explosion.getRadius() - d) / (double)explosion.getRadius());
        }
        return damage;
    }

    private float getDamage(int x, int y, int z) {
        float damage = 0.0f;
        for (Explosion explosion : this.explosions) {
            double sq = explosion.getCenter().func_177954_c((double)x, (double)y, (double)z);
            if (!(sq < (double)explosion.getSqradius())) continue;
            double d = Math.sqrt(sq);
            damage = (float)((double)damage + 3.0 * ((double)explosion.getRadius() - d) / (double)explosion.getRadius());
        }
        return damage;
    }
}

