/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.portality.block.module;

import com.buuz135.portality.block.BlockFrame;
import com.buuz135.portality.block.module.IPortalModule;
import com.buuz135.portality.tile.TileController;
import com.buuz135.portality.tile.TileFrame;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockCapabilityModule<T, S extends TileFrame>
extends BlockFrame<S>
implements IPortalModule {
    public static PropertyBool INPUT = PropertyBool.func_177716_a((String)"input");

    public BlockCapabilityModule(String name, Class<S> tileClass) {
        super(name, tileClass);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)INPUT, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    public void work(TileController controller, BlockPos blockPos) {
        if (controller.getLinkData() == null) {
            return;
        }
        TileEntity other = controller.func_145831_w().func_73046_m().func_71218_a(controller.getLinkData().getDimension()).func_175625_s(controller.getLinkData().getPos());
        if (other instanceof TileController && this.isInput(controller.func_145831_w().func_180495_p(blockPos))) {
            TileController otherController = (TileController)other;
            this.internalWork(controller.func_145831_w(), blockPos, other.func_145831_w(), otherController.getModules().stream().filter(pos -> otherController.func_145831_w().func_180495_p(pos).func_177230_c() instanceof BlockCapabilityModule && !((BlockCapabilityModule)otherController.func_145831_w().func_180495_p(pos).func_177230_c()).isInput(otherController.func_145831_w().func_180495_p(pos)) && ((BlockCapabilityModule)otherController.func_145831_w().func_180495_p(pos).func_177230_c()).getCapability().equals(this.getCapability())).collect(Collectors.toList()));
        }
    }

    public abstract Capability<T> getCapability();

    public boolean isInput(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)INPUT);
    }

    abstract void internalWork(World var1, BlockPos var2, World var3, List<BlockPos> var4);

    @Override
    public boolean allowsInterdimensionalTravel() {
        return false;
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return false;
    }

    public IBlockState func_176203_a(int meta) {
        return meta == 0 ? this.func_176223_P().func_177226_a((IProperty)INPUT, (Comparable)Boolean.valueOf(true)) : this.func_176223_P().func_177226_a((IProperty)INPUT, (Comparable)Boolean.valueOf(false));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)INPUT) != false ? 0 : 1;
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        items.add((Object)new ItemStack((Block)this, 1, 0));
        items.add((Object)new ItemStack((Block)this, 1, 1));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{INPUT});
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerRender() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "input=true"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)1, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "input=false"));
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, this.func_176201_c(state));
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        drops.add((Object)new ItemStack((Block)this, 1, this.func_176201_c(state)));
    }
}

