/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import com.mojang.authlib.GameProfile;
import ic2.api.energy.EnergyNet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Chunk3D;
import mekanism.api.Coord4D;
import mekanism.api.IMekWrench;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.Mekanism;
import mekanism.common.MekanismBlocks;
import mekanism.common.MekanismFluids;
import mekanism.common.SideData;
import mekanism.common.Upgrade;
import mekanism.common.base.IActiveState;
import mekanism.common.base.IFactory;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.base.IUpgradeTile;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.block.states.BlockStateTransmitter;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.ic2.IC2Integration;
import mekanism.common.integration.redstoneflux.RFIntegration;
import mekanism.common.integration.tesla.TeslaIntegration;
import mekanism.common.item.ItemBlockGasTank;
import mekanism.common.item.ItemBlockTransmitter;
import mekanism.common.tier.BaseTier;
import mekanism.common.tier.FactoryTier;
import mekanism.common.tier.GasTankTier;
import mekanism.common.tile.TileEntityAdvancedBoundingBlock;
import mekanism.common.tile.TileEntityBoundingBlock;
import mekanism.common.tile.component.SideConfig;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.UnitDisplayUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class MekanismUtils {
    public static final EnumFacing[] SIDE_DIRS = new EnumFacing[]{EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST};
    public static final Map<String, Class<?>> classesFound = new HashMap();
    private static final List<UUID> warnedFails = new ArrayList<UUID>();
    private static final EnumFacing[][] baseOrientations = new EnumFacing[EnumFacing.field_82609_l.length][EnumFacing.field_82609_l.length];

    public static ItemStack getEmptyGasTank(GasTankTier tier) {
        return ((ItemBlockGasTank)new ItemStack(MekanismBlocks.GasTank).func_77973_b()).getEmptyItem(tier);
    }

    public static ItemStack getTransmitter(BlockStateTransmitter.TransmitterType type, BaseTier tier, int amount) {
        ItemStack stack = new ItemStack(MekanismBlocks.Transmitter, amount, type.ordinal());
        ItemBlockTransmitter itemTransmitter = (ItemBlockTransmitter)stack.func_77973_b();
        itemTransmitter.setBaseTier(stack, tier);
        return stack;
    }

    public static ItemStack getFactory(FactoryTier tier, IFactory.RecipeType type) {
        ItemStack itemstack = new ItemStack(MekanismBlocks.MachineBlock, 1, BlockStateMachine.MachineType.BASIC_FACTORY.ordinal() + tier.ordinal());
        ((IFactory)itemstack.func_77973_b()).setRecipeType(type.ordinal(), itemstack);
        return itemstack;
    }

    public static boolean isActive(IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null && tileEntity instanceof IActiveState) {
            return ((IActiveState)tileEntity).getActive();
        }
        return false;
    }

    public static EnumFacing getLeft(EnumFacing orientation) {
        return orientation.func_176746_e();
    }

    public static EnumFacing getRight(EnumFacing orientation) {
        return orientation.func_176735_f();
    }

    public static EnumFacing getBack(EnumFacing orientation) {
        return orientation.func_176734_d();
    }

    public static EnumFacing[] getBaseOrientations(EnumFacing blockFacing) {
        return baseOrientations[blockFacing.ordinal()];
    }

    public static EnumFacing getBaseOrientation(EnumFacing side, EnumFacing blockFacing) {
        if (blockFacing == EnumFacing.DOWN) {
            switch (side) {
                case DOWN: {
                    return EnumFacing.NORTH;
                }
                case UP: {
                    return EnumFacing.SOUTH;
                }
                case NORTH: {
                    return EnumFacing.UP;
                }
                case SOUTH: {
                    return EnumFacing.DOWN;
                }
            }
            return side;
        }
        if (blockFacing == EnumFacing.UP) {
            switch (side) {
                case DOWN: {
                    return EnumFacing.SOUTH;
                }
                case UP: {
                    return EnumFacing.NORTH;
                }
                case NORTH: {
                    return EnumFacing.DOWN;
                }
                case SOUTH: {
                    return EnumFacing.UP;
                }
            }
            return side;
        }
        if (blockFacing == EnumFacing.SOUTH || side.func_176740_k() == EnumFacing.Axis.Y) {
            if (side.func_176740_k() == EnumFacing.Axis.Z) {
                return side.func_176734_d();
            }
            return side;
        }
        if (blockFacing == EnumFacing.NORTH) {
            if (side.func_176740_k() == EnumFacing.Axis.Z) {
                return side;
            }
            return side.func_176734_d();
        }
        if (blockFacing == EnumFacing.WEST) {
            if (side.func_176740_k() == EnumFacing.Axis.Z) {
                return MekanismUtils.getRight(side);
            }
            return MekanismUtils.getLeft(side);
        }
        if (blockFacing == EnumFacing.EAST) {
            if (side.func_176740_k() == EnumFacing.Axis.Z) {
                return MekanismUtils.getLeft(side);
            }
            return MekanismUtils.getRight(side);
        }
        return side;
    }

    public static void incrementOutput(ISideConfiguration config, TransmissionType type, EnumFacing direction) {
        ArrayList<SideData> outputs = config.getConfig().getOutputs(type);
        SideConfig sideConfig = config.getConfig().getConfig(type);
        int max = outputs.size() - 1;
        int current = outputs.indexOf(outputs.get(sideConfig.get(direction)));
        if (current < max) {
            sideConfig.set(direction, (byte)(current + 1));
        } else if (current == max) {
            sideConfig.set(direction, (byte)0);
        }
        assert (config instanceof TileEntity);
        TileEntity tile = (TileEntity)config;
        tile.func_70296_d();
    }

    public static void decrementOutput(ISideConfiguration config, TransmissionType type, EnumFacing direction) {
        ArrayList<SideData> outputs = config.getConfig().getOutputs(type);
        SideConfig sideConfig = config.getConfig().getConfig(type);
        int max = outputs.size() - 1;
        int current = outputs.indexOf(outputs.get(sideConfig.get(direction)));
        if (current > 0) {
            sideConfig.set(direction, (byte)(current - 1));
        } else if (current == 0) {
            sideConfig.set(direction, (byte)max);
        }
        assert (config instanceof TileEntity);
        TileEntity tile = (TileEntity)config;
        tile.func_70296_d();
    }

    public static float fractionUpgrades(IUpgradeTile mgmt, Upgrade type) {
        return (float)mgmt.getComponent().getUpgrades(type) / (float)type.getMax();
    }

    public static int getTicks(IUpgradeTile mgmt, int def) {
        return (int)((double)def * Math.pow(MekanismConfig.current().general.maxUpgradeMultiplier.val(), -MekanismUtils.fractionUpgrades(mgmt, Upgrade.SPEED)));
    }

    public static double getEnergyPerTick(IUpgradeTile mgmt, double def) {
        return def * Math.pow(MekanismConfig.current().general.maxUpgradeMultiplier.val(), 2.0f * MekanismUtils.fractionUpgrades(mgmt, Upgrade.SPEED) - MekanismUtils.fractionUpgrades(mgmt, Upgrade.ENERGY));
    }

    public static double getBaseEnergyPerTick(IUpgradeTile mgmt, double def) {
        return def * Math.pow(MekanismConfig.current().general.maxUpgradeMultiplier.val(), -MekanismUtils.fractionUpgrades(mgmt, Upgrade.ENERGY));
    }

    public static double getSecondaryEnergyPerTickMean(IUpgradeTile mgmt, int def) {
        if (mgmt.getComponent().supports(Upgrade.GAS)) {
            return (double)def * Math.pow(MekanismConfig.current().general.maxUpgradeMultiplier.val(), 2.0f * MekanismUtils.fractionUpgrades(mgmt, Upgrade.SPEED) - MekanismUtils.fractionUpgrades(mgmt, Upgrade.GAS));
        }
        return (double)def * Math.pow(MekanismConfig.current().general.maxUpgradeMultiplier.val(), MekanismUtils.fractionUpgrades(mgmt, Upgrade.SPEED));
    }

    public static double getMaxEnergy(IUpgradeTile mgmt, double def) {
        return def * Math.pow(MekanismConfig.current().general.maxUpgradeMultiplier.val(), MekanismUtils.fractionUpgrades(mgmt, Upgrade.ENERGY));
    }

    public static double getMaxEnergy(ItemStack itemStack, double def) {
        Map<Upgrade, Integer> upgrades = Upgrade.buildMap(ItemDataUtils.getDataMap(itemStack));
        float numUpgrades = upgrades.get((Object)Upgrade.ENERGY) == null ? 0.0f : (float)upgrades.get((Object)Upgrade.ENERGY).intValue();
        return def * Math.pow(MekanismConfig.current().general.maxUpgradeMultiplier.val(), numUpgrades / (float)Upgrade.ENERGY.getMax());
    }

    public static boolean isGettingPowered(World world, Coord4D coord) {
        for (EnumFacing side : EnumFacing.field_82609_l) {
            Coord4D sideCoord = coord.offset(side);
            if (!sideCoord.exists(world) || !sideCoord.offset(side).exists(world)) continue;
            IBlockState blockState = sideCoord.getBlockState((IBlockAccess)world);
            boolean weakPower = blockState.func_177230_c().shouldCheckWeakPower(blockState, (IBlockAccess)world, coord.getPos(), side);
            if (weakPower && MekanismUtils.isDirectlyGettingPowered(world, sideCoord)) {
                return true;
            }
            if (weakPower || blockState.func_185911_a((IBlockAccess)world, sideCoord.getPos(), side) <= 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isDirectlyGettingPowered(World world, Coord4D coord) {
        for (EnumFacing side : EnumFacing.field_82609_l) {
            Coord4D sideCoord = coord.offset(side);
            if (!sideCoord.exists(world) || world.func_175651_c(coord.getPos(), side) <= 0) continue;
            return true;
        }
        return false;
    }

    public static void notifyLoadedNeighborsOfTileChange(World world, Coord4D coord) {
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            Block block1;
            Coord4D offset = coord.offset(dir);
            if (!offset.exists(world)) continue;
            MekanismUtils.notifyNeighborofChange(world, offset, coord.getPos());
            if (!offset.getBlockState((IBlockAccess)world).func_185915_l() || !(offset = offset.offset(dir)).exists(world) || !(block1 = offset.getBlock((IBlockAccess)world)).getWeakChanges((IBlockAccess)world, offset.getPos())) continue;
            block1.onNeighborChange((IBlockAccess)world, offset.getPos(), coord.getPos());
        }
    }

    public static void notifyNeighborofChange(World world, Coord4D coord, BlockPos fromPos) {
        IBlockState state = coord.getBlockState((IBlockAccess)world);
        state.func_177230_c().onNeighborChange((IBlockAccess)world, coord.getPos(), fromPos);
        state.func_189546_a(world, coord.getPos(), world.func_180495_p(fromPos).func_177230_c(), fromPos);
    }

    public static void notifyNeighborOfChange(World world, EnumFacing neighborSide, BlockPos fromPos) {
        BlockPos neighbor = fromPos.func_177972_a(neighborSide);
        IBlockState state = world.func_180495_p(neighbor);
        state.func_177230_c().onNeighborChange((IBlockAccess)world, neighbor, fromPos);
        state.func_189546_a(world, neighbor, world.func_180495_p(fromPos).func_177230_c(), fromPos);
    }

    public static void makeBoundingBlock(World world, BlockPos boundingLocation, Coord4D orig) {
        world.func_175656_a(boundingLocation, MekanismBlocks.BoundingBlock.func_176203_a(0));
        if (!world.field_72995_K) {
            ((TileEntityBoundingBlock)world.func_175625_s(boundingLocation)).setMainLocation(orig.getPos());
        }
    }

    public static void makeAdvancedBoundingBlock(World world, BlockPos boundingLocation, Coord4D orig) {
        world.func_175656_a(boundingLocation, MekanismBlocks.BoundingBlock.func_176203_a(1));
        if (!world.field_72995_K) {
            ((TileEntityAdvancedBoundingBlock)world.func_175625_s(boundingLocation)).setMainLocation(orig.getPos());
        }
    }

    public static void updateBlock(World world, BlockPos pos) {
        if (!world.func_175667_e(pos)) {
            return;
        }
        world.func_175704_b(pos, pos);
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!(tileEntity instanceof IActiveState) || ((IActiveState)tileEntity).lightUpdate() && MekanismConfig.current().client.machineEffects.val()) {
            MekanismUtils.updateAllLightTypes(world, pos);
        }
    }

    public static void updateAllLightTypes(World world, BlockPos pos) {
        world.func_180500_c(EnumSkyBlock.BLOCK, pos);
        world.func_180500_c(EnumSkyBlock.SKY, pos);
    }

    public static boolean isFluid(World world, Coord4D pos) {
        return MekanismUtils.getFluid(world, pos, false) != null;
    }

    public static FluidStack getFluid(World world, Coord4D pos, boolean filter) {
        IBlockState state = pos.getBlockState((IBlockAccess)world);
        Block block = state.func_177230_c();
        if ((block == Blocks.field_150355_j || block == Blocks.field_150358_i) && (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
            if (!filter) {
                return new FluidStack(FluidRegistry.WATER, 1000);
            }
            return new FluidStack(MekanismFluids.HeavyWater, 10);
        }
        if ((block == Blocks.field_150353_l || block == Blocks.field_150356_k) && (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
            return new FluidStack(FluidRegistry.LAVA, 1000);
        }
        if (block instanceof IFluidBlock) {
            IFluidBlock fluid = (IFluidBlock)block;
            if (state.func_177228_b().containsKey((Object)BlockFluidBase.LEVEL) && (Integer)state.func_177229_b((IProperty)BlockFluidBase.LEVEL) == 0) {
                return fluid.drain(world, pos.getPos(), false);
            }
        }
        return null;
    }

    public static boolean isDeadFluid(World world, Coord4D pos) {
        IBlockState state = pos.getBlockState((IBlockAccess)world);
        Block block = state.func_177230_c();
        if (block.func_176201_c(state) == 0) {
            return false;
        }
        return block instanceof BlockLiquid || block instanceof IFluidBlock;
    }

    public static Block getFlowingBlock(Fluid fluid) {
        if (fluid == null) {
            return null;
        }
        if (fluid == FluidRegistry.WATER) {
            return Blocks.field_150358_i;
        }
        if (fluid == FluidRegistry.LAVA) {
            return Blocks.field_150356_k;
        }
        return fluid.getBlock();
    }

    public static void openItemGui(EntityPlayer player, EnumHand hand, int guiID) {
        player.openGui((Object)Mekanism.instance, 0, player.field_70170_p, player.field_71071_by.field_70461_c, hand.ordinal(), guiID);
    }

    public static void openEntityGui(EntityPlayer player, Entity entity, int guiID) {
        player.openGui((Object)Mekanism.instance, 1, player.field_70170_p, entity.func_145782_y(), guiID, 0);
    }

    public static ResourceLocation getResource(ResourceType type, String name) {
        return new ResourceLocation("mekanism", type.getPrefix() + name);
    }

    public static void saveChunk(TileEntity tileEntity) {
        if (tileEntity == null || tileEntity.func_145837_r() || tileEntity.func_145831_w() == null) {
            return;
        }
        tileEntity.func_145831_w().func_175646_b(tileEntity.func_174877_v(), tileEntity);
    }

    public static boolean canFunction(TileEntity tileEntity) {
        if (!(tileEntity instanceof IRedstoneControl)) {
            return true;
        }
        IRedstoneControl control = (IRedstoneControl)tileEntity;
        switch (control.getControlType()) {
            case DISABLED: {
                return true;
            }
            case HIGH: {
                return control.isPowered();
            }
            case LOW: {
                return !control.isPowered();
            }
            case PULSE: {
                return control.isPowered() && !control.wasPowered();
            }
        }
        return false;
    }

    public static RayTraceResult rayTrace(World world, EntityPlayer player) {
        double reach = Mekanism.proxy.getReach(player);
        Vec3d headVec = MekanismUtils.getHeadVec(player);
        Vec3d lookVec = player.func_70676_i(1.0f);
        Vec3d endVec = headVec.func_72441_c(lookVec.field_72450_a * reach, lookVec.field_72448_b * reach, lookVec.field_72449_c * reach);
        return world.func_72901_a(headVec, endVec, true);
    }

    private static Vec3d getHeadVec(EntityPlayer player) {
        double posX = player.field_70165_t;
        double posY = player.field_70163_u;
        double posZ = player.field_70161_v;
        if (!player.field_70170_p.field_72995_K) {
            posY += (double)player.func_70047_e();
            if (player instanceof EntityPlayerMP && player.func_70093_af()) {
                posY -= 0.08;
            }
        }
        return new Vec3d(posX, posY, posZ);
    }

    public static String getEnergyDisplay(double energy) {
        if (energy == Double.MAX_VALUE) {
            return LangUtils.localize("gui.infinite");
        }
        switch (MekanismConfig.current().general.energyUnit.val()) {
            case J: {
                return UnitDisplayUtils.getDisplayShort(energy, UnitDisplayUtils.ElectricUnit.JOULES);
            }
            case RF: {
                return UnitDisplayUtils.getDisplayShort((double)RFIntegration.toRF(energy), UnitDisplayUtils.ElectricUnit.REDSTONE_FLUX);
            }
            case EU: {
                return UnitDisplayUtils.getDisplayShort(IC2Integration.toEU(energy), UnitDisplayUtils.ElectricUnit.ELECTRICAL_UNITS);
            }
            case T: {
                return UnitDisplayUtils.getDisplayShort((double)TeslaIntegration.toTesla(energy), UnitDisplayUtils.ElectricUnit.TESLA);
            }
        }
        return "error";
    }

    public static String getEnergyDisplay(double energy, double max) {
        if (energy == Double.MAX_VALUE) {
            return LangUtils.localize("gui.infinite");
        }
        String energyString = MekanismUtils.getEnergyDisplay(energy);
        String maxString = MekanismUtils.getEnergyDisplay(max);
        return energyString + "/" + maxString;
    }

    public static double convertToJoules(double energy) {
        switch (MekanismConfig.current().general.energyUnit.val()) {
            case RF: {
                return RFIntegration.fromRF(energy);
            }
            case EU: {
                return IC2Integration.fromEU(energy);
            }
            case T: {
                return TeslaIntegration.fromTesla(energy);
            }
        }
        return energy;
    }

    public static double convertToDisplay(double energy) {
        switch (MekanismConfig.current().general.energyUnit.val()) {
            case RF: {
                return RFIntegration.toRFAsDouble(energy);
            }
            case EU: {
                return IC2Integration.toEU(energy);
            }
            case T: {
                return TeslaIntegration.toTesla(energy);
            }
        }
        return energy;
    }

    public static String getTemperatureDisplay(double T, UnitDisplayUtils.TemperatureUnit unit) {
        double TK = unit.convertToK(T, true);
        switch (MekanismConfig.current().general.tempUnit.val()) {
            case K: {
                return UnitDisplayUtils.getDisplayShort(TK, UnitDisplayUtils.TemperatureUnit.KELVIN);
            }
            case C: {
                return UnitDisplayUtils.getDisplayShort(TK, UnitDisplayUtils.TemperatureUnit.CELSIUS);
            }
            case R: {
                return UnitDisplayUtils.getDisplayShort(TK, UnitDisplayUtils.TemperatureUnit.RANKINE);
            }
            case F: {
                return UnitDisplayUtils.getDisplayShort(TK, UnitDisplayUtils.TemperatureUnit.FAHRENHEIT);
            }
            case STP: {
                return UnitDisplayUtils.getDisplayShort(TK, UnitDisplayUtils.TemperatureUnit.AMBIENT);
            }
        }
        return "error";
    }

    public static boolean useIC2() {
        return Mekanism.hooks.IC2Loaded && EnergyNet.instance != null && !MekanismConfig.current().general.blacklistIC2.val();
    }

    public static boolean useRF() {
        return Mekanism.hooks.RFLoaded && !MekanismConfig.current().general.blacklistRF.val();
    }

    public static boolean useTesla() {
        return Mekanism.hooks.TeslaLoaded && !MekanismConfig.current().general.blacklistTesla.val();
    }

    public static boolean useForge() {
        return !MekanismConfig.current().general.blacklistForge.val();
    }

    public static String getCoordDisplay(Coord4D obj) {
        return "[" + obj.x + ", " + obj.y + ", " + obj.z + "]";
    }

    @SideOnly(value=Side.CLIENT)
    public static List<String> splitTooltip(String s, ItemStack stack) {
        s = s.trim();
        FontRenderer renderer = (FontRenderer)Mekanism.proxy.getFontRenderer();
        if (!stack.func_190926_b() && stack.func_77973_b().getFontRenderer(stack) != null) {
            renderer = stack.func_77973_b().getFontRenderer(stack);
        }
        if (renderer != null) {
            return renderer.func_78271_c(s, 200);
        }
        return Collections.emptyList();
    }

    public static ItemStack getFullGasTank(GasTankTier tier, Gas gas) {
        ItemStack tank = MekanismUtils.getEmptyGasTank(tier);
        ItemBlockGasTank item = (ItemBlockGasTank)tank.func_77973_b();
        item.setGas(tank, new GasStack(gas, item.MAX_GAS));
        return tank;
    }

    public static InventoryCrafting getDummyCraftingInv() {
        Container tempContainer = new Container(){

            public boolean func_75145_c(@Nonnull EntityPlayer player) {
                return false;
            }
        };
        return new InventoryCrafting(tempContainer, 3, 3);
    }

    public static ItemStack findRepairRecipe(InventoryCrafting inv, World world) {
        NonNullList dmgItems = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i).func_190926_b()) continue;
            if (((ItemStack)dmgItems.get(0)).func_190926_b()) {
                dmgItems.set(0, (Object)inv.func_70301_a(i));
                continue;
            }
            dmgItems.set(1, (Object)inv.func_70301_a(i));
            break;
        }
        if (((ItemStack)dmgItems.get(0)).func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (!((ItemStack)dmgItems.get(1)).func_190926_b() && ((ItemStack)dmgItems.get(0)).func_77973_b() == ((ItemStack)dmgItems.get(1)).func_77973_b() && ((ItemStack)dmgItems.get(0)).func_190916_E() == 1 && ((ItemStack)dmgItems.get(1)).func_190916_E() == 1 && ((ItemStack)dmgItems.get(0)).func_77973_b().isRepairable()) {
            Item theItem = ((ItemStack)dmgItems.get(0)).func_77973_b();
            int dmgDiff0 = theItem.func_77612_l() - ((ItemStack)dmgItems.get(0)).func_77952_i();
            int dmgDiff1 = theItem.func_77612_l() - ((ItemStack)dmgItems.get(1)).func_77952_i();
            int value = dmgDiff0 + dmgDiff1 + theItem.func_77612_l() * 5 / 100;
            int solve = Math.max(0, theItem.func_77612_l() - value);
            return new ItemStack(((ItemStack)dmgItems.get(0)).func_77973_b(), 1, solve);
        }
        return ItemStack.field_190927_a;
    }

    public static boolean isChunkVibrated(Chunk3D chunk) {
        for (Coord4D coord : Mekanism.activeVibrators) {
            if (!coord.getChunk3D().equals(chunk)) continue;
            return true;
        }
        return false;
    }

    public static boolean isOp(EntityPlayer p) {
        if (!(p instanceof EntityPlayerMP)) {
            return false;
        }
        EntityPlayerMP player = (EntityPlayerMP)p;
        return MekanismConfig.current().general.opsBypassRestrictions.val() && player.field_71133_b.func_184103_al().func_152596_g(player.func_146103_bH());
    }

    public static int getID(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return -1;
        }
        return Item.func_150891_b((Item)itemStack.func_77973_b());
    }

    @Deprecated
    public static boolean classExists(String className) {
        Class<?> found;
        if (classesFound.containsKey(className)) {
            return classesFound.get(className) != null;
        }
        try {
            found = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            found = null;
        }
        classesFound.put(className, found);
        return found != null;
    }

    @Deprecated
    public static boolean existsAndInstance(Object obj, String className) {
        Class<?> theClass;
        if (classesFound.containsKey(className)) {
            theClass = classesFound.get(className);
        } else {
            try {
                theClass = Class.forName(className);
                classesFound.put(className, theClass);
            }
            catch (ClassNotFoundException e) {
                classesFound.put(className, null);
                return false;
            }
        }
        return theClass != null && theClass.isInstance(obj);
    }

    public static boolean isBCWrench(Item tool) {
        return MekanismUtils.existsAndInstance(tool, "buildcraft.api.tools.IToolWrench");
    }

    public static boolean isCoFHHammer(Item tool) {
        return MekanismUtils.existsAndInstance(tool, "cofh.api.item.IToolHammer");
    }

    @Deprecated
    public static boolean hasUsableWrench(EntityPlayer player, BlockPos pos) {
        ItemStack tool = player.field_71071_by.func_70448_g();
        if (tool.func_190926_b()) {
            return false;
        }
        if (tool.func_77973_b() instanceof IMekWrench && ((IMekWrench)tool.func_77973_b()).canUseWrench(tool, player, pos)) {
            return true;
        }
        try {
            if (MekanismUtils.isBCWrench(tool.func_77973_b())) {
                return true;
            }
            if (MekanismUtils.isCoFHHammer(tool.func_77973_b())) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    @Nonnull
    public static String getLastKnownUsername(UUID uuid) {
        GameProfile gp;
        String ret = UsernameCache.getLastKnownUsername((UUID)uuid);
        if (ret == null && !warnedFails.contains(uuid) && FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER && (gp = FMLCommonHandler.instance().getMinecraftServerInstance().func_152358_ax().func_152652_a(uuid)) != null) {
            ret = gp.getName();
        }
        if (ret == null && !warnedFails.contains(uuid)) {
            Mekanism.logger.warn("Failed to retrieve username for UUID {}, you might want to add it to the JSON cache", (Object)uuid);
            warnedFails.add(uuid);
        }
        return ret != null ? ret : "<???>";
    }

    public static TileEntity getTileEntitySafe(IBlockAccess worldIn, BlockPos pos) {
        return worldIn instanceof ChunkCache ? ((ChunkCache)worldIn).func_190300_a(pos, Chunk.EnumCreateEntityType.CHECK) : worldIn.func_175625_s(pos);
    }

    @Nullable
    public static TileEntity getTileEntity(World world, BlockPos pos) {
        if (world != null && world.func_175667_e(pos)) {
            return world.func_175625_s(pos);
        }
        return null;
    }

    public static void dismantleBlock(Block block, IBlockState state, World world, BlockPos pos) {
        block.func_176226_b(world, pos, state, 0);
        world.func_175698_g(pos);
    }

    public static int redstoneLevelFromContents(double amount, double capacity) {
        double fractionFull = capacity == 0.0 ? 0.0 : amount / capacity;
        return MathHelper.func_76141_d((float)((float)(fractionFull * 14.0))) + (fractionFull > 0.0 ? 1 : 0);
    }

    public static int clampToInt(double d) {
        if (d < 2.147483647E9) {
            return (int)d;
        }
        return Integer.MAX_VALUE;
    }

    static {
        for (int blockFacing = 0; blockFacing < EnumFacing.field_82609_l.length; ++blockFacing) {
            for (int side = 0; side < EnumFacing.field_82609_l.length; ++side) {
                MekanismUtils.baseOrientations[blockFacing][side] = MekanismUtils.getBaseOrientation(EnumFacing.field_82609_l[side], EnumFacing.field_82609_l[blockFacing]);
            }
        }
    }

    public static enum ResourceType {
        GUI("gui"),
        GUI_ELEMENT("gui/elements"),
        SOUND("sound"),
        RENDER("render"),
        TEXTURE_BLOCKS("textures/blocks"),
        TEXTURE_ITEMS("textures/items"),
        MODEL("models"),
        INFUSE("infuse");

        private String prefix;

        private ResourceType(String s) {
            this.prefix = s;
        }

        public String getPrefix() {
            return this.prefix + "/";
        }
    }
}

