/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.utility;

import java.awt.Color;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class BoundingBox
implements Iterable<BlockPos> {
    private int minX;
    private int minY;
    private int minZ;
    private int maxX;
    private int maxY;
    private int maxZ;

    public BoundingBox(BoundingBox box) {
        this(box.minX(), box.minY(), box.minZ(), box.maxX(), box.maxY(), box.maxZ());
    }

    public BoundingBox(BlockPos min, BlockPos max) {
        this(min.func_177958_n(), min.func_177956_o(), min.func_177952_p(), max.func_177958_n(), max.func_177956_o(), max.func_177952_p());
    }

    public BoundingBox(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.minX = Math.min(minX, maxX);
        this.minY = Math.min(minY, maxY);
        this.minZ = Math.min(minZ, maxZ);
        this.maxX = Math.max(minX, maxX);
        this.maxY = Math.max(minY, maxY);
        this.maxZ = Math.max(minZ, maxZ);
    }

    public BlockPos getMinimumPosition() {
        return new BlockPos(this.minX, this.minY, this.minZ);
    }

    public BlockPos getMaximumPosition() {
        return new BlockPos(this.maxX, this.maxY, this.maxZ);
    }

    public int minX() {
        return this.minX;
    }

    public int minY() {
        return this.minY;
    }

    public int minZ() {
        return this.minZ;
    }

    public int maxX() {
        return this.maxX;
    }

    public int maxY() {
        return this.maxY;
    }

    public int maxZ() {
        return this.maxZ;
    }

    public int xSize() {
        return this.maxX - this.minX + 1;
    }

    public int ySize() {
        return this.maxY - this.minY + 1;
    }

    public int zSize() {
        return this.maxZ - this.minZ + 1;
    }

    public double calculateDistanceToCenterSquared(double x, double y, double z) {
        double xC = (double)(this.maxX() + this.minX()) / 2.0;
        double yC = (double)(this.maxY() + this.minY()) / 2.0;
        double zC = (double)(this.maxZ() + this.minZ()) / 2.0;
        return (x - xC) * (x - xC) + (y - yC) * (y - yC) + (z - zC) * (z - zC);
    }

    public BoundingBox copy() {
        return new BoundingBox(this);
    }

    public BoundingBox expand(int amount) {
        this.minX -= amount;
        this.minY -= amount;
        this.minZ -= amount;
        this.maxX += amount;
        this.maxY += amount;
        this.maxZ += amount;
        return this;
    }

    public BoundingBox expandToFit(BoundingBox inner) {
        this.minX = this.minX < inner.minX() ? this.minX : inner.minX();
        this.minY = this.minY < inner.minY() ? this.minY : inner.minY();
        this.minZ = this.minZ < inner.minZ() ? this.minZ : inner.minZ();
        this.maxX = this.maxX > inner.maxX() ? this.maxX : inner.maxX();
        this.maxY = this.maxY > inner.maxY() ? this.maxY : inner.maxY();
        this.maxZ = this.maxZ > inner.maxZ() ? this.maxZ : inner.maxZ();
        return this;
    }

    public BoundingBox expandToFit(BlockPos pos) {
        return this.expandToFit(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public BoundingBox expandToFit(int x, int y, int z) {
        if (x >= this.maxX) {
            this.maxX = x;
        } else if (x < this.minX) {
            this.minX = x;
        }
        if (y >= this.maxY) {
            this.maxY = y;
        } else if (y < this.minY) {
            this.minY = y;
        }
        if (z >= this.maxZ) {
            this.maxZ = z;
        } else if (z < this.minZ) {
            this.minZ = z;
        }
        return this;
    }

    public BoundingBox offset(int x, int y, int z) {
        this.minX += x;
        this.minY += y;
        this.minZ += z;
        this.maxX += x;
        this.maxY += y;
        this.maxZ += z;
        return this;
    }

    public BoundingBox offset(BlockPos offset) {
        return this.offset(offset.func_177958_n(), offset.func_177956_o(), offset.func_177952_p());
    }

    public BoundingBox rotate(int amount) {
        int newX;
        if ((amount %= 4) == 0) {
            return this;
        }
        int oldX = this.minX;
        int oldY = this.minY;
        int oldZ = this.minZ;
        this.offset(-oldX, -oldY, -oldZ);
        int n = amount == 1 ? -this.maxZ : (newX = amount == 2 ? -this.maxX : this.maxZ);
        int newZ = amount == 1 ? this.maxX : (amount == 2 ? -this.maxZ : -this.maxX);
        this.minX = Math.min(0, newX);
        this.minZ = Math.min(0, newZ);
        this.maxX = Math.max(0, newX);
        this.maxZ = Math.max(0, newZ);
        return this.offset(oldX, oldY, oldZ);
    }

    public boolean isWithinBounds(BlockPos pos) {
        return this.isWithinBounds(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public boolean isWithinBounds(double x, double y, double z) {
        return x >= (double)this.minX && x <= (double)this.maxX && y >= (double)this.minY && y <= (double)this.maxY && z >= (double)this.minZ && z <= (double)this.maxZ;
    }

    public boolean intersects(BoundingBox other) {
        return other.maxX() + 1 > this.minX() && other.maxY() + 1 > this.minY() && other.maxZ() + 1 > this.minZ() && this.maxX() + 1 > other.minX() && this.maxY() + 1 > other.minY() && this.maxZ() + 1 > other.minZ();
    }

    public AxisAlignedBB toAxisAlignedBB() {
        return new AxisAlignedBB((double)this.minX, (double)this.minY, (double)this.minZ, (double)(this.maxX + 1), (double)(this.maxY + 1), (double)(this.maxZ + 1));
    }

    public boolean areAllChunksLoaded(World world) {
        int chunkMinX = this.minX >> 4;
        int chunkMinZ = this.minZ >> 4;
        int chunkMaxX = this.maxX >> 4;
        int chunkMaxZ = this.maxZ >> 4;
        for (int x = chunkMinX; x <= chunkMaxX; ++x) {
            for (int z = chunkMinZ; z <= chunkMaxZ; ++z) {
                if (world.func_72964_e(x, z).func_177410_o()) continue;
                return false;
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderWireFrame(Tessellator tessellator, Color color) {
        int i;
        BufferBuilder buffer = tessellator.func_178180_c();
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GL11.glTranslatef((float)this.minX(), (float)this.minY(), (float)this.minZ());
        int x = this.xSize();
        int y = this.ySize();
        int z = this.zSize();
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        int alpha = color.getAlpha();
        buffer.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        for (i = 0; i <= x; ++i) {
            buffer.func_181662_b((double)i, (double)0.001f, (double)0.001f).func_181669_b(red, green, blue, alpha).func_181675_d();
        }
        tessellator.func_78381_a();
        buffer.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        for (i = 0; i <= x; ++i) {
            buffer.func_181662_b((double)i, (double)((float)y - 0.001f), (double)0.001f).func_181669_b(red, green, blue, alpha).func_181675_d();
        }
        tessellator.func_78381_a();
        buffer.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        for (i = 0; i <= x; ++i) {
            buffer.func_181662_b((double)i, (double)((float)y - 0.001f), (double)((float)z - 0.001f)).func_181669_b(red, green, blue, alpha).func_181675_d();
        }
        tessellator.func_78381_a();
        buffer.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        for (i = 0; i <= x; ++i) {
            buffer.func_181662_b((double)i, (double)0.001f, (double)((float)z - 0.001f)).func_181669_b(red, green, blue, alpha).func_181675_d();
        }
        tessellator.func_78381_a();
        buffer.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        for (i = 0; i <= y; ++i) {
            buffer.func_181662_b((double)0.001f, (double)i, (double)0.001f).func_181669_b(red, green, blue, alpha).func_181675_d();
        }
        tessellator.func_78381_a();
        buffer.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        for (i = 0; i <= y; ++i) {
            buffer.func_181662_b((double)((float)x - 0.001f), (double)i, (double)0.001f).func_181669_b(red, green, blue, alpha).func_181675_d();
        }
        tessellator.func_78381_a();
        buffer.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        for (i = 0; i <= y; ++i) {
            buffer.func_181662_b((double)((float)x - 0.001f), (double)i, (double)((float)z - 0.001f)).func_181669_b(red, green, blue, alpha).func_181675_d();
        }
        tessellator.func_78381_a();
        buffer.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        for (i = 0; i <= y; ++i) {
            buffer.func_181662_b((double)0.001f, (double)i, (double)((float)z - 0.001f)).func_181669_b(red, green, blue, alpha).func_181675_d();
        }
        tessellator.func_78381_a();
        buffer.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        for (i = 0; i <= z; ++i) {
            buffer.func_181662_b((double)0.001f, (double)0.001f, (double)i).func_181669_b(red, green, blue, alpha).func_181675_d();
        }
        tessellator.func_78381_a();
        buffer.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        for (i = 0; i <= z; ++i) {
            buffer.func_181662_b((double)((float)x - 0.001f), (double)0.001f, (double)i).func_181669_b(red, green, blue, alpha).func_181675_d();
        }
        tessellator.func_78381_a();
        buffer.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        for (i = 0; i <= z; ++i) {
            buffer.func_181662_b((double)((float)x - 0.001f), (double)((float)y - 0.001f), (double)i).func_181669_b(red, green, blue, alpha).func_181675_d();
        }
        tessellator.func_78381_a();
        buffer.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        for (i = 0; i <= z; ++i) {
            buffer.func_181662_b((double)0.001f, (double)((float)y - 0.001f), (double)i).func_181669_b(red, green, blue, alpha).func_181675_d();
        }
        tessellator.func_78381_a();
        GL11.glTranslatef((float)(-this.minX()), (float)(-this.minY()), (float)(-this.minZ()));
        GlStateManager.func_179145_e();
        GlStateManager.func_179098_w();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof BoundingBox) {
            BoundingBox other = (BoundingBox)obj;
            return this.minX() == other.minX() && this.minY() == other.minY() && this.minZ() == other.minZ() && this.maxX() == other.maxX() && this.maxY() == other.maxY() && this.maxZ() == other.maxZ();
        }
        return false;
    }

    public BoundingBoxIterator iterator() {
        return new BoundingBoxIterator(this);
    }

    private static class BoundingBoxIterator
    implements Iterator<BlockPos> {
        private final BlockPos offset;
        private final int X;
        private final int Y;
        private final int limit;
        private int index;

        private BoundingBoxIterator(BoundingBox box) {
            this.offset = new BlockPos(box.minX(), box.minY(), box.minZ());
            this.X = box.xSize();
            this.Y = box.ySize();
            this.limit = box.xSize() * box.ySize() * box.zSize();
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.limit;
        }

        @Override
        public BlockPos next() {
            if (this.index >= this.limit) {
                throw new NoSuchElementException();
            }
            int x = this.index % this.X;
            int z = this.index / (this.X * this.Y);
            int y = (this.index - this.X * this.Y * z) / this.X;
            ++this.index;
            return x == 0 && y == 0 && z == 0 ? new BlockPos((Vec3i)this.offset) : this.offset.func_177982_a(x, y, z);
        }
    }
}

