/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.render.item;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.infinityraider.infinitylib.render.item.BakedInfItemModel;
import com.infinityraider.infinitylib.render.tessellation.TessellatorBakedQuad;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

@SideOnly(value=Side.CLIENT)
public class BakedInfItemSubModel
implements IBakedModel {
    @Nonnull
    private final BakedInfItemModel parent;
    @Nonnull
    private final ImmutableList<BakedQuad>[] faceQuads;
    @Nonnull
    private final ItemStack stack;
    @Nullable
    private final World world;
    @Nullable
    private final EntityLivingBase entity;

    public BakedInfItemSubModel(@Nonnull BakedInfItemModel parent, @Nonnull ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
        this.parent = (BakedInfItemModel)Preconditions.checkNotNull((Object)parent);
        this.stack = (ItemStack)Preconditions.checkNotNull((Object)stack);
        this.world = world;
        this.entity = entity;
        this.faceQuads = new ImmutableList[7];
    }

    public ImmutableList<BakedQuad> getQuads(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        int index = side == null ? 6 : side.ordinal();
        ImmutableList<BakedQuad> quads = this.faceQuads[index];
        if (quads == null) {
            TessellatorBakedQuad tessellator = TessellatorBakedQuad.getInstance();
            tessellator.setCurrentFace(side);
            tessellator.setTextureFunction(this.parent.textureFunction);
            tessellator.startDrawingQuads(this.parent.format);
            this.parent.renderer.renderItem(tessellator, this.world, this.stack, this.entity);
            quads = tessellator.getQuads();
            tessellator.draw();
            this.faceQuads[index] = quads;
        }
        return quads;
    }

    public boolean func_177555_b() {
        return this.parent.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.parent.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.parent.func_188618_c();
    }

    public TextureAtlasSprite func_177554_e() {
        return this.parent.func_177554_e();
    }

    public ItemCameraTransforms func_177552_f() {
        return this.parent.func_177552_f();
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    @Nonnull
    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType transform) {
        return Pair.of((Object)this, this.parent.transformer.apply(transform));
    }
}

