/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import org.cyclops.cyclopscore.capability.fluid.FluidHandlerItemCapacityConfig;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerItemCapacity;

public final class FluidHelpers {
    public static int getAmount(@Nullable FluidStack fluidStack) {
        return fluidStack != null ? fluidStack.amount : 0;
    }

    public static FluidStack copy(@Nullable FluidStack fluidStack) {
        if (fluidStack == null) {
            return null;
        }
        return fluidStack.copy();
    }

    public static boolean canCompletelyFill(IFluidHandler source, IFluidHandler destination) {
        FluidStack drained = source.drain(Integer.MAX_VALUE, false);
        return drained != null && destination.fill(drained, false) == drained.amount;
    }

    public static FluidStack getFluid(@Nullable IFluidHandler fluidHandler) {
        return fluidHandler != null ? fluidHandler.drain(Integer.MAX_VALUE, false) : null;
    }

    public static boolean hasFluid(@Nullable IFluidHandler fluidHandler) {
        return FluidHelpers.getFluid(fluidHandler) != null;
    }

    public static int getCapacity(@Nullable IFluidHandler fluidHandler) {
        IFluidTankProperties[] iFluidTankPropertiesArray;
        int n;
        int n2;
        if (fluidHandler != null && (n2 = 0) < (n = (iFluidTankPropertiesArray = fluidHandler.getTankProperties()).length)) {
            IFluidTankProperties properties = iFluidTankPropertiesArray[n2];
            return properties.getCapacity();
        }
        return 0;
    }

    @Nullable
    public static IFluidHandlerItemCapacity getFluidHandlerItemCapacity(ItemStack itemStack) {
        return itemStack.hasCapability(FluidHandlerItemCapacityConfig.CAPABILITY, null) ? (IFluidHandlerItemCapacity)itemStack.getCapability(FluidHandlerItemCapacityConfig.CAPABILITY, null) : null;
    }
}

