/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.util;

import java.util.Random;
import net.minecraft.item.ItemStack;

public class OreDrop {
    public ItemStack drop;
    public Integer baseChance;
    public Integer minQuantity;
    public int maxQuantity;

    public OreDrop(ItemStack drop, int maxQuantity) {
        this.drop = drop;
        this.minQuantity = drop.func_190916_E();
        if (this.minQuantity == 0) {
            this.minQuantity = 1;
        }
        this.baseChance = 100;
        this.maxQuantity = maxQuantity;
    }

    public OreDrop(ItemStack drop, double baseChance, int maxQuantity) {
        this.drop = drop;
        this.minQuantity = drop.func_190916_E();
        if (this.minQuantity == 0) {
            this.minQuantity = 1;
        }
        this.baseChance = (int)(baseChance * 100.0);
        this.maxQuantity = maxQuantity;
    }

    public ItemStack getDrops(int fortuneLevel, Random random) {
        int count = this.baseChance == 100 ? this.calculateFortuneMulti(fortuneLevel, random) : (this.calculateFortuneSingle(fortuneLevel, random) ? this.calculateBaseQuantity(random) : 0);
        return new ItemStack(this.drop.func_77973_b(), count, this.drop.func_77952_i());
    }

    private int calculateFortuneMulti(int fortune, Random random) {
        int chanceOfEachBonus = 100 / (fortune + 2);
        int roll = random.nextInt(100);
        if (roll < chanceOfEachBonus * fortune) {
            return this.calculateBaseQuantity(random) * (roll / chanceOfEachBonus + 2);
        }
        return this.calculateBaseQuantity(random);
    }

    private boolean calculateFortuneSingle(int fortune, Random random) {
        double total = this.baseChance + fortune * this.baseChance / 2;
        int roll = random.nextInt(100);
        return (double)roll <= total;
    }

    private int calculateBaseQuantity(Random random) {
        return this.minQuantity + random.nextInt(this.maxQuantity - this.minQuantity + 1);
    }
}

