/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.network.packet;

import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import reborncore.RebornCore;
import reborncore.common.network.ExtendedPacketBuffer;
import reborncore.common.network.INetworkPacket;
import reborncore.common.tile.FluidConfiguration;
import reborncore.common.tile.RebornMachineTile;

public class PacketFluidConfigSync
implements INetworkPacket<PacketFluidConfigSync> {
    BlockPos pos;
    FluidConfiguration fluidConfiguration;

    public PacketFluidConfigSync(BlockPos pos, FluidConfiguration fluidConfiguration) {
        this.pos = pos;
        this.fluidConfiguration = fluidConfiguration;
    }

    public PacketFluidConfigSync() {
    }

    @Override
    public void writeData(ExtendedPacketBuffer buffer) throws IOException {
        buffer.func_179255_a(this.pos);
        buffer.func_150786_a(this.fluidConfiguration.serializeNBT());
    }

    @Override
    public void readData(ExtendedPacketBuffer buffer) throws IOException {
        this.pos = buffer.func_179259_c();
        this.fluidConfiguration = new FluidConfiguration(buffer.func_150793_b());
    }

    @Override
    public void processData(PacketFluidConfigSync message, MessageContext context) {
        if (!RebornCore.proxy.getClientWorld().func_175668_a(this.pos, false)) {
            return;
        }
        RebornMachineTile machineBase = (RebornMachineTile)RebornCore.proxy.getClientWorld().func_175625_s(this.pos);
        if (machineBase == null || machineBase.fluidConfiguration == null || this.fluidConfiguration == null) {
            RebornCore.logHelper.error("Failed to sync fluid config data to " + this.pos);
        }
        Minecraft.func_71410_x().func_152344_a(() -> {
            this.fluidConfiguration.getAllSides().forEach(fluidConfig -> machineBase.fluidConfiguration.updateFluidConfig((FluidConfiguration.FluidConfig)fluidConfig));
            machineBase.fluidConfiguration.setInput(this.fluidConfiguration.autoInput());
            machineBase.fluidConfiguration.setOutput(this.fluidConfiguration.autoOutput());
        });
    }
}

