/*
 * Decompiled with CFR 0.152.
 */
package com.nospace.birdsfoods.items;

import com.nospace.birdsfoods.config.BirdConfig;
import com.nospace.birdsfoods.effects.BirdPotion;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BirdFood
extends ItemFood {
    private boolean isQuality;
    private boolean isDangerous;
    private boolean isTaako;
    private boolean isPalliative;
    private boolean isRaw;
    private boolean isDagwood;
    private PotionEffect potionId;
    private float potionEffectProbability;
    private float poisoncheck;

    public BirdFood(int amount, float saturation, boolean isWolfFood, String itemname) {
        super(amount, saturation, isWolfFood);
        BirdFood.setItemName((Item)this, itemname);
        this.func_77637_a(CreativeTabs.field_78039_h);
    }

    public BirdFood isDangerous() {
        this.isDangerous = true;
        return this;
    }

    public BirdFood isQuality() {
        this.isQuality = true;
        return this;
    }

    public BirdFood isTaako() {
        this.isTaako = true;
        return this;
    }

    public BirdFood isPalliative() {
        this.isPalliative = true;
        return this;
    }

    public BirdFood isRaw() {
        this.isRaw = true;
        return this;
    }

    public BirdFood isDagwood() {
        this.isDagwood = true;
        return this;
    }

    public boolean func_77636_d(ItemStack stack) {
        return this.isTaako;
    }

    protected void func_77849_c(ItemStack stack, World worldIn, EntityPlayer player) {
        if (!worldIn.field_72995_K && this.isDangerous && BirdConfig.DangerousEffects) {
            this.poisoncheck = worldIn.field_73012_v.nextFloat();
            if (this.poisoncheck < 0.01f) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76433_i, 0, 10));
            }
            if (this.poisoncheck < 0.05f) {
                player.func_70690_d(new PotionEffect(MobEffects.field_82731_v, 400, 1));
            }
            if (this.poisoncheck < 0.1f) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 400, 1));
            }
            if (this.poisoncheck < 0.25f && BirdConfig.NauseaEffects) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 400, 1));
            }
            if (this.poisoncheck > 0.8f) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 2400, 0));
            }
        }
        if (!worldIn.field_72995_K && this.potionId != null && worldIn.field_73012_v.nextFloat() < this.potionEffectProbability) {
            player.func_70690_d(new PotionEffect(this.potionId));
        }
        if (!worldIn.field_72995_K && this.isQuality && BirdConfig.QualityEffects) {
            player.func_70690_d(new PotionEffect(MobEffects.field_180152_w, 2400, 0));
        }
        if (!worldIn.field_72995_K && this.isDagwood && BirdConfig.SuperFoodEffects) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76432_h, 60, 10));
            player.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 200, 2));
            player.func_70690_d(new PotionEffect(MobEffects.field_180152_w, 2400, 1));
        }
        if (!worldIn.field_72995_K && this.isDagwood && !BirdConfig.SuperFoodEffects && BirdConfig.QualityEffects) {
            player.func_70690_d(new PotionEffect(MobEffects.field_180152_w, 2400, 0));
        }
        if (!worldIn.field_72995_K && this.isPalliative && BirdConfig.Palliatives && BirdConfig.PalliativeTweak) {
            player.func_184589_d(MobEffects.field_76440_q);
            player.func_184589_d(MobEffects.field_76436_u);
            player.func_184589_d(MobEffects.field_76431_k);
            player.func_184589_d(MobEffects.field_82731_v);
            player.func_184589_d(MobEffects.field_76421_d);
            player.func_184589_d(MobEffects.field_76419_f);
            player.func_184589_d(MobEffects.field_76437_t);
            player.func_184589_d(MobEffects.field_76433_i);
            player.func_184589_d(MobEffects.field_76438_s);
        }
        if (!worldIn.field_72995_K && this.isPalliative && BirdConfig.Palliatives && !BirdConfig.PalliativeTweak) {
            player.func_70674_bp();
        }
        if (!worldIn.field_72995_K && this.isTaako && BirdConfig.SuperFoodEffects) {
            player.func_70690_d(new PotionEffect(MobEffects.field_180152_w, 3600, 4));
            player.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 3600, 1));
            player.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 1200, 2));
            player.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 200, 1));
            player.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 200, 1));
        }
        if (!worldIn.field_72995_K && this.isTaako && !BirdConfig.SuperFoodEffects && BirdConfig.QualityEffects) {
            player.func_70690_d(new PotionEffect(MobEffects.field_180152_w, 2400, 0));
        }
        if (!worldIn.field_72995_K && player.func_71024_bL().func_75116_a() == 20 && (float)this.func_150905_g(stack) * (this.func_150906_h(stack) * 2.0f) + (float)this.func_150905_g(stack) >= 20.0f && BirdConfig.WellFed) {
            player.func_70690_d(new PotionEffect((Potion)BirdPotion.fullness, 1200, 9));
        }
    }

    public ItemFood func_185070_a(PotionEffect effect, float probability) {
        this.potionId = effect;
        this.potionEffectProbability = probability;
        return this;
    }

    public static void setItemName(Item item, String itemName) {
        item.setRegistryName("birdsfoods", itemName);
        item.func_77655_b(item.getRegistryName().toString());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (this.isDangerous && BirdConfig.DangerousEffects) {
            tooltip.add(TextFormatting.RED + "Caution: May cause serious illness or death");
            tooltip.add("...but bravery can make you strong, right?");
        }
        if (this.isRaw) {
            tooltip.add("Might make you sick");
        }
        if (this.isTaako && BirdConfig.SuperFoodEffects) {
            tooltip.add(TextFormatting.GOLD + "A legendary food for legendary buffs");
        }
        if (this.isQuality && BirdConfig.QualityEffects) {
            tooltip.add("Grants a temporary health boost");
        }
        if (this.isPalliative && BirdConfig.Palliatives && BirdConfig.PalliativeTweak) {
            tooltip.add("Removes negative potion effects");
            tooltip.add("(Vanilla effects only)");
        }
        if (this.isPalliative && BirdConfig.Palliatives && !BirdConfig.PalliativeTweak) {
            tooltip.add("Removes all potion effects");
        }
        if (this.isDagwood && BirdConfig.SuperFoodEffects) {
            tooltip.add("Grants near-invulnerability for a short time");
        }
        if (this.isDagwood && !BirdConfig.SuperFoodEffects && BirdConfig.QualityEffects) {
            tooltip.add("Grants a temporary health boost");
        }
        if (this.isTaako && !BirdConfig.SuperFoodEffects && BirdConfig.QualityEffects) {
            tooltip.add("Grants a temporary health boost");
        }
    }
}

