/*
 * Decompiled with CFR 0.152.
 */
package com.nospace.birdsfoods.items;

import com.nospace.birdsfoods.config.BirdConfig;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BirdDrink
extends ItemFood {
    private boolean isAlcoholic;
    private boolean isPalliative;
    private boolean isScumble;
    private boolean isCider;
    private boolean isWine;
    private boolean isBeer;
    private boolean isLiquor;
    private boolean isVodka;
    private boolean isPoitin;
    private boolean isTequila;
    private boolean isRum;
    private boolean isUmeshu;
    private float poisoncheck;
    private PotionEffect potionId;
    private float potionEffectProbability;
    private float blindness;
    private float slowness;
    private float nausea;
    private float health;

    public BirdDrink(int amount, float saturation, boolean isWolfFood, String itemname) {
        super(amount, saturation, isWolfFood);
        BirdDrink.setItemName((Item)this, itemname);
        this.func_77637_a(CreativeTabs.field_78039_h);
    }

    public BirdDrink isAlcoholic(float blindness, float slowness, float nausea) {
        this.isAlcoholic = true;
        this.blindness = blindness;
        this.slowness = slowness;
        this.nausea = nausea;
        return this;
    }

    public BirdDrink isPalliative() {
        this.isPalliative = true;
        return this;
    }

    public BirdDrink isScumble() {
        this.isScumble = true;
        return this;
    }

    public BirdDrink isCider() {
        this.isCider = true;
        return this;
    }

    public BirdDrink isWine() {
        this.isWine = true;
        return this;
    }

    public BirdDrink isBeer() {
        this.isBeer = true;
        return this;
    }

    public BirdDrink isLiquor() {
        this.isLiquor = true;
        return this;
    }

    public BirdDrink isVodka() {
        this.isVodka = true;
        return this;
    }

    public BirdDrink isPoitin() {
        this.isPoitin = true;
        return this;
    }

    public BirdDrink isTequila() {
        this.isTequila = true;
        return this;
    }

    public BirdDrink isRum() {
        this.isRum = true;
        return this;
    }

    public BirdDrink isUmeshu() {
        this.isUmeshu = true;
        return this;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.DRINK;
    }

    public boolean func_77636_d(ItemStack stack) {
        return this.isAlcoholic;
    }

    protected void func_77849_c(ItemStack stack, World worldIn, EntityPlayer player) {
        if (!worldIn.field_72995_K && this.isAlcoholic && BirdConfig.AlcoholEffects) {
            if (BirdConfig.AlcoholSideEffects) {
                this.poisoncheck = worldIn.field_73012_v.nextFloat();
                if (this.poisoncheck < this.blindness) {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 200, 1));
                }
                if (this.poisoncheck < this.slowness) {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 400, 2));
                }
                if (this.poisoncheck < this.nausea && BirdConfig.NauseaEffects) {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 300, 1));
                }
                if (this.poisoncheck < 0.1f) {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76438_s, 300, 1));
                }
            }
            if (!worldIn.field_72995_K && this.isScumble) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 1200, 0));
                player.func_70690_d(new PotionEffect(MobEffects.field_76422_e, 1200, 1));
            }
            if (!worldIn.field_72995_K && this.isPoitin) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 600, 0));
                player.func_70690_d(new PotionEffect(MobEffects.field_76430_j, 600, 1));
            }
            if (!worldIn.field_72995_K && this.isCider) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76422_e, 1200, 1));
            }
            if (!worldIn.field_72995_K && this.isWine) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 600, 0));
            }
            if (!worldIn.field_72995_K && this.isBeer) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 1200, 0));
            }
            if (!worldIn.field_72995_K && this.isLiquor) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76432_h, 0, 2));
            }
            if (!worldIn.field_72995_K && this.isVodka) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 1200, 1));
            }
            if (!worldIn.field_72995_K && this.isTequila) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76444_x, 300, -3));
            }
            if (!worldIn.field_72995_K && this.isRum) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76427_o, 1200, 1));
            }
            if (!worldIn.field_72995_K && this.isUmeshu) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76441_p, 1200, 1));
            }
        }
        if (!worldIn.field_72995_K && this.potionId != null && worldIn.field_73012_v.nextFloat() < this.potionEffectProbability) {
            player.func_70690_d(new PotionEffect(this.potionId));
        }
        if (!worldIn.field_72995_K && this.isPalliative && BirdConfig.Palliatives && BirdConfig.PalliativeTweak) {
            player.func_184589_d(MobEffects.field_76440_q);
            player.func_184589_d(MobEffects.field_76436_u);
            player.func_184589_d(MobEffects.field_76431_k);
            player.func_184589_d(MobEffects.field_82731_v);
            player.func_184589_d(MobEffects.field_76421_d);
            player.func_184589_d(MobEffects.field_76419_f);
            player.func_184589_d(MobEffects.field_76437_t);
            player.func_184589_d(MobEffects.field_76433_i);
            player.func_184589_d(MobEffects.field_76438_s);
        }
        if (!worldIn.field_72995_K && this.isPalliative && BirdConfig.Palliatives && !BirdConfig.PalliativeTweak) {
            player.func_70674_bp();
        }
        player.field_71071_by.func_70441_a(new ItemStack(Items.field_151069_bo));
    }

    public ItemFood func_185070_a(PotionEffect effect, float probability) {
        this.potionId = effect;
        this.potionEffectProbability = probability;
        return this;
    }

    public static void setItemName(Item item, String itemName) {
        item.setRegistryName("birdsfoods", itemName);
        item.func_77655_b(item.getRegistryName().toString());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (this.isPalliative && BirdConfig.Palliatives && BirdConfig.PalliativeTweak) {
            tooltip.add("Removes negative potion effects");
            tooltip.add("(Vanilla effects only)");
        }
        if (this.isPalliative && BirdConfig.Palliatives && !BirdConfig.PalliativeTweak) {
            tooltip.add("Removes all potion effects");
        }
        if (this.isAlcoholic && BirdConfig.AlcoholEffects) {
            tooltip.add(TextFormatting.RED + "May impair your senses. Drink responsibly");
            if (this.isCider) {
                tooltip.add("Dig deeper, faster");
            }
            if (this.isWine) {
                tooltip.add("Fruit is healthy, right?");
            }
            if (this.isBeer) {
                tooltip.add("Hit like a truck");
            }
            if (this.isLiquor) {
                tooltip.add("Like a healing potion, with side effects");
            }
            if (this.isVodka) {
                tooltip.add("Hard headed and thick skinned");
            }
            if (this.isPoitin) {
                tooltip.add("Put a spring in your step");
            }
            if (this.isTequila) {
                tooltip.add("You'll feel much better when it wears off");
            }
            if (this.isRum) {
                tooltip.add("Drink like a fish, breathe like one too");
            }
            if (this.isUmeshu) {
                tooltip.add("You're certain you had a body just a moment ago");
            }
            if (this.isScumble) {
                tooltip.add("You could probably walk through fire, IF you're still standing");
            }
        }
    }
}

