/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.config;

import com.direwolf20.buildinggadgets.common.config.PatternList;
import net.minecraft.init.Blocks;
import net.minecraftforge.common.config.Config;

@net.minecraftforge.common.config.Config(modid="buildinggadgets", name="Building Gadgets", category="general")
public class Config {
    static final String CATEGORY_ROOT = "general";
    private static final String LANG_KEY_ROOT = "config.buildinggadgets.general";
    private static final String LANG_KEY_BLACKLIST = "config.buildinggadgets.general.subCategoryBlacklist";
    private static final String LANG_KEY_GADGETS = "config.buildinggadgets.general.subCategoryGadgets";
    private static final String LANG_KEY_PASTE_CONTAINERS = "config.buildinggadgets.general.subCategoryPasteContainers";
    private static final String LANG_KEY_GADGET_BUILDING = "config.buildinggadgets.general.subCategoryGadgets.gadgetBuilding";
    private static final String LANG_KEY_GADGET_EXCHANGER = "config.buildinggadgets.general.subCategoryGadgets.gadgetExchanger";
    private static final String LANG_KEY_GADGET_DESTRUCTION = "config.buildinggadgets.general.subCategoryGadgets.gadgetDestruction";
    private static final String LANG_KEY_GADGET_COPY_PASTE = "config.buildinggadgets.general.subCategoryGadgets.gadgetCopyPaste";
    private static final String LANG_KEY_PASTE_CONTAINERS_CAPACITY = "config.buildinggadgets.general.subCategoryPasteContainers.capacity";
    private static final String LANG_KEY_GADGETS_ENERGY = "config.buildinggadgets.general.subCategoryGadgets.energyCost";
    private static final String LANG_KEY_GADGETS_DAMAGE = "config.buildinggadgets.general.subCategoryGadgets.damageCost";
    private static final String LANG_KEY_GADGETS_DURABILITY = "config.buildinggadgets.general.subCategoryGadgets.durability";
    private static final String LANG_KEY_GADGETS_ENERGY_COMMENT = "The Gadget's Energy cost per Operation";
    private static final String LANG_KEY_GADGETS_DAMAGE_COMMENT = "The Gadget's Damage cost per Operation";
    private static final String LANG_KEY_GADGETS_DURABILITY_COMMENT = "The Gadget's Durability (0 means no durability is used) (Ignored if powered by FE)";
    @Config.RangeDouble(min=1.0, max=48.0)
    @Config.Name(value="Max Build Distance")
    @Config.Comment(value={"Defines how far away you can build"})
    @Config.LangKey(value="config.buildinggadgets.general.rayTraceRange")
    public static double rayTraceRange = 32.0;
    @Config.RequiresWorldRestart
    @Config.Name(value="Powered by Forge Energy")
    @Config.Comment(value={"Set to true for Forge Energy Support, set to False for vanilla Item Damage"})
    @Config.LangKey(value="config.buildinggadgets.general.poweredByFE")
    public static boolean poweredByFE = true;
    @Config.RequiresMcRestart
    @Config.RequiresWorldRestart
    @Config.Name(value="Enable Construction Paste")
    @Config.Comment(value={"Set to false to disable the recipe for construction paste."})
    @Config.LangKey(value="config.buildinggadgets.general.paste.enabled")
    public static boolean enablePaste = true;
    @Config.RangeInt(min=0)
    @Config.Name(value="Construction Paste Drop Count - Min")
    @Config.Comment(value={"The minimum number of construction paste items dropped by a dense construction block."})
    @Config.LangKey(value="config.buildinggadgets.general.paste.dropped.min")
    public static int pasteDroppedMin = 1;
    @Config.RangeInt(min=0)
    @Config.Name(value="Construction Paste Drop Count - Max")
    @Config.Comment(value={"The maximum number of construction paste items dropped by a dense construction block."})
    @Config.LangKey(value="config.buildinggadgets.general.paste.dropped.max")
    public static int pasteDroppedMax = 3;
    @Config.RequiresMcRestart
    @Config.RequiresWorldRestart
    @Config.Name(value="Enable Destruction Gadget")
    @Config.Comment(value={"Set to false to disable the Destruction Gadget."})
    @Config.LangKey(value="config.buildinggadgets.general.enableDestructionGadget")
    public static boolean enableDestructionGadget = true;
    @Config.Name(value="Default to absolute Coord-Mode")
    @Config.Comment(value={"Determines if the Copy/Paste GUI's coordinate mode starts in 'Absolute' mode by default.", "Set to true for Absolute, set to False for Relative."})
    @Config.LangKey(value="config.buildinggadgets.general.absoluteCoordDefault")
    public static boolean absoluteCoordDefault = false;
    @Config.Name(value="Allow absolute Coord-Mode")
    @Config.Comment(value={"Disable absolute coords-mode for the Copy-Paste gadget"})
    public static boolean allowAbsoluteCoords = true;
    @Config.Name(value="Allow non-Air-Block-Overwrite")
    @Config.Comment(value={"Whether the Building / CopyPaste Gadget can overwrite blocks like water, lava, grass, etc (like a player can).", "False will only allow it to overwrite air blocks."})
    @Config.LangKey(value="config.buildinggadgets.general.canOverwriteBlocks")
    public static boolean canOverwriteBlocks = true;
    @Config.Name(value="Blacklist Settings")
    @Config.Comment(value={"Configure your Blacklist-Settings here"})
    @Config.LangKey(value="config.buildinggadgets.general.subCategoryBlacklist")
    public static CategoryBlacklist subCategoryBlacklist = new CategoryBlacklist();
    @Config.Name(value="Gadgets")
    @Config.Comment(value={"Configure the Gadgets here"})
    @Config.LangKey(value="config.buildinggadgets.general.subCategoryGadgets")
    public static CategoryGadgets subCategoryGadgets = new CategoryGadgets();
    @Config.Name(value="Paste Containers")
    @Config.Comment(value={"Configure the Paste Containers here"})
    @Config.LangKey(value="config.buildinggadgets.general.subCategoryPasteContainers")
    public static CategoryPasteContainers subCategoryPasteContainers = new CategoryPasteContainers();

    public static final class CategoryPasteContainers {
        @Config.RangeInt(min=1)
        @Config.Comment(value={"The maximum capacity of a tier 1 (iron) Construction Paste Container"})
        @Config.Name(value="T1 Container Capacity")
        @Config.LangKey(value="config.buildinggadgets.general.subCategoryPasteContainers.capacity.t1")
        public int t1Capacity = 512;
        @Config.RangeInt(min=1)
        @Config.Comment(value={"The maximum capacity of a tier 2 (gold) Construction Paste Container"})
        @Config.Name(value="T2 Container Capacity")
        @Config.LangKey(value="config.buildinggadgets.general.subCategoryPasteContainers.capacity.t2")
        public int t2Capacity = 2048;
        @Config.RangeInt(min=1)
        @Config.Comment(value={"The maximum capacity of a tier 3 (diamond) Construction Paste Container"})
        @Config.Name(value="T3 Container Capacity")
        @Config.LangKey(value="config.buildinggadgets.general.subCategoryPasteContainers.capacity.t3")
        public int t3Capacity = 8192;

        private CategoryPasteContainers() {
        }
    }

    public static final class CategoryGadgets {
        @Config.RangeInt(min=1, max=25)
        @Config.Name(value="Maximum allowed Range")
        @Config.Comment(value={"The max range of the Gadgets"})
        @Config.LangKey(value="config.buildinggadgets.general.subCategoryGadgets.maxRange")
        public int maxRange = 15;
        @Config.RangeInt(min=0)
        @Config.Name(value="Maximum Energy")
        @Config.Comment(value={"The max energy of Building, Exchanging & Copy-Paste Gadget"})
        @Config.LangKey(value="config.buildinggadgets.general.subCategoryGadgets.maxEnergy")
        public int maxEnergy = 500000;
        @Config.Name(value="Building Gadget")
        @Config.Comment(value={"Energy Cost & Durability of the Building Gadget"})
        @Config.LangKey(value="config.buildinggadgets.general.subCategoryGadgets.gadgetBuilding")
        public CategoryGadgetBuilding subCategoryGadgetBuilding = new CategoryGadgetBuilding();
        @Config.Name(value="Exchanging Gadget")
        @Config.Comment(value={"Energy Cost & Durability of the Exchanging Gadget"})
        @Config.LangKey(value="config.buildinggadgets.general.subCategoryGadgets.gadgetExchanger")
        public CategoryGadgetExchanger subCategoryGadgetExchanger = new CategoryGadgetExchanger();
        @Config.Name(value="Destruction Gadget")
        @Config.Comment(value={"Energy Cost, Durability & Maximum Energy of the Destruction Gadget"})
        @Config.LangKey(value="config.buildinggadgets.general.subCategoryGadgets.gadgetDestruction")
        public CategoryGadgetDestruction subCategoryGadgetDestruction = new CategoryGadgetDestruction();
        @Config.Name(value="Copy-Paste Gadget")
        @Config.Comment(value={"Energy Cost & Durability of the Copy-Paste Gadget"})
        @Config.LangKey(value="config.buildinggadgets.general.subCategoryGadgets.gadgetCopyPaste")
        public CategoryGadgetCopyPaste subCategoryGadgetCopyPaste = new CategoryGadgetCopyPaste();

        private CategoryGadgets() {
        }

        public static final class CategoryGadgetCopyPaste {
            @Config.RangeInt(min=0, max=100000)
            @Config.Name(value="Energy Cost")
            @Config.Comment(value={"The Gadget's Energy cost per Operation"})
            @Config.LangKey(value="config.buildinggadgets.general.subCategoryGadgets.energyCost")
            public int energyCostCopyPaste = 50;
            @Config.RangeInt(min=0, max=2000)
            @Config.Name(value="Damage Cost")
            @Config.Comment(value={"The Gadget's Damage cost per Operation"})
            @Config.LangKey(value="config.buildinggadgets.general.subCategoryGadgets.damageCost")
            public int damageCostCopyPaste = 1;
            @Config.RequiresWorldRestart
            @Config.RangeInt(min=0, max=100000)
            @Config.Name(value="Durability")
            @Config.Comment(value={"The Gadget's Durability (0 means no durability is used) (Ignored if powered by FE)"})
            @Config.LangKey(value="config.buildinggadgets.general.subCategoryGadgets.durability")
            public int durabilityCopyPaste = 10000;

            private CategoryGadgetCopyPaste() {
            }
        }

        public static final class CategoryGadgetDestruction {
            @Config.RangeInt(min=0)
            @Config.Name(value="Maximum Energy")
            @Config.Comment(value={"The max energy of the Destruction Gadget"})
            @Config.LangKey(value="config.buildinggadgets.general.subCategoryGadgets.gadgetDestruction.maxEnergy")
            public int energyMaxDestruction = 1000000;
            @Config.RangeInt(min=0, max=100000)
            @Config.Name(value="Energy Cost")
            @Config.Comment(value={"The Gadget's Energy cost per Operation"})
            @Config.LangKey(value="config.buildinggadgets.general.subCategoryGadgets.energyCost")
            public int energyCostDestruction = 200;
            @Config.RangeInt(min=0, max=2000)
            @Config.Name(value="Damage Cost")
            @Config.Comment(value={"The Gadget's Damage cost per Operation"})
            @Config.LangKey(value="config.buildinggadgets.general.subCategoryGadgets.damageCost")
            public int damageCostDestruction = 2;
            @Config.RequiresWorldRestart
            @Config.RangeInt(min=0, max=100000)
            @Config.Name(value="Durability")
            @Config.Comment(value={"The Gadget's Durability (0 means no durability is used) (Ignored if powered by FE)"})
            @Config.LangKey(value="config.buildinggadgets.general.subCategoryGadgets.durability")
            public int durabilityDestruction = 10000;
            @Config.RangeDouble(min=0.0)
            @Config.Name(value="Non-Fuzzy Mode Multiplier")
            @Config.Comment(value={"The cost in energy/durability will increase by this amount when not in fuzzy mode"})
            @Config.LangKey(value="config.buildinggadgets.general.subCategoryGadgets.gadgetDestruction.nonfuzzy.multiplier")
            public double nonFuzzyMultiplier = 2.0;
            @Config.Name(value="Non-Fuzzy Mode Enabled")
            @Config.Comment(value={"If enabled, the Destruction Gadget can be taken out of fuzzy mode, allowing only instances of the block clicked to be removed (at a higher cost)"})
            @Config.LangKey(value="config.buildinggadgets.general.subCategoryGadgets.gadgetDestruction.nonfuzzy.enabled")
            public boolean nonFuzzyEnabled = false;

            private CategoryGadgetDestruction() {
            }
        }

        public static final class CategoryGadgetExchanger {
            @Config.RangeInt(min=0, max=100000)
            @Config.Name(value="Energy Cost")
            @Config.Comment(value={"The Gadget's Energy cost per Operation"})
            @Config.LangKey(value="config.buildinggadgets.general.subCategoryGadgets.energyCost")
            public int energyCostExchanger = 100;
            @Config.RangeInt(min=0, max=2000)
            @Config.Name(value="Damage Cost")
            @Config.Comment(value={"The Gadget's Damage cost per Operation"})
            @Config.LangKey(value="config.buildinggadgets.general.subCategoryGadgets.damageCost")
            public int damageCostExchanger = 2;
            @Config.RequiresWorldRestart
            @Config.RangeInt(min=0, max=100000)
            @Config.Name(value="Durability")
            @Config.Comment(value={"The Gadget's Durability (0 means no durability is used) (Ignored if powered by FE)"})
            @Config.LangKey(value="config.buildinggadgets.general.subCategoryGadgets.durability")
            public int durabilityExchanger = 10000;

            private CategoryGadgetExchanger() {
            }
        }

        public static final class CategoryGadgetBuilding {
            @Config.RangeInt(min=0, max=100000)
            @Config.Name(value="Energy Cost")
            @Config.Comment(value={"The Gadget's Energy cost per Operation"})
            @Config.LangKey(value="config.buildinggadgets.general.subCategoryGadgets.energyCost")
            public int energyCostBuilder = 50;
            @Config.RangeInt(min=0, max=2000)
            @Config.Name(value="Damage Cost")
            @Config.Comment(value={"The Gadget's Damage cost per Operation"})
            @Config.LangKey(value="config.buildinggadgets.general.subCategoryGadgets.damageCost")
            public int damageCostBuilder = 1;
            @Config.RequiresWorldRestart
            @Config.RangeInt(min=0, max=100000)
            @Config.Name(value="Durability")
            @Config.Comment(value={"The Gadget's Durability (0 means no durability is used) (Ignored if powered by FE)"})
            @Config.LangKey(value="config.buildinggadgets.general.subCategoryGadgets.durability")
            public int durabilityBuilder = 10000;

            private CategoryGadgetBuilding() {
            }
        }
    }

    public static final class CategoryBlacklist {
        @Config.Name(value="Blacklisted Blocks")
        @Config.Comment(value={"All Blocks added to this will be treated similar to TileEntities. Not at all.", "Notice that you can use Regular Expressions as defined by Java Patterns to express more complex name combinations.", "Use for example \"awfulmod:.*\" to blacklist all awfulmod Blocks."})
        @Config.LangKey(value="config.buildinggadgets.general.subCategoryBlacklist + blockBlacklist")
        public String[] blockBlacklist = new String[]{"minecraft:.*_door.*", PatternList.getName(Blocks.field_150332_K)};
    }
}

