/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.environmentalcreepers;

import fi.dy.masa.environmentalcreepers.commands.CommandReloadConfigs;
import fi.dy.masa.environmentalcreepers.config.Configs;
import fi.dy.masa.environmentalcreepers.event.ExplosionEventHandler;
import fi.dy.masa.environmentalcreepers.proxy.ServerProxy;
import java.io.File;
import net.minecraft.command.ICommand;
import net.minecraft.world.chunk.storage.AnvilSaveConverter;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="environmentalcreepers", name="Environmental Creepers", version="1.6.0", certificateFingerprint="2b03e1423915a189b8094816baa18f239d576dff", guiFactory="fi.dy.masa.environmentalcreepers.config.EnvironmentalCreepersGuiFactory", updateJSON="https://raw.githubusercontent.com/maruohon/environmentalcreepers/master/update.json", acceptableRemoteVersions="*", acceptedMinecraftVersions="1.12")
public class EnvironmentalCreepers {
    @Mod.Instance(value="environmentalcreepers")
    public static EnvironmentalCreepers instance;
    @SidedProxy(clientSide="fi.dy.masa.environmentalcreepers.proxy.ClientProxy", serverSide="fi.dy.masa.environmentalcreepers.proxy.ServerProxy")
    public static ServerProxy proxy;
    public static final Logger logger;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        instance = this;
        Configs.setGlobalConfigDirAndLoadConfigs(event.getModConfigurationDirectory());
        MinecraftForge.EVENT_BUS.register((Object)new ExplosionEventHandler());
        proxy.registerEventHandlers();
    }

    @Mod.EventHandler
    public void onServerAboutToStart(FMLServerAboutToStartEvent event) {
        File worldDir = new File(((AnvilSaveConverter)event.getServer().func_71254_M()).field_75808_a, event.getServer().func_71270_I());
        Configs.loadConfigsFromPerWorldConfigIfExists(worldDir);
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandReloadConfigs());
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent event) {
        Configs.loadConfigsFromGlobalConfigFile();
    }

    public static void logInfo(String message, Object ... params) {
        if (Configs.verboseLogging) {
            logger.info(message, params);
        }
    }

    @Mod.EventHandler
    public void onFingerPrintViolation(FMLFingerprintViolationEvent event) {
        if (!event.isDirectory()) {
            logger.warn("*********************************************************************************************");
            logger.warn("*****                                    WARNING                                        *****");
            logger.warn("*****                                                                                   *****");
            logger.warn("*****   The signature of the mod file '{}' does not match the expected fingerprint!     *****", (Object)event.getSource().getName());
            logger.warn("*****   This might mean that the mod file has been tampered with!                       *****");
            logger.warn("*****   If you did not download the mod {} directly from Curse/CurseForge,       *****", (Object)"Environmental Creepers");
            logger.warn("*****   or using one of the well known launchers, and you did not                       *****");
            logger.warn("*****   modify the mod file at all yourself, then it's possible,                        *****");
            logger.warn("*****   that it may contain malware or other unwanted things!                           *****");
            logger.warn("*********************************************************************************************");
        }
    }

    static {
        logger = LogManager.getLogger((String)"environmentalcreepers");
    }
}

