/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.util;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemUtil {
    public static boolean equalWithoutSize(ItemStack item1, ItemStack item2) {
        if (item1.func_77973_b() != item2.func_77973_b()) {
            return false;
        }
        if (item1.func_77952_i() != item2.func_77952_i()) {
            return false;
        }
        if (item1.func_77978_p() == null && item2.func_77978_p() != null) {
            return false;
        }
        return (item1.func_77978_p() == null || item1.func_77978_p().equals((Object)item2.func_77978_p())) && item1.areCapsCompatible(item2);
    }

    public static boolean equalWithoutDamage(ItemStack item1, ItemStack item2) {
        if (item1.func_77973_b() != item2.func_77973_b()) {
            return false;
        }
        if (item1.func_190916_E() != item2.func_190916_E()) {
            return false;
        }
        if (item1.func_77978_p() == null && item2.func_77978_p() != null) {
            return false;
        }
        return (item1.func_77978_p() == null || item1.func_77978_p().equals((Object)item2.func_77978_p())) && item1.areCapsCompatible(item2);
    }

    public static EntityItem spawnItem(World world, BlockPos pos, ItemStack stack) {
        return ItemUtil.spawnItem(world, pos, stack, -1);
    }

    public static EntityItem spawnItem(World world, BlockPos pos, ItemStack stack, float hoverStart) {
        return ItemUtil.spawnItem(world, pos, stack, true, -1, hoverStart);
    }

    public static EntityItem spawnItem(World world, BlockPos pos, ItemStack stack, int ticks) {
        return ItemUtil.spawnItem(world, pos, stack, true, ticks, -1.0f);
    }

    public static EntityItem spawnItem(World world, BlockPos pos, ItemStack stack, boolean offset) {
        return ItemUtil.spawnItem(world, pos, stack, offset, -1, -1.0f);
    }

    public static EntityItem spawnItem(World world, BlockPos pos, ItemStack stack, boolean offset, int ticks, float hoverStart) {
        return ItemUtil.spawnItem(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), offset, stack, ticks, hoverStart);
    }

    public static EntityItem spawnItem(World world, double x, double y, double z, boolean offset, ItemStack stack, int ticks, float hoverStart) {
        if (offset) {
            x += 0.5;
            y += 0.5;
            z += 0.5;
        }
        EntityItem item = new EntityItem(world, x, y, z, stack);
        if (ticks != -1) {
            item.func_174867_a(ticks);
        }
        if (hoverStart != -1.0f) {
            item.field_70290_d = hoverStart;
        }
        return ItemUtil.spawnItem(world, item);
    }

    public static EntityItem spawnItem(World world, EntityItem item) {
        item.field_70179_y = 0.0;
        item.field_70159_w = 0.0;
        item.field_70181_x = 0.0;
        world.func_72838_d((Entity)item);
        return item;
    }

    public static ItemStack stackFromState(IBlockState state) {
        Block block = state.func_177230_c();
        Item item = Item.func_150898_a((Block)block);
        int meta = block.func_176201_c(state);
        return new ItemStack(item, 1, meta);
    }

    @Nullable
    public static IBlockState stateFromStack(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (!(item instanceof ItemBlock)) {
            return null;
        }
        Block block = ((ItemBlock)item).func_179223_d();
        return block.func_176203_a(stack.func_77960_j());
    }
}

