/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.item;

import epicsquid.mysticallib.item.ItemShearsBase;
import epicsquid.mysticallib.network.PacketHandler;
import epicsquid.mysticallib.particle.particles.ParticleGlitter;
import epicsquid.mysticallib.proxy.ClientProxy;
import epicsquid.mysticallib.util.ItemUtil;
import epicsquid.mysticallib.util.Util;
import epicsquid.roots.capability.life_essence.LifeEssenceCapability;
import epicsquid.roots.capability.life_essence.LifeEssenceCapabilityProvider;
import epicsquid.roots.capability.runic_shears.RunicShearsCapability;
import epicsquid.roots.capability.runic_shears.RunicShearsCapabilityProvider;
import epicsquid.roots.config.GeneralConfig;
import epicsquid.roots.config.MossConfig;
import epicsquid.roots.init.ModBlocks;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.init.ModRecipes;
import epicsquid.roots.network.fx.MessageRunicShearsAOEFX;
import epicsquid.roots.network.fx.MessageRunicShearsFX;
import epicsquid.roots.recipe.RunicShearEntityRecipe;
import epicsquid.roots.recipe.RunicShearRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemRunicShears
extends ItemShearsBase {
    public static AxisAlignedBB bounding = new AxisAlignedBB(-2.0, -2.0, -2.0, 2.0, 2.0, 2.0);
    private Random random;

    public ItemRunicShears(@Nonnull String name) {
        super(name);
        this.func_77656_e(357);
        this.func_77625_d(1);
        this.func_77627_a(false);
        this.random = new Random();
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        Item item = repair.func_77973_b();
        if (item instanceof ItemBlock) {
            Block block = ((ItemBlock)item).func_179223_d();
            return ModBlocks.runestoneBlocks.contains(block);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block == ModBlocks.imbuer) {
            return EnumActionResult.PASS;
        }
        IBlockState moss = MossConfig.scrapeResult(state);
        IBlockState moss2 = MossConfig.mossConversion(state);
        if (moss != null || moss2 != null) {
            if (!world.field_72995_K) {
                AxisAlignedBB bounds = bounding.func_186670_a(pos);
                BlockPos start = new BlockPos(bounds.field_72340_a, bounds.field_72338_b, bounds.field_72339_c);
                BlockPos stop = new BlockPos(bounds.field_72336_d, bounds.field_72337_e, bounds.field_72334_f);
                ArrayList<BlockPos> affectedBlocks = new ArrayList<BlockPos>();
                for (BlockPos.MutableBlockPos p : BlockPos.func_177975_b((BlockPos)start, (BlockPos)stop)) {
                    IBlockState pState = world.func_180495_p((BlockPos)p);
                    IBlockState m = MossConfig.scrapeResult(pState);
                    if (m == null) continue;
                    affectedBlocks.add(p.func_185334_h());
                    world.func_175656_a((BlockPos)p, m);
                    world.func_180497_b((BlockPos)p, m.func_177230_c(), 1, m.func_177230_c().func_149738_a(world));
                    ItemUtil.spawnItem((World)world, (BlockPos)player.func_180425_c().func_177982_a(0, 1, 0), (ItemStack)new ItemStack(ModItems.terra_moss));
                }
                if (!affectedBlocks.isEmpty()) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.func_184586_b(hand).func_77972_a(1 + Math.min(6, this.random.nextInt(affectedBlocks.size())), (EntityLivingBase)player);
                    }
                    MessageRunicShearsAOEFX message = new MessageRunicShearsAOEFX(affectedBlocks);
                    PacketHandler.sendToAllTracking((IMessage)message, (int)world.field_73011_w.getDimension(), (BlockPos)pos);
                }
            }
            player.func_184609_a(hand);
            world.func_184133_a(null, pos, SoundEvents.field_187763_eJ, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return EnumActionResult.SUCCESS;
        }
        RunicShearRecipe recipe = ModRecipes.getRunicShearRecipe(block);
        if (recipe == null) return EnumActionResult.SUCCESS;
        if (!world.field_72995_K) {
            if (block instanceof BlockCrops) {
                if (!((BlockCrops)block).func_185525_y(world.func_180495_p(pos))) return EnumActionResult.SUCCESS;
                world.func_175656_a(pos, ((BlockCrops)block).func_185528_e(0));
            } else {
                world.func_175656_a(pos, recipe.getReplacementBlock().func_176223_P());
            }
            ItemUtil.spawnItem((World)world, (BlockPos)player.func_180425_c().func_177982_a(0, 1, 0), (ItemStack)recipe.getDrop().func_77946_l());
            if (!player.field_71075_bZ.field_75098_d) {
                player.func_184586_b(hand).func_77972_a(1, (EntityLivingBase)player);
            }
            player.func_184609_a(hand);
            world.func_184133_a(null, pos, SoundEvents.field_187763_eJ, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return EnumActionResult.SUCCESS;
        } else {
            for (int i = 0; i < 50; ++i) {
                ClientProxy.particleRenderer.spawnParticle(world, Util.getLowercaseClassName(ParticleGlitter.class), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, this.random.nextDouble() * 0.1 * (double)(this.random.nextDouble() > 0.5 ? -1 : 1), this.random.nextDouble() * 0.1 * (double)(this.random.nextDouble() > 0.5 ? -1 : 1), this.random.nextDouble() * 0.1 * (double)(this.random.nextDouble() > 0.5 ? -1 : 1), new double[]{120.0, 0.855 + this.random.nextDouble() * 0.05, 0.71, 0.943 - this.random.nextDouble() * 0.05, 1.0, this.random.nextDouble() + 0.5, this.random.nextDouble() * 2.0});
            }
        }
        return EnumActionResult.SUCCESS;
    }

    public boolean func_111207_a(ItemStack itemstack, EntityPlayer player, EntityLivingBase entity, EnumHand hand) {
        World world = player.field_70170_p;
        Random rand = field_77697_d;
        if (entity.func_70631_g_()) {
            return true;
        }
        if (!player.func_70093_af()) {
            RunicShearEntityRecipe recipe = ModRecipes.getRunicShearRecipe(entity);
            if (recipe != null) {
                RunicShearsCapability cap;
                player.func_184609_a(hand);
                if (!world.field_72995_K && (cap = (RunicShearsCapability)((Object)entity.getCapability(RunicShearsCapabilityProvider.RUNIC_SHEARS_CAPABILITY, null))) != null) {
                    if (cap.canHarvest()) {
                        cap.setCooldown(recipe.getCooldown());
                        EntityItem ent = entity.func_70099_a(recipe.getDrop().func_77946_l(), 1.0f);
                        ent.field_70181_x += (double)(rand.nextFloat() * 0.05f);
                        ent.field_70159_w += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
                        ent.field_70179_y += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
                        if (!player.field_71075_bZ.field_75098_d) {
                            itemstack.func_77972_a(1, entity);
                        }
                        world.func_184133_a(null, entity.func_180425_c(), SoundEvents.field_187763_eJ, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        MessageRunicShearsFX packet = new MessageRunicShearsFX((Entity)entity);
                        PacketHandler.sendToAllTracking((IMessage)packet, (Entity)entity);
                        return true;
                    }
                    player.func_146105_b(new TextComponentTranslation("roots.runic_shears.cooldown", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_PURPLE)), true);
                }
            }
        } else {
            LifeEssenceCapability cap = (LifeEssenceCapability)((Object)entity.getCapability(LifeEssenceCapabilityProvider.LIFE_ESSENCE_CAPABILITY, null));
            if (cap != null) {
                if (cap.canHarvest()) {
                    player.func_184609_a(hand);
                    if (!world.field_72995_K) {
                        cap.setCooldown(7200L);
                        ItemStack stack = new ItemStack(ModItems.life_essence);
                        NBTTagCompound tag = stack.func_77978_p();
                        if (tag == null) {
                            tag = new NBTTagCompound();
                            stack.func_77982_d(tag);
                        }
                        tag.func_74778_a("id", EntityList.func_191301_a((Entity)entity).toString());
                        EntityItem ent = entity.func_70099_a(stack, 1.0f);
                        ent.field_70181_x += (double)(rand.nextFloat() * 0.05f);
                        ent.field_70159_w += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
                        ent.field_70179_y += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
                        if (!player.field_71075_bZ.field_75098_d) {
                            itemstack.func_77972_a(1, entity);
                        }
                        world.func_184133_a(player, entity.func_180425_c(), SoundEvents.field_187763_eJ, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        MessageRunicShearsFX packet = new MessageRunicShearsFX((Entity)entity);
                        PacketHandler.sendToAllTracking((IMessage)packet, (Entity)entity);
                        return true;
                    }
                } else {
                    player.func_146105_b(new TextComponentTranslation("roots.life_essence.cooldown", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_PURPLE)), true);
                }
            } else {
                player.func_146105_b(new TextComponentTranslation("roots.life_essence.invalid", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_PURPLE)), true);
            }
        }
        if (entity instanceof IShearable) {
            int count = 0;
            if (Items.field_151097_aZ.func_111207_a(itemstack, player, entity, hand)) {
                ++count;
            }
            float radius = GeneralConfig.RunicShearsRadius;
            List entities = Util.getEntitiesWithinRadius((World)entity.field_70170_p, e -> e instanceof IShearable, (BlockPos)entity.func_180425_c(), (float)radius, (float)(radius / 2.0f), (float)radius);
            for (EntityLiving e2 : entities) {
                e2.captureDrops = true;
                if (Items.field_151097_aZ.func_111207_a(itemstack, player, (EntityLivingBase)e2, hand)) {
                    ++count;
                }
                e2.captureDrops = false;
                if (world.field_72995_K) continue;
                for (EntityItem ent : e2.capturedDrops) {
                    ent.func_70107_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                    ent.field_70181_x = 0.0;
                    ent.field_70159_w = 0.0;
                    ent.field_70179_y = 0.0;
                    ent.field_70170_p.func_72838_d((Entity)ent);
                }
            }
            if (count > 0) {
                player.func_184609_a(hand);
                return true;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add("");
        tooltip.add(I18n.func_135052_a((String)"roots.runic_shears.tooltip1", (Object[])new Object[]{TextFormatting.BOLD + "" + TextFormatting.AQUA + I18n.func_135052_a((String)"roots.runic_shears.right_click", (Object[])new Object[0]) + TextFormatting.RESET + TextFormatting.GREEN}));
        tooltip.add(I18n.func_135052_a((String)"roots.runic_shears.tooltip2", (Object[])new Object[]{TextFormatting.BOLD + "" + TextFormatting.AQUA + I18n.func_135052_a((String)"roots.runic_shears.sneak_right_click", (Object[])new Object[0]) + TextFormatting.RESET + TextFormatting.GREEN}));
    }
}

