/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.integration.crafttweaker.tweaks;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.block.IBlock;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.mc1120.CraftTweaker;
import epicsquid.roots.init.ModRecipes;
import epicsquid.roots.integration.crafttweaker.Action;
import epicsquid.roots.util.zen.ZenDocAppend;
import epicsquid.roots.util.zen.ZenDocArg;
import epicsquid.roots.util.zen.ZenDocClass;
import epicsquid.roots.util.zen.ZenDocMethod;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenDocClass(value="mods.roots.FlowerGrowth")
@ZenDocAppend(value={"docs/include/flower_growth.example.md"})
@ZenRegister
@ZenClass(value="mods.roots.FlowerGrowth")
public class FlowerTweaker {
    @ZenDocMethod(order=1, args={@ZenDocArg(arg="name", info="The name of the recipe you wish to remove")})
    @ZenMethod
    public static void removeRecipe(String name) {
        CraftTweaker.LATE_ACTIONS.add(new Remove(name));
    }

    @ZenDocMethod(order=2, args={@ZenDocArg(arg="name", info="The name of the recipe that you're adding"), @ZenDocArg(arg="state", info="The state of the block of the flower")})
    @ZenMethod
    public static void addRecipeBlockState(String name, crafttweaker.api.block.IBlockState state) {
        CraftTweaker.LATE_ACTIONS.add(new FlowerBlockState(name, CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)state)));
    }

    @ZenDocMethod(order=3, args={@ZenDocArg(arg="name", info="The name of the recipe that you're adding"), @ZenDocArg(arg="block", info="The block of the flower to be placed"), @ZenDocArg(arg="meta", info="The meta of the state of the flower block")})
    @ZenMethod
    public static void addRecipeBlock(String name, IBlock block, int meta) {
        CraftTweaker.LATE_ACTIONS.add(new FlowerBlockMeta(name, CraftTweakerMC.getBlock((IBlock)block), meta));
    }

    private static class FlowerBlockMeta
    extends Action {
        private final Block block;
        private final int meta;
        private final String name;

        protected FlowerBlockMeta(String name, Block block, int meta) {
            super("add_block_meta_flower");
            this.name = name;
            this.block = block;
            this.meta = meta;
        }

        public void apply() {
            ModRecipes.addFlowerRecipe(this.name, this.block, this.meta);
        }

        public String describe() {
            return String.format("Recipe to produce %s:%s with FlowerGrowth", this.block, this.meta);
        }
    }

    private static class FlowerBlockState
    extends Action {
        private final IBlockState state;
        private final String name;

        protected FlowerBlockState(String name, IBlockState state) {
            super("add_flower_block_state");
            this.name = name;
            this.state = state;
        }

        public void apply() {
            ModRecipes.addFlowerRecipe(this.name, this.state);
        }

        public String describe() {
            return String.format("Recipe to add %s to FlowerGrowth", this.state);
        }
    }

    private static class Remove
    extends Action {
        private final ResourceLocation name;

        public Remove(String name) {
            super("remove_flower");
            this.name = name.contains(":") ? new ResourceLocation(name) : new ResourceLocation("roots", name);
        }

        public void apply() {
            ModRecipes.removeFlowerRecipe(this.name);
        }

        public String describe() {
            return String.format("Recipe to remove %s from FlowerGrowth", this.name);
        }
    }
}

