/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedcrafting.inventory.container;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.helper.ValueNotifierHelpers;
import org.cyclops.cyclopscore.inventory.IValueNotifier;
import org.cyclops.integratedcrafting.part.PartTypeInterfaceCrafting;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerPartSettings;

public class ContainerPartInterfaceCraftingSettings
extends ContainerPartSettings {
    private final int lastChannelInterfaceCraftingValueId = this.getNextValueId();
    private final Map<IngredientComponent<?, ?>, Integer> targetSideOverrideValueIds = Maps.newIdentityHashMap();

    public ContainerPartInterfaceCraftingSettings(EntityPlayer player, PartTarget target, IPartContainer partContainer, IPartType partType) {
        super(player, target, partContainer, partType);
        for (ResourceLocation key : Sets.newTreeSet((Iterable)IngredientComponent.REGISTRY.getKeys())) {
            IngredientComponent ingredientComponent = (IngredientComponent)IngredientComponent.REGISTRY.getValue(key);
            this.targetSideOverrideValueIds.put(ingredientComponent, this.getNextValueId());
        }
    }

    protected int getPlayerInventoryOffsetY() {
        return 154;
    }

    protected void initializeValues() {
        super.initializeValues();
        ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.lastChannelInterfaceCraftingValueId, (int)((PartTypeInterfaceCrafting.State)this.getPartState()).getChannelCrafting());
        for (IngredientComponent ingredientComponent : IngredientComponent.REGISTRY.getValuesCollection()) {
            ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.getTargetSideOverrideValueId(ingredientComponent), (int)((PartTypeInterfaceCrafting.State)this.getPartState()).getIngredientComponentTargetSideOverride(ingredientComponent).ordinal());
        }
    }

    public int getLastChannelInterfaceCraftingValueId() {
        return this.lastChannelInterfaceCraftingValueId;
    }

    public int getLastChannelInterfaceValue() {
        return ValueNotifierHelpers.getValueInt((IValueNotifier)this, (int)this.lastChannelInterfaceCraftingValueId);
    }

    public int getTargetSideOverrideValueId(IngredientComponent<?, ?> ingredientComponent) {
        return this.targetSideOverrideValueIds.get(ingredientComponent);
    }

    @Nullable
    public EnumFacing getTargetSideOverrideValue(IngredientComponent<?, ?> ingredientComponent) {
        int i = ValueNotifierHelpers.getValueInt((IValueNotifier)this, (int)this.getTargetSideOverrideValueId(ingredientComponent));
        if (i < 0) {
            return this.getTarget().getTarget().getSide();
        }
        return EnumFacing.field_82609_l[i];
    }

    protected void updatePartSettings() {
        super.updatePartSettings();
        ((PartTypeInterfaceCrafting.State)this.getPartState()).setChannelCrafting(this.getLastChannelInterfaceValue());
        for (IngredientComponent ingredientComponent : IngredientComponent.REGISTRY.getValuesCollection()) {
            ((PartTypeInterfaceCrafting.State)this.getPartState()).setIngredientComponentTargetSideOverride(ingredientComponent, this.getTargetSideOverrideValue(ingredientComponent));
        }
    }
}

