/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedcrafting.core.crafting.processoverride;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.mojang.authlib.GameProfile;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.BlockWorkbench;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.integratedcrafting.api.crafting.ICraftingProcessOverride;
import org.cyclops.integratedcrafting.api.crafting.ICraftingResultsSink;
import org.cyclops.integratedcrafting.core.crafting.processoverride.CraftingGrid;
import org.cyclops.integrateddynamics.api.part.PartPos;

public class CraftingProcessOverrideCraftingTable
implements ICraftingProcessOverride {
    private static final LoadingCache<Pair<CraftingGrid, Integer>, IRecipe> CACHE_RECIPES = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Pair<CraftingGrid, Integer>, IRecipe>(){

        public IRecipe load(Pair<CraftingGrid, Integer> key) {
            IRecipe recipe = CraftingManager.func_192413_b((InventoryCrafting)((InventoryCrafting)key.getLeft()), (World)DimensionManager.getWorld((int)((Integer)key.getRight())));
            if (recipe == null) {
                recipe = NULL_RECIPE;
            }
            return recipe;
        }
    });
    private static final IRecipe NULL_RECIPE = new IRecipe(){

        public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
            return false;
        }

        public ItemStack func_77572_b(InventoryCrafting inv) {
            return null;
        }

        public boolean func_194133_a(int width, int height) {
            return false;
        }

        public ItemStack func_77571_b() {
            return null;
        }

        public IRecipe setRegistryName(ResourceLocation name) {
            return null;
        }

        @Nullable
        public ResourceLocation getRegistryName() {
            return null;
        }

        public Class<IRecipe> getRegistryType() {
            return null;
        }
    };
    private static GameProfile PROFILE = new GameProfile(UUID.fromString("41C82C87-7AfB-4024-BB57-13D2C99CAE77"), "[IntegratedCrafting]");
    private static final Map<WorldServer, FakePlayer> FAKE_PLAYERS = new WeakHashMap<WorldServer, FakePlayer>();

    @Nullable
    public static IRecipe getRecipe(CraftingGrid grid, World world) {
        try {
            IRecipe recipe = (IRecipe)CACHE_RECIPES.get((Object)Pair.of((Object)((Object)grid), (Object)world.field_73011_w.getDimension()));
            if (recipe == NULL_RECIPE) {
                recipe = null;
            }
            return recipe;
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            return null;
        }
    }

    public static FakePlayer getFakePlayer(WorldServer world) {
        FakePlayer fakePlayer = FAKE_PLAYERS.get(world);
        if (fakePlayer == null) {
            fakePlayer = new FakePlayer(world, PROFILE);
            FAKE_PLAYERS.put(world, fakePlayer);
        }
        return fakePlayer;
    }

    @Override
    public boolean isApplicable(PartPos target) {
        return target.getPos().getWorld().func_180495_p(target.getPos().getBlockPos()).func_177230_c() instanceof BlockWorkbench;
    }

    @Override
    public boolean craft(Function<IngredientComponent<?, ?>, PartPos> targetGetter, IMixedIngredients ingredients, ICraftingResultsSink resultsSink, boolean simulate) {
        CraftingGrid grid = new CraftingGrid(ingredients, 3, 3);
        PartPos target = targetGetter.apply(IngredientComponent.ITEMSTACK);
        IRecipe recipe = CraftingProcessOverrideCraftingTable.getRecipe(grid, target.getPos().getWorld());
        if (recipe != null) {
            ItemStack result = recipe.func_77572_b((InventoryCrafting)grid);
            if (result.func_190926_b()) {
                return false;
            }
            if (!simulate) {
                FakePlayer player = CraftingProcessOverrideCraftingTable.getFakePlayer((WorldServer)target.getPos().getWorld());
                result.func_77980_a(target.getPos().getWorld(), (EntityPlayer)player, 1);
                FMLCommonHandler.instance().firePlayerCraftingEvent((EntityPlayer)player, result, (IInventory)grid);
                resultsSink.addResult(IngredientComponent.ITEMSTACK, result);
                for (ItemStack remainingItem : recipe.func_179532_b((InventoryCrafting)grid)) {
                    if (remainingItem.func_190926_b()) continue;
                    resultsSink.addResult(IngredientComponent.ITEMSTACK, remainingItem);
                }
            }
            return true;
        }
        return false;
    }
}

