/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedcrafting.core;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientSerializer;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.integratedcrafting.GeneralConfig;
import org.cyclops.integratedcrafting.IntegratedCrafting;
import org.cyclops.integratedcrafting.api.crafting.CraftingJob;
import org.cyclops.integratedcrafting.api.crafting.CraftingJobDependencyGraph;
import org.cyclops.integratedcrafting.api.crafting.CraftingJobStatus;
import org.cyclops.integratedcrafting.api.crafting.ICraftingProcessOverride;
import org.cyclops.integratedcrafting.api.crafting.ICraftingResultsSink;
import org.cyclops.integratedcrafting.api.network.ICraftingNetwork;
import org.cyclops.integratedcrafting.core.CraftingHelpers;
import org.cyclops.integratedcrafting.core.MissingIngredients;
import org.cyclops.integratedcrafting.core.PendingCraftingJobResultIndexObserver;
import org.cyclops.integrateddynamics.api.ingredient.IIngredientComponentStorageObservable;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPositionedAddonsNetworkIngredients;
import org.cyclops.integrateddynamics.api.part.PartPos;

public class CraftingJobHandler {
    private final int maxProcessingJobs;
    private final ICraftingResultsSink resultsSink;
    private final Collection<ICraftingProcessOverride> craftingProcessOverrides;
    private final Int2ObjectMap<CraftingJob> allCraftingJobs;
    private final Int2ObjectMap<CraftingJob> processingCraftingJobs;
    private final Int2ObjectMap<Map<IngredientComponent<?, ?>, List<IPrototypedIngredient<?, ?>>>> processingCraftingJobsPendingIngredients;
    private final Int2ObjectMap<CraftingJob> pendingCraftingJobs;
    private final Object2IntMap<IngredientComponent<?, ?>> ingredientObserverCounters;
    private final Map<IngredientComponent<?, ?>, IIngredientComponentStorageObservable.IIndexChangeObserver<?, ?>> ingredientObservers;
    private final List<IngredientComponent<?, ?>> observersPendingCreation;
    private final List<IngredientComponent<?, ?>> observersPendingDeletion;
    private final Int2ObjectMap<CraftingJob> finishedCraftingJobs;
    private final Map<IngredientComponent<?, ?>, EnumFacing> ingredientComponentTargetOverrides;

    public CraftingJobHandler(int maxProcessingJobs, Collection<ICraftingProcessOverride> craftingProcessOverrides, ICraftingResultsSink resultsSink) {
        this.maxProcessingJobs = maxProcessingJobs;
        this.resultsSink = resultsSink;
        this.craftingProcessOverrides = craftingProcessOverrides;
        this.allCraftingJobs = new Int2ObjectOpenHashMap();
        this.processingCraftingJobs = new Int2ObjectOpenHashMap();
        this.pendingCraftingJobs = new Int2ObjectOpenHashMap();
        this.processingCraftingJobsPendingIngredients = new Int2ObjectOpenHashMap();
        this.ingredientObserverCounters = new Object2IntOpenHashMap();
        this.ingredientObservers = Maps.newIdentityHashMap();
        this.observersPendingCreation = Lists.newArrayList();
        this.observersPendingDeletion = Lists.newArrayList();
        this.finishedCraftingJobs = new Int2ObjectOpenHashMap();
        this.ingredientComponentTargetOverrides = Maps.newIdentityHashMap();
    }

    public void writeToNBT(NBTTagCompound tag) {
        NBTTagList processingCraftingJobs = new NBTTagList();
        for (CraftingJob processingCraftingJob : this.processingCraftingJobs.values()) {
            NBTTagCompound entryTag = new NBTTagCompound();
            entryTag.func_74782_a("craftingJob", (NBTBase)CraftingJob.serialize(processingCraftingJob));
            Map ingredients = (Map)this.processingCraftingJobsPendingIngredients.get(processingCraftingJob.getId());
            NBTTagList pendingIngredientInstances = new NBTTagList();
            for (Map.Entry ingredientComponentListEntry : ingredients.entrySet()) {
                NBTTagCompound ingredientInstance = new NBTTagCompound();
                IngredientComponent ingredientComponent = (IngredientComponent)ingredientComponentListEntry.getKey();
                ingredientInstance.func_74778_a("ingredientComponent", ingredientComponent.getRegistryName().toString());
                NBTTagList instances = new NBTTagList();
                IIngredientSerializer serializer = ingredientComponent.getSerializer();
                for (IPrototypedIngredient prototypedIngredient : (List)ingredientComponentListEntry.getValue()) {
                    NBTTagCompound instance = new NBTTagCompound();
                    instance.func_74782_a("prototype", serializer.serializeInstance(prototypedIngredient.getPrototype()));
                    instance.func_74782_a("condition", serializer.serializeCondition(prototypedIngredient.getCondition()));
                    instances.func_74742_a((NBTBase)instance);
                }
                ingredientInstance.func_74782_a("instances", (NBTBase)instances);
                pendingIngredientInstances.func_74742_a((NBTBase)ingredientInstance);
            }
            entryTag.func_74782_a("pendingIngredientInstances", (NBTBase)pendingIngredientInstances);
            processingCraftingJobs.func_74742_a((NBTBase)entryTag);
        }
        tag.func_74782_a("processingCraftingJobs", (NBTBase)processingCraftingJobs);
        NBTTagList pendingCraftingJobs = new NBTTagList();
        for (CraftingJob craftingJob : this.pendingCraftingJobs.values()) {
            pendingCraftingJobs.func_74742_a((NBTBase)CraftingJob.serialize(craftingJob));
        }
        tag.func_74782_a("pendingCraftingJobs", (NBTBase)pendingCraftingJobs);
        NBTTagCompound targetOverrides = new NBTTagCompound();
        for (Map.Entry<IngredientComponent<?, ?>, EnumFacing> entry : this.ingredientComponentTargetOverrides.entrySet()) {
            targetOverrides.func_74768_a(entry.getKey().getName().toString(), entry.getValue().ordinal());
        }
        tag.func_74782_a("targetOverrides", (NBTBase)targetOverrides);
    }

    public void readFromNBT(NBTTagCompound tag) {
        NBTTagList processingCraftingJobs = tag.func_150295_c("processingCraftingJobs", 10);
        for (Object entry : processingCraftingJobs) {
            NBTTagCompound entryTag = (NBTTagCompound)entry;
            IdentityHashMap pendingIngredientInstances = Maps.newIdentityHashMap();
            NBTTagList pendingIngredientsList = entryTag.func_150295_c("pendingIngredientInstances", 10);
            for (NBTBase pendingIngredient : pendingIngredientsList) {
                NBTTagCompound pendingIngredientTag = (NBTTagCompound)pendingIngredient;
                String componentName = pendingIngredientTag.func_74779_i("ingredientComponent");
                IngredientComponent ingredientComponent = (IngredientComponent)IngredientComponent.REGISTRY.getValue(new ResourceLocation(componentName));
                if (ingredientComponent == null) {
                    throw new IllegalArgumentException("Could not find the ingredient component type " + componentName);
                }
                IIngredientSerializer serializer = ingredientComponent.getSerializer();
                ArrayList pendingIngredients = Lists.newArrayList();
                for (NBTBase instanceTagUnsafe : pendingIngredientTag.func_150295_c("instances", 10)) {
                    NBTTagCompound instanceTag = (NBTTagCompound)instanceTagUnsafe;
                    Object instance = serializer.deserializeInstance(instanceTag.func_74781_a("prototype"));
                    Object condition = serializer.deserializeCondition(instanceTag.func_74781_a("condition"));
                    pendingIngredients.add(new PrototypedIngredient(ingredientComponent, instance, condition));
                }
                pendingIngredientInstances.put(ingredientComponent, pendingIngredients);
            }
            CraftingJob craftingJob = CraftingJob.deserialize(entryTag.func_74775_l("craftingJob"));
            this.processingCraftingJobs.put(craftingJob.getId(), (Object)craftingJob);
            this.allCraftingJobs.put(craftingJob.getId(), (Object)craftingJob);
            this.processingCraftingJobsPendingIngredients.put(craftingJob.getId(), (Object)pendingIngredientInstances);
        }
        NBTTagList pendingCraftingJobs = tag.func_150295_c("pendingCraftingJobs", 10);
        for (NBTBase craftingJob : pendingCraftingJobs) {
            CraftingJob craftingJobInstance = CraftingJob.deserialize((NBTTagCompound)craftingJob);
            this.pendingCraftingJobs.put(craftingJobInstance.getId(), (Object)craftingJobInstance);
            this.allCraftingJobs.put(craftingJobInstance.getId(), (Object)craftingJobInstance);
        }
        for (Map value : this.processingCraftingJobsPendingIngredients.values()) {
            this.observersPendingCreation.addAll(value.keySet());
        }
        this.ingredientComponentTargetOverrides.clear();
        NBTTagCompound targetOverrides = tag.func_74775_l("targetOverrides");
        for (String componentName : targetOverrides.func_150296_c()) {
            IngredientComponent component = (IngredientComponent)IngredientComponent.REGISTRY.getValue(new ResourceLocation(componentName));
            this.ingredientComponentTargetOverrides.put(component, EnumFacing.field_82609_l[targetOverrides.func_74762_e(componentName)]);
        }
    }

    public boolean canScheduleCraftingJobs() {
        return this.pendingCraftingJobs.size() < GeneralConfig.maxPendingCraftingJobs;
    }

    public void scheduleCraftingJob(CraftingJob craftingJob) {
        this.pendingCraftingJobs.put(craftingJob.getId(), (Object)craftingJob);
        this.allCraftingJobs.put(craftingJob.getId(), (Object)craftingJob);
    }

    public Int2ObjectMap<Map<IngredientComponent<?, ?>, List<IPrototypedIngredient<?, ?>>>> getProcessingCraftingJobsPendingIngredients() {
        return this.processingCraftingJobsPendingIngredients;
    }

    public Int2ObjectMap<CraftingJob> getProcessingCraftingJobsRaw() {
        return this.processingCraftingJobs;
    }

    public Collection<CraftingJob> getProcessingCraftingJobs() {
        return this.getProcessingCraftingJobsRaw().values();
    }

    public Collection<CraftingJob> getPendingCraftingJobs() {
        return this.pendingCraftingJobs.values();
    }

    public void markCraftingJobProcessing(CraftingJob craftingJob, Map<IngredientComponent<?, ?>, List<IPrototypedIngredient<?, ?>>> pendingIngredients) {
        if (this.pendingCraftingJobs.remove(craftingJob.getId()) != null) {
            this.setCraftingJobProcessingPendingIngredients(craftingJob, pendingIngredients);
        }
    }

    public void setCraftingJobProcessingPendingIngredients(CraftingJob craftingJob, Map<IngredientComponent<?, ?>, List<IPrototypedIngredient<?, ?>>> pendingIngredients) {
        if (pendingIngredients.isEmpty()) {
            this.processingCraftingJobs.remove(craftingJob.getId());
            this.processingCraftingJobsPendingIngredients.remove(craftingJob.getId());
            this.allCraftingJobs.remove(craftingJob.getId());
        } else {
            this.processingCraftingJobs.put(craftingJob.getId(), (Object)craftingJob);
            this.processingCraftingJobsPendingIngredients.put(craftingJob.getId(), pendingIngredients);
            this.allCraftingJobs.put(craftingJob.getId(), (Object)craftingJob);
        }
    }

    public List<IngredientComponent<?, ?>> getObserversPendingDeletion() {
        return this.observersPendingDeletion;
    }

    protected <T, M> void registerIngredientObserver(IngredientComponent<T, M> ingredientComponent, INetwork network) {
        int count = this.ingredientObserverCounters.getInt(ingredientComponent);
        if (count == 0) {
            IPositionedAddonsNetworkIngredients<T, M> ingredientsNetwork = CraftingHelpers.getIngredientsNetwork(network, ingredientComponent);
            PendingCraftingJobResultIndexObserver<T, M> observer = new PendingCraftingJobResultIndexObserver<T, M>(ingredientComponent, this);
            ingredientsNetwork.addObserver(observer);
            ingredientsNetwork.scheduleObservation();
            this.ingredientObservers.put(ingredientComponent, observer);
        }
        this.ingredientObserverCounters.put(ingredientComponent, count + 1);
    }

    protected <T, M> void unregisterIngredientObserver(IngredientComponent<T, M> ingredientComponent, INetwork network) {
        int count = this.ingredientObserverCounters.getInt(ingredientComponent);
        this.ingredientObserverCounters.put(ingredientComponent, --count);
        if (count == 0) {
            IPositionedAddonsNetworkIngredients<T, M> ingredientsNetwork = CraftingHelpers.getIngredientsNetwork(network, ingredientComponent);
            IIngredientComponentStorageObservable.IIndexChangeObserver<?, ?> observer = this.ingredientObservers.remove(ingredientComponent);
            ingredientsNetwork.removeObserver(observer);
        }
    }

    public void onCraftingJobFinished(CraftingJob craftingJob) {
        this.processingCraftingJobs.remove(craftingJob.getId());
        this.pendingCraftingJobs.remove(craftingJob.getId());
        this.finishedCraftingJobs.put(craftingJob.getId(), (Object)craftingJob);
        this.allCraftingJobs.put(craftingJob.getId(), (Object)craftingJob);
    }

    public void markCraftingJobFinished(int craftingJobId) {
        this.processingCraftingJobsPendingIngredients.remove(craftingJobId);
        this.processingCraftingJobs.remove(craftingJobId);
        this.pendingCraftingJobs.remove(craftingJobId);
        CraftingJob craftingJob = (CraftingJob)this.allCraftingJobs.get(craftingJobId);
        this.finishedCraftingJobs.put(craftingJobId, (Object)craftingJob);
        craftingJob.setAmount(1);
    }

    public void reRegisterObservers(INetwork network) {
        for (Map.Entry<IngredientComponent<?, ?>, IIngredientComponentStorageObservable.IIndexChangeObserver<?, ?>> entry : this.ingredientObservers.entrySet()) {
            IPositionedAddonsNetworkIngredients<?, ?> ingredientsNetwork = CraftingHelpers.getIngredientsNetwork(network, entry.getKey());
            ingredientsNetwork.addObserver(entry.getValue());
        }
    }

    public void update(INetwork network, int channel, PartPos targetPos) {
        int processingJobs;
        if (this.observersPendingCreation.size() > 0) {
            for (IngredientComponent<?, ?> ingredientComponent : this.observersPendingCreation) {
                this.registerIngredientObserver(ingredientComponent, network);
            }
            this.observersPendingCreation.clear();
        }
        if (this.observersPendingDeletion.size() > 0) {
            for (IngredientComponent<?, ?> ingredientComponent : this.observersPendingDeletion) {
                this.unregisterIngredientObserver(ingredientComponent, network);
            }
            this.observersPendingDeletion.clear();
        }
        if (this.finishedCraftingJobs.size() > 0) {
            for (Object finishedCraftingJob : this.finishedCraftingJobs.values()) {
                if (((CraftingJob)finishedCraftingJob).getAmount() == 1) {
                    ICraftingNetwork iCraftingNetwork = CraftingHelpers.getCraftingNetwork(network);
                    iCraftingNetwork.onCraftingJobFinished((CraftingJob)finishedCraftingJob);
                    this.allCraftingJobs.remove(((CraftingJob)finishedCraftingJob).getId());
                    continue;
                }
                ((CraftingJob)finishedCraftingJob).setAmount(((CraftingJob)finishedCraftingJob).getAmount() - 1);
                this.pendingCraftingJobs.put(((CraftingJob)finishedCraftingJob).getId(), finishedCraftingJob);
            }
            this.finishedCraftingJobs.clear();
        }
        if ((processingJobs = this.getProcessingCraftingJobs().size()) > 0) {
            for (IngredientComponent ingredientComponent : this.ingredientObservers.keySet()) {
                IPositionedAddonsNetworkIngredients ingredientsNetwork = CraftingHelpers.getIngredientsNetwork(network, ingredientComponent);
                ingredientsNetwork.scheduleObservation();
            }
        }
        if (processingJobs < this.maxProcessingJobs) {
            CraftingJob startingCraftingJob = null;
            ICraftingNetwork iCraftingNetwork = CraftingHelpers.getCraftingNetwork(network);
            CraftingJobDependencyGraph dependencyGraph = iCraftingNetwork.getCraftingJobDependencyGraph();
            for (CraftingJob craftingJob : this.getPendingCraftingJobs()) {
                if (dependencyGraph.hasDependencies(craftingJob)) continue;
                Pair<Map<IngredientComponent<?, ?>, List<?>>, Map<IngredientComponent<?, ?>, MissingIngredients<?, ?>>> inputs = CraftingHelpers.getRecipeInputs(CraftingHelpers.getNetworkStorageGetter(network, craftingJob.getChannel(), false), craftingJob.getRecipe(), true, Maps.newIdentityHashMap(), true, 1L);
                if (((Map)inputs.getRight()).isEmpty()) {
                    if (this.insertCrafting(targetPos, (IMixedIngredients)new MixedIngredients((Map)inputs.getLeft()), network, channel, true)) {
                        startingCraftingJob = craftingJob;
                        startingCraftingJob.setInvalidInputs(false);
                        break;
                    }
                    craftingJob.setInvalidInputs(true);
                    continue;
                }
                if (craftingJob.getLastMissingIngredients().isEmpty()) {
                    for (IngredientComponent component : ((Map)inputs.getRight()).keySet()) {
                        this.registerIngredientObserver(component, network);
                    }
                }
                craftingJob.setLastMissingIngredients((Map)inputs.getRight());
            }
            if (startingCraftingJob != null) {
                IMixedIngredients ingredients;
                if (!startingCraftingJob.getLastMissingIngredients().isEmpty()) {
                    for (IngredientComponent ingredientComponent : startingCraftingJob.getLastMissingIngredients().keySet()) {
                        this.unregisterIngredientObserver(ingredientComponent, network);
                    }
                    startingCraftingJob.setLastMissingIngredients(Maps.newIdentityHashMap());
                }
                if ((ingredients = CraftingHelpers.getRecipeInputs(network, startingCraftingJob.getChannel(), startingCraftingJob.getRecipe(), false, 1L)) != null) {
                    this.markCraftingJobProcessing(startingCraftingJob, CraftingHelpers.getRecipeOutputs(startingCraftingJob.getRecipe()));
                    if (this.insertCrafting(targetPos, ingredients, network, channel, false)) {
                        for (IngredientComponent component : startingCraftingJob.getRecipe().getOutput().getComponents()) {
                            this.registerIngredientObserver(component, network);
                        }
                    } else {
                        this.onCraftingJobFinished(startingCraftingJob);
                    }
                } else {
                    IntegratedCrafting.clog(Level.WARN, "Failed to extract ingredients for crafting job " + startingCraftingJob.getId());
                }
            }
        }
    }

    protected boolean insertCrafting(PartPos target, IMixedIngredients ingredients, INetwork network, int channel, boolean simulate) {
        Function<IngredientComponent<?, ?>, PartPos> targetGetter = this.getTargetGetter(target);
        for (ICraftingProcessOverride craftingProcessOverride : this.craftingProcessOverrides) {
            if (!craftingProcessOverride.isApplicable(target)) continue;
            return craftingProcessOverride.craft(targetGetter, ingredients, this.resultsSink, simulate);
        }
        return CraftingHelpers.insertCrafting(targetGetter, ingredients, network, channel, simulate);
    }

    public CraftingJobStatus getCraftingJobStatus(ICraftingNetwork network, int channel, int craftingJobId) {
        if (this.pendingCraftingJobs.containsKey(craftingJobId)) {
            CraftingJob craftingJob = (CraftingJob)this.allCraftingJobs.get(craftingJobId);
            if (craftingJob != null && craftingJob.isInvalidInputs()) {
                return CraftingJobStatus.INVALID_INPUTS;
            }
            CraftingJobDependencyGraph dependencyGraph = network.getCraftingJobDependencyGraph();
            if (dependencyGraph.hasDependencies(craftingJobId)) {
                return CraftingJobStatus.PENDING_DEPENDENCIES;
            }
            if (!craftingJob.getLastMissingIngredients().isEmpty()) {
                return CraftingJobStatus.PENDING_INGREDIENTS;
            }
            return CraftingJobStatus.PENDING_INTERFACE;
        }
        if (this.processingCraftingJobs.containsKey(craftingJobId)) {
            return CraftingJobStatus.PROCESSING;
        }
        if (this.finishedCraftingJobs.containsKey(craftingJobId)) {
            return CraftingJobStatus.FINISHED;
        }
        return CraftingJobStatus.UNKNOWN;
    }

    public Int2ObjectMap<CraftingJob> getAllCraftingJobs() {
        return this.allCraftingJobs;
    }

    public void setIngredientComponentTarget(IngredientComponent<?, ?> ingredientComponent, @Nullable EnumFacing side) {
        if (side == null) {
            this.ingredientComponentTargetOverrides.remove(ingredientComponent);
        } else {
            this.ingredientComponentTargetOverrides.put(ingredientComponent, side);
        }
    }

    @Nullable
    public EnumFacing getIngredientComponentTarget(IngredientComponent<?, ?> ingredientComponent) {
        return this.ingredientComponentTargetOverrides.get(ingredientComponent);
    }

    public Function<IngredientComponent<?, ?>, PartPos> getTargetGetter(PartPos defaultPosition) {
        return ingredientComponent -> {
            EnumFacing sideOverride = this.ingredientComponentTargetOverrides.get(ingredientComponent);
            if (sideOverride == null) {
                return defaultPosition;
            }
            return PartPos.of((DimPos)defaultPosition.getPos(), (EnumFacing)sideOverride);
        };
    }
}

