/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedcrafting;

import org.cyclops.cyclopscore.config.ConfigurableProperty;
import org.cyclops.cyclopscore.config.ConfigurableType;
import org.cyclops.cyclopscore.config.ConfigurableTypeCategory;
import org.cyclops.cyclopscore.config.extendedconfig.DummyConfig;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.tracking.Analytics;
import org.cyclops.cyclopscore.tracking.IModVersion;
import org.cyclops.cyclopscore.tracking.Versions;
import org.cyclops.integratedcrafting.IntegratedCrafting;

public class GeneralConfig
extends DummyConfig {
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="Config version for Integrated Crafting.\nDO NOT EDIT MANUALLY!")
    public static String version = "1.0.8";
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="Set 'true' to enable development debug mode. This will result in a lower performance!", requiresMcRestart=true)
    public static boolean debug = false;
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="If the recipe loader should crash when finding invalid recipes.", requiresMcRestart=true)
    public static boolean crashOnInvalidRecipe = false;
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="If mod compatibility loader should crash hard if errors occur in that process.", requiresMcRestart=true)
    public static boolean crashOnModCompatCrash = false;
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="If an anonymous mod startup analytics request may be sent to our analytics service.")
    public static boolean analytics = true;
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="If the version checker should be enabled.")
    public static boolean versionChecker = true;
    @ConfigurableProperty(category=ConfigurableTypeCategory.MACHINE, comment="The minimal update frequency in ticks to use for crafting interfaces.", minimalValue=1)
    public static int minCraftingInterfaceUpdateFreq = 5;
    @ConfigurableProperty(category=ConfigurableTypeCategory.MACHINE, comment="If the crafting interface should validate recipes on insertion.", isCommandable=true)
    public static boolean validateRecipesCraftingInterface = true;
    @ConfigurableProperty(category=ConfigurableTypeCategory.MACHINE, comment="The maximum amount of crafting jobs that could be scheduled within one crafting interface without being started", minimalValue=1, isCommandable=true)
    public static int maxPendingCraftingJobs = 256;
    public static ConfigurableType TYPE = ConfigurableType.DUMMY;

    public GeneralConfig() {
        super((ModBase)IntegratedCrafting._instance, true, "general", null, GeneralConfig.class);
    }

    public void onRegistered() {
        this.getMod().putGenericReference(ModBase.REFKEY_CRASH_ON_INVALID_RECIPE, (Object)crashOnInvalidRecipe);
        this.getMod().putGenericReference(ModBase.REFKEY_DEBUGCONFIG, (Object)debug);
        this.getMod().putGenericReference(ModBase.REFKEY_CRASH_ON_MODCOMPAT_CRASH, (Object)crashOnModCompatCrash);
        if (analytics) {
            Analytics.registerMod((ModBase)this.getMod(), (String)"UA-65307010-15");
        }
        if (versionChecker) {
            Versions.registerMod((ModBase)this.getMod(), (IModVersion)IntegratedCrafting._instance, (String)"https://raw.githubusercontent.com/CyclopsMC/Versions/master/1.12/IntegratedCrafting.txt");
        }
    }

    public boolean isEnabled() {
        return true;
    }
}

