/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.TreeBlockTypeLeaf;
import forestry.arboriculture.worldgen.TreeBlockTypeLog;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.worldgen.WorldGenHelper;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldGenSequoia
extends WorldGenTree {
    public WorldGenSequoia(ITreeGenData tree) {
        this(tree, 20, 5);
    }

    protected WorldGenSequoia(ITreeGenData tree, int baseHeight, int heightVariation) {
        super(tree, baseHeight, heightVariation);
    }

    @Override
    public Set<BlockPos> generateTrunk(World world, Random rand, TreeBlockTypeLog wood, BlockPos startPos) {
        WorldGenHelper.generateTreeTrunk(world, rand, wood, startPos, this.height, this.girth, 0, 0.0f, null, 0.0f);
        WorldGenHelper.generateSupportStems(wood, world, rand, startPos, this.height, this.girth, 0.4f, 0.4f);
        int topHeight = this.height / 3 + rand.nextInt(this.height / 6);
        HashSet<BlockPos> branchCoords = new HashSet<BlockPos>();
        for (int yBranch = topHeight; yBranch < this.height; ++yBranch) {
            int branchLength = Math.round(this.height - yBranch) / 2;
            if (branchLength > 4) {
                branchLength = 4;
            }
            branchCoords.addAll(WorldGenHelper.generateBranches(world, rand, wood, startPos.func_177982_a(0, yBranch, 0), this.girth, 0.05f, 0.25f, branchLength, 1, 0.5f));
        }
        return branchCoords;
    }

    @Override
    protected void generateLeaves(World world, Random rand, TreeBlockTypeLeaf leaf, List<BlockPos> branchEnds, BlockPos startPos) {
        for (BlockPos branchEnd : branchEnds) {
            WorldGenHelper.generateCylinderFromPos(world, leaf, branchEnd, 1.0f + (float)this.girth, 1, WorldGenHelper.EnumReplaceMode.AIR);
        }
        int leafSpawn = this.height + 2;
        WorldGenHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, this.girth, 1, WorldGenHelper.EnumReplaceMode.SOFT);
        WorldGenHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, 1 + this.girth, 1, WorldGenHelper.EnumReplaceMode.SOFT);
        WorldGenHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, 1 + this.girth, 1, WorldGenHelper.EnumReplaceMode.SOFT);
        int topHeight = this.height / 3 + rand.nextInt(this.height / 6);
        while (leafSpawn > topHeight) {
            WorldGenHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, 1 + this.girth, 1, WorldGenHelper.EnumReplaceMode.SOFT);
        }
        WorldGenHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn, 0), this.girth, this.girth, 1, WorldGenHelper.EnumReplaceMode.SOFT);
    }
}

