/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.worldprimer.util;

import fi.dy.masa.worldprimer.WorldPrimer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class WorldUtils {
    private static final Map<Integer, Set<ChunkPos>> LOADED_CHUNKS = new HashMap<Integer, Set<ChunkPos>>();

    public static BlockPos getWorldSpawn(World world) {
        BlockPos spawn = null;
        if (world instanceof WorldServer) {
            spawn = ((WorldServer)world).func_180504_m();
        }
        if (spawn == null) {
            spawn = world.func_175694_M();
        }
        return spawn;
    }

    @Nullable
    public static BlockPos getPlayerBedSpawnLocation(EntityPlayer player) {
        int dimension = player.field_71093_bK;
        BlockPos bedPos = player.getBedLocation(dimension);
        if (bedPos != null) {
            return EntityPlayer.func_180467_a((World)player.func_130014_f_(), (BlockPos)bedPos, (boolean)player.isSpawnForced(dimension));
        }
        return null;
    }

    public static boolean executeChunkLoadingCommand(String command, @Nullable World world) {
        if (world == null) {
            WorldPrimer.logger.warn("Failed to run the chunk loading command '{}', because the world wasn't loaded", (Object)command);
            return false;
        }
        String[] parts = command.split("\\s+");
        if (parts.length == 5 && (parts[0].equals("worldprimer-load-chunks") || parts[0].equals("worldprimer-load-blocks"))) {
            try {
                int x1 = Integer.parseInt(parts[1]);
                int z1 = Integer.parseInt(parts[2]);
                int x2 = Integer.parseInt(parts[3]);
                int z2 = Integer.parseInt(parts[4]);
                if (parts[0].equals("worldprimer-load-blocks")) {
                    WorldUtils.loadChunks(world, x1 >> 4, z1 >> 4, x2 >> 4, z2 >> 4);
                } else {
                    WorldUtils.loadChunks(world, x1, z1, x2, z2);
                }
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        WorldPrimer.logger.warn("Invalid chunk loading command '{}'", (Object)command);
        return false;
    }

    public static void loadBlocks(@Nonnull World world, int blockX1, int blockZ1, int blockX2, int blockZ2) {
        WorldUtils.loadChunks(world, blockX1 >> 4, blockZ1 >> 4, blockX2 >> 4, blockZ2 >> 4);
    }

    public static void loadChunks(@Nonnull World world, int chunkX1, int chunkZ1, int chunkX2, int chunkZ2) {
        int xStart = Math.min(chunkX1, chunkX2);
        int zStart = Math.min(chunkZ1, chunkZ2);
        int xEnd = Math.max(chunkX1, chunkX2);
        int zEnd = Math.max(chunkZ1, chunkZ2);
        int dimension = world.field_73011_w.getDimension();
        Set<ChunkPos> loadedChunks = LOADED_CHUNKS.get(world.field_73011_w.getDimension());
        if (loadedChunks == null) {
            loadedChunks = new HashSet<ChunkPos>();
            LOADED_CHUNKS.put(world.field_73011_w.getDimension(), loadedChunks);
        }
        WorldPrimer.logInfo("Attempting to load chunks [{},{}] to [{},{}] in dimension {}", xStart, zStart, xEnd, zEnd, dimension);
        for (int x = xStart; x <= xEnd; ++x) {
            for (int z = zStart; z <= zEnd; ++z) {
                if (world.func_175667_e(new BlockPos(x << 4, 0, z << 4))) continue;
                WorldPrimer.logInfo("Loading chunk [{},{}] in dimension {}", x, z, dimension);
                loadedChunks.add(new ChunkPos(x, z));
                world.func_72964_e(x, z);
            }
        }
    }

    public static void unloadLoadedChunks(@Nullable World world) {
        if (world instanceof WorldServer) {
            WorldServer worldServer = (WorldServer)world;
            Set<ChunkPos> loadedChunks = LOADED_CHUNKS.get(world.field_73011_w.getDimension());
            if (loadedChunks != null) {
                for (ChunkPos pos : loadedChunks) {
                    if (worldServer.func_184164_w().func_152621_a(pos.field_77276_a, pos.field_77275_b) || !worldServer.func_175667_e(new BlockPos(pos.field_77276_a << 4, 0, pos.field_77275_b << 4))) continue;
                    WorldPrimer.logInfo("Queueing chunk [{},{}] for unloading in dimension {}", pos.field_77276_a, pos.field_77275_b, world.field_73011_w.getDimension());
                    worldServer.func_72863_F().func_189549_a(worldServer.func_72964_e(pos.field_77276_a, pos.field_77275_b));
                }
                LOADED_CHUNKS.remove(world.field_73011_w.getDimension());
            }
        }
    }
}

