/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.worldprimer.util;

import fi.dy.masa.worldprimer.WorldPrimer;
import fi.dy.masa.worldprimer.config.Configs;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class DataTracker {
    private static final DataTracker INSTANCE = new DataTracker();
    private final Map<Integer, Integer> dimensionLoadCounts = new HashMap<Integer, Integer>();
    private final Map<UUID, PlayerData> playerData = new HashMap<UUID, PlayerData>();
    private final Map<Integer, Map<UUID, BlockPos>> playerSpreadPositions = new HashMap<Integer, Map<UUID, BlockPos>>();
    private File worldDir = new File(".");
    private int serverStarts;
    private boolean dirty;

    public static DataTracker instance() {
        return INSTANCE;
    }

    public void serverStarted() {
        ++this.serverStarts;
        this.dirty = true;
    }

    public void dimensionLoaded(int dimension) {
        Integer count = this.dimensionLoadCounts.get(dimension);
        count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
        this.dimensionLoadCounts.put(dimension, count);
        this.dirty = true;
    }

    public int getDimensionLoadCount(int dimension) {
        Integer count = this.dimensionLoadCounts.get(dimension);
        return count != null ? count : 0;
    }

    public void resetDimensionLoadCountFor(int dimension) {
        this.dimensionLoadCounts.remove(dimension);
        for (PlayerData data : this.playerData.values()) {
            data.resetDimensionEventCountsFor(dimension);
        }
        this.dirty = true;
    }

    public int getServerStartCount() {
        return this.serverStarts;
    }

    public int getPlayerDataCount(EntityPlayer player, PlayerDataType type) {
        return this.getOrCreatePlayerData(player).getCount(type);
    }

    public int getPlayerDimensionEventCount(EntityPlayer player, int dimension, PlayerDimensionDataType type) {
        return this.getOrCreatePlayerData(player).getDimensionEventCount(dimension, type);
    }

    public void incrementPlayerDataCount(EntityPlayer player, PlayerDataType type) {
        this.getOrCreatePlayerData(player).incrementCount(type);
        this.dirty = true;
    }

    public void incrementPlayerDimensionEventCount(EntityPlayer player, int dimension, PlayerDimensionDataType type) {
        this.getOrCreatePlayerData(player).incrementDimensionEventCount(dimension, type);
        this.dirty = true;
    }

    public Collection<BlockPos> getPlayerSpreadPositions(int dimension) {
        Map<UUID, BlockPos> map = this.playerSpreadPositions.get(dimension);
        return map != null ? map.values() : Collections.emptyList();
    }

    @Nullable
    public BlockPos getLastPlayerSpreadPosition(EntityPlayer player) {
        int dimension = player.func_130014_f_().field_73011_w.getDimension();
        Map<UUID, BlockPos> map = this.playerSpreadPositions.get(dimension);
        return map != null ? map.get(player.func_110124_au()) : null;
    }

    public void addPlayerSpreadPosition(EntityPlayer player, BlockPos pos) {
        int dimension = player.func_130014_f_().field_73011_w.getDimension();
        this.addPlayerSpreadPosition(dimension, player.func_110124_au(), pos);
    }

    public void addPlayerSpreadPosition(int dimension, UUID uuid, BlockPos pos) {
        Map<UUID, BlockPos> map = this.playerSpreadPositions.get(dimension);
        if (map == null) {
            map = new HashMap<UUID, BlockPos>();
            this.playerSpreadPositions.put(dimension, map);
        }
        map.put(uuid, pos);
        this.dirty = true;
    }

    private PlayerData getOrCreatePlayerData(EntityPlayer player) {
        PlayerData data = this.playerData.get(player.func_110124_au());
        if (data == null) {
            data = new PlayerData();
            this.playerData.put(player.func_110124_au(), data);
            this.dirty = true;
        }
        return data;
    }

    private void readFromNBT(NBTTagCompound nbt) {
        NBTTagCompound tag;
        int i;
        if (nbt == null) {
            return;
        }
        NBTTagList tagList = nbt.func_150295_c("DimLoadCounts", 10);
        int tagCount = tagList.func_74745_c();
        for (i = 0; i < tagCount; ++i) {
            tag = tagList.func_150305_b(i);
            this.dimensionLoadCounts.put(tag.func_74762_e("Dim"), tag.func_74762_e("Count"));
        }
        tagList = nbt.func_150295_c("PlayerData", 10);
        tagCount = tagList.func_74745_c();
        for (i = 0; i < tagCount; ++i) {
            tag = tagList.func_150305_b(i);
            UUID uuid = new UUID(tag.func_74763_f("UUIDM"), tag.func_74763_f("UUIDL"));
            PlayerData data = new PlayerData();
            data.readFromNBT(tag);
            this.playerData.put(uuid, data);
        }
        tagList = nbt.func_150295_c("PlayerSpreadPositions", 10);
        tagCount = tagList.func_74745_c();
        for (i = 0; i < tagCount; ++i) {
            tag = tagList.func_150305_b(i);
            BlockPos pos = DataTracker.readBlockPos(tag);
            if (pos == null) continue;
            UUID uuid = new UUID(tag.func_74763_f("UUIDM"), tag.func_74763_f("UUIDL"));
            int dimension = tag.func_74762_e("dim");
            this.addPlayerSpreadPosition(dimension, uuid, pos);
        }
        this.serverStarts = nbt.func_74762_e("ServerStarts");
    }

    private NBTTagCompound writeToNBT(@Nonnull NBTTagCompound nbt) {
        NBTTagCompound tag;
        NBTTagList tagList = new NBTTagList();
        nbt.func_74782_a("DimLoadCounts", (NBTBase)tagList);
        for (Map.Entry<Integer, Integer> entry : this.dimensionLoadCounts.entrySet()) {
            tag = new NBTTagCompound();
            tag.func_74768_a("Dim", entry.getKey().intValue());
            tag.func_74768_a("Count", entry.getValue().intValue());
            tagList.func_74742_a((NBTBase)tag);
        }
        tagList = new NBTTagList();
        nbt.func_74782_a("PlayerData", (NBTBase)tagList);
        for (Map.Entry<Comparable<Integer>, Object> entry : this.playerData.entrySet()) {
            tag = new NBTTagCompound();
            tag.func_74772_a("UUIDM", ((UUID)entry.getKey()).getMostSignificantBits());
            tag.func_74772_a("UUIDL", ((UUID)entry.getKey()).getLeastSignificantBits());
            ((PlayerData)entry.getValue()).writeToNBT(tag);
            tagList.func_74742_a((NBTBase)tag);
        }
        tagList = new NBTTagList();
        nbt.func_74782_a("PlayerSpreadPositions", (NBTBase)tagList);
        for (Map.Entry<Comparable<Integer>, Object> entry : this.playerSpreadPositions.entrySet()) {
            Map map = (Map)entry.getValue();
            int dimension = (Integer)entry.getKey();
            for (Map.Entry posEntry : map.entrySet()) {
                NBTTagCompound tag2 = new NBTTagCompound();
                tag2.func_74772_a("UUIDM", ((UUID)posEntry.getKey()).getMostSignificantBits());
                tag2.func_74772_a("UUIDL", ((UUID)posEntry.getKey()).getLeastSignificantBits());
                tag2.func_74768_a("dim", dimension);
                DataTracker.writeBlockPosToTag((Vec3i)posEntry.getValue(), tag2);
                tagList.func_74742_a((NBTBase)tag2);
            }
        }
        nbt.func_74768_a("ServerStarts", this.serverStarts);
        return nbt;
    }

    @Nullable
    private File getDataDir(boolean createDirs) {
        File saveDir = this.worldDir;
        if (saveDir != null) {
            if (!((saveDir = new File(saveDir, "worldprimer")).exists() || createDirs && saveDir.mkdirs())) {
                if (createDirs) {
                    WorldPrimer.logger.warn("Failed to create a directory for storing the data tracker file '{}'", (Object)saveDir.getPath());
                }
                return null;
            }
            return saveDir;
        }
        return null;
    }

    public void readFromDisk(File worldDir) {
        if (!Configs.enableDataTracking) {
            return;
        }
        this.dimensionLoadCounts.clear();
        this.playerData.clear();
        this.playerSpreadPositions.clear();
        this.serverStarts = 0;
        this.worldDir = worldDir;
        File file = new File(new File(worldDir, "worldprimer"), "data_tracker.nbt");
        if (!file.exists() || !file.isFile()) {
            file = new File(new File(worldDir, "worldprimer"), "dim_loads.nbt");
        }
        try {
            if (file.exists() && file.isFile() && file.canRead()) {
                FileInputStream is = new FileInputStream(file);
                this.readFromNBT(CompressedStreamTools.func_74796_a((InputStream)is));
                is.close();
            }
        }
        catch (Exception e) {
            WorldPrimer.logger.warn("Failed to read tracker data from file '{}'", (Object)file.getPath());
        }
    }

    public void writeToDisk() {
        if (!this.dirty || !Configs.enableDataTracking) {
            return;
        }
        try {
            File saveDir = this.getDataDir(true);
            if (saveDir != null) {
                File fileTmp = new File(saveDir, "data_tracker.nbt.tmp");
                File fileReal = new File(saveDir, "data_tracker.nbt");
                FileOutputStream os = new FileOutputStream(fileTmp);
                CompressedStreamTools.func_74799_a((NBTTagCompound)this.writeToNBT(new NBTTagCompound()), (OutputStream)os);
                os.close();
                if (fileReal.exists()) {
                    fileReal.delete();
                }
                fileTmp.renameTo(fileReal);
                this.dirty = false;
            }
        }
        catch (Exception e) {
            WorldPrimer.logger.warn("Failed to write tracker data to file");
        }
    }

    public static NBTTagCompound writeBlockPosToTag(Vec3i pos, NBTTagCompound tag) {
        tag.func_74768_a("x", pos.func_177958_n());
        tag.func_74768_a("y", pos.func_177956_o());
        tag.func_74768_a("z", pos.func_177952_p());
        return tag;
    }

    @Nullable
    public static BlockPos readBlockPos(@Nullable NBTTagCompound tag) {
        if (tag != null && tag.func_150297_b("x", 3) && tag.func_150297_b("y", 3) && tag.func_150297_b("z", 3)) {
            return new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"));
        }
        return null;
    }

    public static enum PlayerDimensionDataType {
        ENTER,
        LEAVE;

    }

    public static enum PlayerDataType {
        JOIN,
        QUIT,
        DEATH,
        RESPAWN,
        ENTER_DIM;

    }

    private static class PlayerData {
        private int joinCount;
        private int quitCount;
        private int deathCount;
        private int respawnCount;
        private final Map<Integer, Integer> dimensionEnterCounts = new HashMap<Integer, Integer>();
        private final Map<Integer, Integer> dimensionLeaveCounts = new HashMap<Integer, Integer>();

        private PlayerData() {
        }

        public int getCount(PlayerDataType type) {
            switch (type) {
                case JOIN: {
                    return this.joinCount;
                }
                case QUIT: {
                    return this.quitCount;
                }
                case DEATH: {
                    return this.deathCount;
                }
                case RESPAWN: {
                    return this.respawnCount;
                }
            }
            return 0;
        }

        public void incrementCount(PlayerDataType type) {
            switch (type) {
                case JOIN: {
                    ++this.joinCount;
                    break;
                }
                case QUIT: {
                    ++this.quitCount;
                    break;
                }
                case DEATH: {
                    ++this.deathCount;
                    break;
                }
                case RESPAWN: {
                    ++this.respawnCount;
                    break;
                }
            }
        }

        public int getDimensionEventCount(int dimension, PlayerDimensionDataType type) {
            Map<Integer, Integer> map = type == PlayerDimensionDataType.ENTER ? this.dimensionEnterCounts : this.dimensionLeaveCounts;
            Integer count = map.get(dimension);
            return count != null ? count : 0;
        }

        public void incrementDimensionEventCount(int dimension, PlayerDimensionDataType type) {
            Map<Integer, Integer> map = type == PlayerDimensionDataType.ENTER ? this.dimensionEnterCounts : this.dimensionLeaveCounts;
            Integer countOld = map.get(dimension);
            int countNew = countOld != null ? countOld + 1 : 1;
            map.put(dimension, countNew);
        }

        public void resetDimensionEventCountsFor(int dimension) {
            this.resetDimensionEventCountFor(dimension, PlayerDimensionDataType.ENTER);
            this.resetDimensionEventCountFor(dimension, PlayerDimensionDataType.LEAVE);
        }

        public void resetDimensionEventCountFor(int dimension, PlayerDimensionDataType type) {
            Map<Integer, Integer> map = type == PlayerDimensionDataType.ENTER ? this.dimensionEnterCounts : this.dimensionLeaveCounts;
            map.remove(dimension);
        }

        public void readFromNBT(NBTTagCompound nbt) {
            this.joinCount = nbt.func_74762_e("JoinCount");
            this.quitCount = nbt.func_74762_e("QuitCount");
            this.deathCount = nbt.func_74762_e("DeathCount");
            this.respawnCount = nbt.func_74762_e("RespawnCount");
            this.readDimensionEventData(nbt, "DimEnter", this.dimensionEnterCounts);
            this.readDimensionEventData(nbt, "DimLeave", this.dimensionLeaveCounts);
        }

        private void readDimensionEventData(NBTTagCompound nbt, String key, Map<Integer, Integer> map) {
            map.clear();
            if (nbt.func_150297_b(key, 9)) {
                NBTTagList tagList = nbt.func_150295_c(key, 10);
                int tagCount = tagList.func_74745_c();
                for (int i = 0; i < tagCount; ++i) {
                    NBTTagCompound tag = tagList.func_150305_b(i);
                    map.put(tag.func_74762_e("Dim"), tag.func_74762_e("Count"));
                }
            }
        }

        public NBTTagCompound writeToNBT(@Nonnull NBTTagCompound nbt) {
            nbt.func_74768_a("JoinCount", this.joinCount);
            nbt.func_74768_a("QuitCount", this.quitCount);
            nbt.func_74768_a("DeathCount", this.deathCount);
            nbt.func_74768_a("RespawnCount", this.respawnCount);
            this.writeDimensionEventData(nbt, "DimEnter", this.dimensionEnterCounts);
            this.writeDimensionEventData(nbt, "DimLeave", this.dimensionLeaveCounts);
            return nbt;
        }

        private void writeDimensionEventData(NBTTagCompound nbt, String key, Map<Integer, Integer> map) {
            NBTTagList tagList = new NBTTagList();
            for (Map.Entry<Integer, Integer> entry : map.entrySet()) {
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74768_a("Dim", entry.getKey().intValue());
                tag.func_74768_a("Count", entry.getValue().intValue());
                tagList.func_74742_a((NBTBase)tag);
            }
            nbt.func_74782_a(key, (NBTBase)tagList);
        }
    }
}

