/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.base.patreon.base;

import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.client.util.TextureHelper;
import hellfirepvp.astralsorcery.common.base.patreon.PatreonEffectHelper;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PtEffectBlockRing
extends PatreonEffectHelper.PatreonEffect {
    private final UUID playerUUID;
    private final float distance;
    private final float rotationAngle;
    private final int repetition;
    private final int rotationSpeed;
    private final float rotationPart;
    private final Map<BlockPos, IBlockState> pattern;

    public PtEffectBlockRing(UUID sessionEffectId, PatreonEffectHelper.FlareColor chosenColor, UUID playerUUID, float distance, float rotationAngle, int repeats, int tickRotationSpeed, Map<BlockPos, IBlockState> pattern) {
        super(sessionEffectId, chosenColor);
        this.playerUUID = playerUUID;
        this.distance = distance;
        this.rotationAngle = rotationAngle;
        this.repetition = repeats;
        this.rotationSpeed = tickRotationSpeed;
        this.rotationPart = 360.0f / (float)this.rotationSpeed;
        this.pattern = pattern;
    }

    @Override
    public void initialize() {
        super.initialize();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onRenderLast(RenderWorldLastEvent event) {
        EntityPlayerSP pl = Minecraft.func_71410_x().field_71439_g;
        if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 0 && pl != null && pl.func_110124_au().equals(this.playerUUID)) {
            float alpha = 1.0f;
            if (pl.field_70125_A >= 35.0f) {
                alpha = Math.max(0.0f, (55.0f - pl.field_70125_A) / 20.0f);
            }
            this.renderRingAt(new Vector3(0.0, 0.2, 0.0), alpha, event.getPartialTicks());
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onRenderPost(RenderPlayerEvent.Post ev) {
        EntityPlayer player = ev.getEntityPlayer();
        if (!player.func_110124_au().equals(this.playerUUID)) {
            return;
        }
        this.renderRingAt(new Vector3(ev.getX(), ev.getY(), ev.getZ()), 1.0f, ev.getPartialRenderTick());
    }

    @SideOnly(value=Side.CLIENT)
    private void renderRingAt(Vector3 vec, float alphaMultiplier, float pTicks) {
        float addedRotationAngle = 0.0f;
        TextureHelper.setActiveTextureToAtlasSprite();
        if (this.rotationSpeed > 1) {
            float rot = ClientScheduler.getIndependentClientTick() % (long)this.rotationSpeed;
            addedRotationAngle = rot / (float)this.rotationSpeed * 360.0f + this.rotationPart * pTicks;
        }
        GlStateManager.func_179118_c();
        GlStateManager.func_179129_p();
        GlStateManager.func_179147_l();
        Blending.ADDITIVE_ALPHA.applyStateManager();
        for (int rotation = 0; rotation < 360; rotation += 360 / this.repetition) {
            for (BlockPos offset : this.pattern.keySet()) {
                IBlockState state = this.pattern.get(offset);
                TextureAtlasSprite tas = RenderingUtils.tryGetTextureOfBlockState(state);
                if (tas == null) continue;
                float angle = (float)offset.func_177952_p() * this.rotationAngle + (float)rotation + addedRotationAngle;
                Vector3 dir = new Vector3((float)offset.func_177958_n() - this.distance, (float)offset.func_177956_o(), 0.0f);
                dir.rotate(Math.toRadians(angle), Vector3.RotAxis.Y_AXIS);
                dir.multiply(new Vector3(0.2f, 0.1f, 0.2f));
                dir.add(vec);
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)dir.getX(), (double)dir.getY(), (double)dir.getZ());
                GlStateManager.func_179139_a((double)0.09, (double)0.09, (double)0.09);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alphaMultiplier);
                RenderingUtils.renderTexturedCubeCentral(new Vector3(), 1.0, tas.func_94209_e(), tas.func_94206_g(), tas.func_94212_f() - tas.func_94209_e(), tas.func_94210_h() - tas.func_94206_g());
                GlStateManager.func_179121_F();
            }
        }
        Blending.DEFAULT.applyStateManager();
        GlStateManager.func_179089_o();
        GlStateManager.func_179141_d();
    }
}

