/*
 * Decompiled with CFR 0.152.
 */
package vazkii.chatflow;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import vazkii.chatflow.handler.KeyHandler;
import vazkii.chatflow.handler.MessageMeddler;
import vazkii.chatflow.handler.ToastHandler;
import vazkii.chatflow.helper.NBTHelper;
import vazkii.chatflow.helper.Replacement;

@Mod(modid="chatflow", name="ChatFlow", version="ANT:VERSION", clientSideOnly=true, acceptedMinecraftVersions="[1.12]")
public class ChatFlow {
    public static List<Replacement> replacements = new ArrayList<Replacement>();
    static File saveFileLegacy;
    static File saveFile;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new MessageMeddler());
        FMLCommonHandler.instance().bus().register((Object)new KeyHandler());
        ToastHandler h = new ToastHandler();
        MinecraftForge.EVENT_BUS.register((Object)h);
        FMLCommonHandler.instance().bus().register((Object)h);
        saveFileLegacy = event.getSuggestedConfigurationFile();
        saveFile = new File(saveFileLegacy.getParentFile(), "ChatFlow.dat");
        ChatFlow.loadReplacements();
    }

    public static void saveReplacements() {
        try {
            if (!saveFile.exists()) {
                saveFile.createNewFile();
            }
            NBTTagCompound cmp = new NBTTagCompound();
            int count = replacements.size();
            cmp.func_74768_a("count", count);
            for (int i = 0; i < replacements.size(); ++i) {
                NBTTagCompound cmp_ = new NBTTagCompound();
                replacements.get(i).write(cmp_);
                cmp.func_74782_a("repl" + i, (NBTBase)cmp_);
            }
            NBTHelper.injectNBTToFile(cmp, saveFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void loadReplacements() {
        if (saveFileLegacy.exists()) {
            ChatFlow.loadReplacementsLegacy();
        } else {
            replacements.clear();
            NBTTagCompound cmp = NBTHelper.getCacheCompound(saveFile);
            int count = cmp.func_74762_e("count");
            for (int i = 0; i < count; ++i) {
                NBTTagCompound cmp_ = cmp.func_74775_l("repl" + i);
                Replacement r = Replacement.read(cmp_);
                replacements.add(r);
            }
        }
    }

    public static void loadReplacementsLegacy() {
        try {
            if (!saveFileLegacy.exists()) {
                return;
            }
            replacements.clear();
            BufferedReader reader = new BufferedReader(new FileReader(saveFileLegacy));
            reader.readLine();
            Replacement r = null;
            while ((r = Replacement.readLegacy(reader)) != null) {
                replacements.add(r);
            }
            reader.close();
            saveFileLegacy.delete();
            ChatFlow.saveReplacements();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

