/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.handlers;

import javax.annotation.Nullable;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public abstract class SimpleFluidTank
implements IFluidHandler,
IFluidTank {
    public abstract int getStorage();

    public abstract void setStorage(int var1);

    public abstract int getCapacity();

    public abstract Fluid getAllowedFluid();

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{new FluidTankProperties(this.getStorage() == 0 ? null : new FluidStack(this.getAllowedFluid(), this.getStorage()), this.getCapacity(), this.canFill(), this.canDrain())};
    }

    public boolean canDrain() {
        return true;
    }

    public boolean canFill() {
        return true;
    }

    @Nullable
    public FluidStack getFluid() {
        return this.getStorage() == 0 ? null : new FluidStack(this.getAllowedFluid(), this.getStorage());
    }

    public int getFluidAmount() {
        return this.getStorage();
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo((IFluidTank)this);
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null || resource.amount <= 0 || resource.getFluid() != this.getAllowedFluid()) {
            return 0;
        }
        int toAdd = Math.min(this.getCapacity() - this.getStorage(), resource.amount);
        if (doFill && toAdd != 0) {
            this.setStorage(this.getStorage() + toAdd);
        }
        return toAdd;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource == null || resource.amount <= 0 || resource.getFluid() != this.getAllowedFluid()) {
            return null;
        }
        return this.drain(resource.amount, doDrain);
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        int drain = Math.min(this.getStorage(), maxDrain);
        if (doDrain && drain != 0) {
            this.setStorage(this.getStorage() - drain);
        }
        return new FluidStack(this.getAllowedFluid(), drain);
    }
}

