/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.rwtema.careerbees.bees.CareerBeeSpecies;
import com.rwtema.careerbees.entity.BeeEntry;
import com.rwtema.careerbees.entity.EntityChunkData;
import com.rwtema.careerbees.entity.ParticleExclamation;
import com.rwtema.careerbees.entity.PlacedBeeManager;
import com.rwtema.careerbees.helpers.RandomHelper;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IErrorLogic;
import forestry.api.core.IErrorState;
import forestry.api.core.IErrorStateRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class StudentManager
extends PlacedBeeManager<BeeEntry.StudentBeeEntry> {
    final Set<IErrorState> errorTypes = Sets.newHashSet((Object[])new String[]{"no_flower", "no_queen", "no_drone", "no_space"}).stream().map(s -> "forestry:" + s).map(arg_0 -> ((IErrorStateRegistry)ForestryAPI.errorStateRegistry).getErrorState(arg_0)).collect(Collectors.toSet());

    public StudentManager() {
        super(CareerBeeSpecies.STUDENT);
    }

    @Override
    protected boolean isValidBeeType(EnumBeeType type, IAlleleBeeSpecies primary, IAlleleBeeSpecies secondary) {
        return type == EnumBeeType.DRONE && primary == CareerBeeSpecies.STUDENT.species && primary == secondary;
    }

    @Override
    protected void onPlaced(@Nonnull EntityPlayer entityPlayer) {
        entityPlayer.func_145747_a((ITextComponent)new TextComponentTranslation("careerbees.message.placed.student.bee", new Object[0]));
    }

    @Override
    @Nonnull
    protected BeeEntry.StudentBeeEntry createEntry(@Nonnull IBeeHousing tileEntity, NBTTagCompound tag) {
        return new BeeEntry.StudentBeeEntry(tag, (byte)(this.checkForErrors(tileEntity) ? 1 : 0));
    }

    @Override
    @Nonnull
    protected BeeEntry.StudentBeeEntry recreateBeeEntry(NBTTagCompound genome) {
        return new BeeEntry.StudentBeeEntry(genome, 2);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void tickClient(@Nonnull Chunk chunk, @Nonnull Random rand, @Nonnull Map.Entry<BlockPos, BeeEntry.StudentBeeEntry> entry, @Nonnull BlockPos pos, TileEntity tileEntity, IBeeHousing entity) {
        if (entry.getValue().active == 0 && rand.nextInt(5) == 0) {
            ArrayList enumFacings = Lists.newArrayList((Object[])EnumFacing.values());
            Collections.shuffle(enumFacings);
            for (EnumFacing dir : RandomHelper.getPermutation()) {
                BlockPos offset = pos.func_177972_a(dir);
                IBlockState blockState = chunk.func_177435_g(offset);
                if (blockState.func_185915_l()) continue;
                EnumMap<EnumFacing.Axis, Float> map = new EnumMap<EnumFacing.Axis, Float>(EnumFacing.Axis.class);
                for (EnumFacing.Axis axis : EnumFacing.Axis.values()) {
                    map.put(axis, Float.valueOf(axis == dir.func_176740_k() ? (dir.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE ? 1.0f - rand.nextFloat() * 0.2f : rand.nextFloat() * 0.2f) : rand.nextFloat()));
                }
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleExclamation(chunk.func_177412_p(), (float)offset.func_177958_n() + ((Float)map.get(EnumFacing.Axis.X)).floatValue(), (float)offset.func_177956_o() + ((Float)map.get(EnumFacing.Axis.Y)).floatValue(), (float)offset.func_177952_p() + ((Float)map.get(EnumFacing.Axis.Z)).floatValue()));
                break;
            }
        }
    }

    @Override
    protected boolean updateTile(Chunk chunk, @Nonnull Map.Entry<BlockPos, BeeEntry.StudentBeeEntry> k, @Nonnull IBeeHousing hou, TileEntity tileEntity) {
        byte t;
        byte by = t = this.checkForErrors(hou) ? (byte)0 : 1;
        if (k.getValue().active != t) {
            k.getValue().active = t;
            EntityChunkData.markChunkDirty(chunk);
        }
        return false;
    }

    private boolean checkForErrors(@Nonnull IBeeHousing hou) {
        IErrorLogic errorLogic = hou.getErrorLogic();
        return this.errorTypes.stream().anyMatch(arg_0 -> ((IErrorLogic)errorLogic).contains(arg_0));
    }
}

