/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.effects;

import com.rwtema.careerbees.effects.EffectBase;
import com.rwtema.careerbees.effects.ISpecialBeeEffect;
import com.rwtema.careerbees.effects.settings.IEffectSettingsHolder;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EffectRandomSwap
extends EffectBase
implements ISpecialBeeEffect.SpecialEffectBlock {
    public static final EffectRandomSwap INSTANCE = new EffectRandomSwap();

    public EffectRandomSwap() {
        super("teleposition");
    }

    @Override
    @Nonnull
    public IEffectData doEffectBase(@Nonnull IBeeGenome genome, @Nonnull IEffectData storedData, @Nonnull IBeeHousing housing, IEffectSettingsHolder settings) {
        World worldObj = housing.getWorldObj();
        Random rand = worldObj.field_73012_v;
        if (worldObj.field_72995_K) {
            return storedData;
        }
        AxisAlignedBB aabb = EffectRandomSwap.getAABB(genome, housing);
        BlockPos a = this.getRandomBlockPosInAABB(rand, aabb);
        this.processPosition(worldObj, rand, aabb, a);
        return storedData;
    }

    @Override
    public boolean canHandleBlock(World world, BlockPos pos, @Nonnull IBeeGenome genome, EnumFacing sideHit) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        return state.func_185887_b(world, pos) >= 0.0f && this.isNormalCube(state);
    }

    @Override
    public boolean handleBlock(@Nonnull World world, @Nonnull BlockPos pos, EnumFacing facing, @Nonnull IBeeGenome genome, @Nonnull IBeeHousing housing) {
        return this.processPosition(world, world.field_73012_v, EffectRandomSwap.getAABB(genome, housing), pos);
    }

    public boolean processPosition(@Nonnull World worldObj, @Nonnull Random rand, @Nonnull AxisAlignedBB aabb, @Nonnull BlockPos a) {
        if (worldObj.func_175623_d(a)) {
            return false;
        }
        TileEntity tileEntity = worldObj.func_175625_s(a);
        if (tileEntity != null) {
            return false;
        }
        IBlockState state = worldObj.func_180495_p(a);
        float blockHardness = state.func_185887_b(worldObj, a);
        if (blockHardness < 0.0f || !this.isNormalCube(state)) {
            return false;
        }
        BlockPos b = this.getRandomBlockPosInAABB(rand, aabb);
        if (worldObj.func_175623_d(b)) {
            return false;
        }
        tileEntity = worldObj.func_175625_s(b);
        if (tileEntity != null) {
            return false;
        }
        IBlockState otherState = worldObj.func_180495_p(b);
        if (state == otherState || !this.isNormalCube(otherState) || state.func_185904_a() != otherState.func_185904_a() || otherState.func_185887_b(worldObj, b) != blockHardness) {
            return false;
        }
        worldObj.func_180501_a(a, otherState, 2);
        worldObj.func_180501_a(b, state, 2);
        worldObj.func_175685_c(a, otherState.func_177230_c(), true);
        worldObj.func_175685_c(b, state.func_177230_c(), true);
        return true;
    }

    public boolean isNormalCube(@Nonnull IBlockState state) {
        return state.func_185915_l() && state.func_185898_k() && state.func_185917_h() && state.func_185914_p() && state.func_185905_o() == EnumPushReaction.NORMAL && !state.func_177230_c().hasTileEntity(state);
    }

    @Nonnull
    public BlockPos getRandomBlockPosInAABB(@Nonnull Random rand, @Nonnull AxisAlignedBB aabb) {
        int x = EffectRandomSwap.getRand(MathHelper.func_76128_c((double)aabb.field_72340_a), MathHelper.func_76143_f((double)aabb.field_72336_d), rand);
        int y = EffectRandomSwap.getRand(MathHelper.func_76128_c((double)aabb.field_72338_b), MathHelper.func_76143_f((double)aabb.field_72337_e), rand);
        int z = EffectRandomSwap.getRand(MathHelper.func_76128_c((double)aabb.field_72339_c), MathHelper.func_76143_f((double)aabb.field_72334_f), rand);
        return new BlockPos(x, y, z);
    }
}

