/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.power.calculation;

import ipsis.Woot;
import ipsis.woot.configuration.EnumConfigKey;
import ipsis.woot.farming.PowerRecipe;
import ipsis.woot.farmstructure.IFarmSetup;
import ipsis.woot.multiblock.EnumMobFactoryTier;
import ipsis.woot.power.calculation.IPowerCalculator;
import ipsis.woot.power.calculation.upgrades.EnumMassMultiplier;
import ipsis.woot.power.calculation.upgrades.IUpgradePowerCalculator;
import ipsis.woot.util.ConfigKeyHelper;
import ipsis.woot.util.DebugSetup;
import ipsis.woot.util.WootMobName;
import java.math.BigInteger;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class BigIntegerCalculator
implements IPowerCalculator {
    @Override
    @Nonnull
    public PowerRecipe calculate(World world, IFarmSetup farmSetup) {
        BigInteger m;
        WootMobName wootMobName = farmSetup.getWootMobName();
        Woot.debugSetup.trace(DebugSetup.EnumDebugType.POWER_CALC, "calculate", wootMobName);
        int tierPowerPerTick = Woot.wootConfiguration.getInteger(wootMobName, ConfigKeyHelper.getPowerPerTick(farmSetup.getFarmTier()));
        int spawnTicks = Woot.wootConfiguration.getInteger(wootMobName, EnumConfigKey.SPAWN_TICKS);
        int spawnUnits = Woot.wootConfiguration.getSpawnCost(world, wootMobName);
        int powerPerSpawnUnit = Woot.wootConfiguration.getInteger(wootMobName, EnumConfigKey.POWER_PER_UNIT);
        int mobCount = farmSetup.getNumMobs();
        Woot.debugSetup.trace(DebugSetup.EnumDebugType.POWER_CALC, "calculate", "####");
        Woot.debugSetup.trace(DebugSetup.EnumDebugType.POWER_CALC, "calculate", "tierPowerPerTick: " + tierPowerPerTick);
        Woot.debugSetup.trace(DebugSetup.EnumDebugType.POWER_CALC, "calculate", "spawnUnits: " + spawnUnits);
        Woot.debugSetup.trace(DebugSetup.EnumDebugType.POWER_CALC, "calculate", "powerPerSpawnUnit: " + powerPerSpawnUnit);
        Woot.debugSetup.trace(DebugSetup.EnumDebugType.POWER_CALC, "calculate", "spawnTicks: " + spawnTicks);
        Woot.debugSetup.trace(DebugSetup.EnumDebugType.POWER_CALC, "calculate", "number of mobs: " + mobCount);
        CalculatorValues v = new CalculatorValues();
        BigInteger factoryCost = BigInteger.valueOf(tierPowerPerTick);
        factoryCost = factoryCost.multiply(BigInteger.valueOf(spawnTicks));
        BigInteger mobCost = BigInteger.valueOf(spawnUnits);
        mobCost = mobCost.multiply(BigInteger.valueOf(powerPerSpawnUnit));
        mobCost = mobCost.multiply(BigInteger.valueOf(spawnTicks));
        List<IUpgradePowerCalculator> calculators = Woot.calculatorRepository.getActiveCalculators(farmSetup);
        for (IUpgradePowerCalculator calculator : calculators) {
            BigInteger upgradeCost = calculator.calculateUpgradeCost(farmSetup, spawnTicks);
            factoryCost = factoryCost.add(upgradeCost);
            calculator.updateCalculatorValues(farmSetup, v);
        }
        Woot.debugSetup.trace(DebugSetup.EnumDebugType.POWER_CALC, "calculate", "factory with upgrades: " + factoryCost);
        Woot.debugSetup.trace(DebugSetup.EnumDebugType.POWER_CALC, "calculate", "single mob: " + mobCost);
        BigInteger totalMobCost = BigInteger.ZERO;
        if (v.mass == EnumMassMultiplier.X_BASE_2) {
            Woot.debugSetup.trace(DebugSetup.EnumDebugType.POWER_CALC, "calculate", "2^(count - 1)");
            for (int i = 0; i < mobCount; ++i) {
                m = BigInteger.valueOf((int)Math.pow(2.0, i));
                BigInteger c = mobCost.multiply(m);
                Woot.debugSetup.trace(DebugSetup.EnumDebugType.POWER_CALC, "calculate", "cost * " + m + " -> " + c);
                totalMobCost = totalMobCost.add(c);
            }
        } else if (v.mass == EnumMassMultiplier.X_BASE_3) {
            Woot.debugSetup.trace(DebugSetup.EnumDebugType.POWER_CALC, "calculate", "3^(count - 1)");
            for (int i = 0; i < mobCount; ++i) {
                m = BigInteger.valueOf((int)Math.pow(3.0, i));
                BigInteger c = mobCost.multiply(m);
                Woot.debugSetup.trace(DebugSetup.EnumDebugType.POWER_CALC, "calculate", "cost * " + m + " -> " + c);
                totalMobCost = totalMobCost.add(mobCost.multiply(m));
            }
        } else {
            Woot.debugSetup.trace(DebugSetup.EnumDebugType.POWER_CALC, "calculate", "linear");
            totalMobCost = mobCost.multiply(BigInteger.valueOf(mobCount));
        }
        factoryCost = factoryCost.add(totalMobCost);
        Woot.debugSetup.trace(DebugSetup.EnumDebugType.POWER_CALC, "calculate", mobCount + " cost: " + totalMobCost);
        Woot.debugSetup.trace(DebugSetup.EnumDebugType.POWER_CALC, "calculate", "factory: " + factoryCost);
        int finalSpawnTicks = spawnTicks;
        if (v.rate > 0) {
            int reduction = (int)((float)spawnTicks / 100.0f * (float)v.rate);
            Woot.debugSetup.trace(DebugSetup.EnumDebugType.POWER_CALC, "calculate", "rate reduction: " + reduction);
            finalSpawnTicks -= reduction;
            finalSpawnTicks = MathHelper.func_76125_a((int)finalSpawnTicks, (int)1, (int)Integer.MAX_VALUE);
        }
        Woot.debugSetup.trace(DebugSetup.EnumDebugType.POWER_CALC, "calculate", "ticks: " + finalSpawnTicks);
        long totalCost = Long.MAX_VALUE;
        if (factoryCost.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) < 0) {
            totalCost = factoryCost.longValue();
        }
        if (v.efficiency > 0) {
            long reduction = (long)((float)totalCost / 100.0f * (float)v.efficiency);
            Woot.debugSetup.trace(DebugSetup.EnumDebugType.POWER_CALC, "calculate", "efficiency reduction: " + reduction);
            if ((totalCost -= reduction) < 1L) {
                totalCost = 1L;
            }
        }
        PowerRecipe powerRecipe = new PowerRecipe(finalSpawnTicks, totalCost);
        if (this.isLowPowerMode(farmSetup.getFarmTier())) {
            Woot.debugSetup.trace(DebugSetup.EnumDebugType.POWER_CALC, "calculate", "low power mode 1RF/tick");
            powerRecipe = new PowerRecipe(finalSpawnTicks, finalSpawnTicks);
        }
        Woot.debugSetup.trace(DebugSetup.EnumDebugType.POWER_CALC, "calculate", "####");
        return powerRecipe;
    }

    private boolean isLowPowerMode(EnumMobFactoryTier tier) {
        if (tier == EnumMobFactoryTier.TIER_ONE && Woot.wootConfiguration.getBoolean(EnumConfigKey.TIER_I_LOW_POWER_MODE)) {
            return true;
        }
        if (tier == EnumMobFactoryTier.TIER_TWO && Woot.wootConfiguration.getBoolean(EnumConfigKey.TIER_II_LOW_POWER_MODE)) {
            return true;
        }
        if (tier == EnumMobFactoryTier.TIER_THREE && Woot.wootConfiguration.getBoolean(EnumConfigKey.TIER_III_LOW_POWER_MODE)) {
            return true;
        }
        return tier == EnumMobFactoryTier.TIER_FOUR && Woot.wootConfiguration.getBoolean(EnumConfigKey.TIER_IV_LOW_POWER_MODE);
    }

    public class CalculatorValues {
        public int rate = 0;
        public int efficiency = 0;
        public EnumMassMultiplier mass = EnumMassMultiplier.LINEAR;
    }
}

