/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.farmstructure;

import ipsis.woot.farmstructure.FarmScanner2;
import ipsis.woot.farmstructure.ScannedFarmBase;
import ipsis.woot.farmstructure.ScannedFarmController;
import ipsis.woot.farmstructure.ScannedFarmRemote;
import ipsis.woot.farmstructure.ScannedFarmUpgrade;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.world.World;

public class ScannedFarm2 {
    Set<FarmScanner2.BadFarmBlockInfo> badBlocks = new HashSet<FarmScanner2.BadFarmBlockInfo>();
    public ScannedFarmBase base = new ScannedFarmBase();
    public ScannedFarmController controller = new ScannedFarmController();
    public ScannedFarmRemote remote = new ScannedFarmRemote();
    public ScannedFarmUpgrade upgrades = new ScannedFarmUpgrade();

    public boolean isValidStructure() {
        return this.base.tier != null && this.controller.isValid() && this.remote.isValid();
    }

    public Set<FarmScanner2.BadFarmBlockInfo> getBadBlocks() {
        return this.badBlocks;
    }

    public boolean isValidCofiguration(World world) {
        return this.isValidStructure() && this.controller.isTierValid(world, this.base.tier);
    }

    public static boolean areFarmsEqual(@Nullable ScannedFarm2 a, @Nullable ScannedFarm2 b) {
        if (a == null || b == null) {
            return false;
        }
        if (!ScannedFarmBase.isEqual(a.base, b.base)) {
            return false;
        }
        if (!ScannedFarmController.isEqual(a.controller, b.controller)) {
            return false;
        }
        if (!ScannedFarmUpgrade.isEqual(a.upgrades, b.upgrades)) {
            return false;
        }
        return ScannedFarmRemote.isEqual(a.remote, b.remote);
    }
}

