/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.farmstructure;

import ipsis.Woot;
import ipsis.woot.block.BlockMobFactoryStructure;
import ipsis.woot.block.BlockWoot;
import ipsis.woot.farmblocks.IFarmBlockController;
import ipsis.woot.farmstructure.AbstractUpgradeTotem;
import ipsis.woot.farmstructure.AbstractUpgradeTotemBuilder;
import ipsis.woot.farmstructure.ScannedFarm2;
import ipsis.woot.farmstructure.ScannedFarmController;
import ipsis.woot.farmstructure.ScannedFarmRemote;
import ipsis.woot.farmstructure.ScannedFarmUpgrade;
import ipsis.woot.farmstructure.UpgradeTotemTierOne;
import ipsis.woot.farmstructure.UpgradeTotemTierThree;
import ipsis.woot.farmstructure.UpgradeTotemTierTwo;
import ipsis.woot.init.ModBlocks;
import ipsis.woot.multiblock.EnumMobFactoryTier;
import ipsis.woot.multiblock.MobFactoryModule;
import ipsis.woot.tileentity.TileEntityMobFactoryCell;
import ipsis.woot.tileentity.TileEntityMobFactoryExporter;
import ipsis.woot.tileentity.TileEntityMobFactoryImporter;
import ipsis.woot.util.BlockPosHelper;
import ipsis.woot.util.EnumFarmUpgrade;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class FarmScanner2 {
    private BadFarmBlockInfo createBadFarmBlockInfo(MobFactoryModule m, BadBlockReason r, BlockPos p, Block badBlock, int badBlockMeta) {
        BadFarmBlockInfo i = new BadFarmBlockInfo(r, p);
        BlockWoot b = ModBlocks.blockStructure;
        int meta = m.getModuleType().getMetadata();
        i.setBlockInfo(b, meta, badBlock, badBlockMeta);
        return i;
    }

    private boolean scanTier(World world, BlockPos origin, EnumFacing facing, EnumMobFactoryTier tier, Set<BadFarmBlockInfo> badList, Set<BlockPos> goodList) {
        badList.clear();
        goodList.clear();
        boolean valid = true;
        for (MobFactoryModule m : Woot.factoryPatternRepository.getAllModules(tier)) {
            BlockPos p = new BlockPos((Vec3i)origin).func_177971_a((Vec3i)BlockPosHelper.rotateFromSouth(m.getOffset(), facing.func_176734_d()));
            if (!world.func_175667_e(p)) {
                badList.add(this.createBadFarmBlockInfo(m, BadBlockReason.MISSING_BLOCK, p, Blocks.field_150350_a, 0));
                valid = false;
                continue;
            }
            IBlockState blockState = world.func_180495_p(p);
            Block b = blockState.func_177230_c();
            if (!(b instanceof BlockMobFactoryStructure)) {
                badList.add(this.createBadFarmBlockInfo(m, BadBlockReason.WRONG_BLOCK, p, b, b.func_176201_c(blockState)));
                valid = false;
                continue;
            }
            if (((BlockMobFactoryStructure)b).getModuleTypeFromState(blockState) != m.getModuleType()) {
                badList.add(this.createBadFarmBlockInfo(m, BadBlockReason.WRONG_STRUCTURE_TYPE, p, b, b.func_176201_c(blockState)));
                valid = false;
                continue;
            }
            goodList.add(p);
        }
        if (!valid) {
            goodList.clear();
        }
        return valid;
    }

    @Nullable
    private BlockPos findController(World world, BlockPos origin, EnumFacing facing) {
        BlockPos p = this.getControllerPos(world, origin, facing);
        TileEntity te = world.func_175625_s(p);
        if (te instanceof IFarmBlockController) {
            return p;
        }
        return null;
    }

    public BlockPos getControllerPos(World world, BlockPos origin, EnumFacing facing) {
        return new BlockPos((Vec3i)origin).func_177981_b(1).func_177967_a(facing, -1);
    }

    @Nullable
    private TileEntityMobFactoryCell findCell(World world, BlockPos origin) {
        int Y_OFFSET = 10;
        for (int offset = 1; offset <= Y_OFFSET; ++offset) {
            BlockPos p = new BlockPos((Vec3i)origin).func_177979_c(offset);
            TileEntity te = world.func_175625_s(p);
            if (te instanceof TileEntityMobFactoryExporter || te instanceof TileEntityMobFactoryImporter) {
                return null;
            }
            if (!(te instanceof TileEntityMobFactoryCell)) continue;
            return (TileEntityMobFactoryCell)te;
        }
        return null;
    }

    private void scanController(World world, BlockPos origin, EnumFacing facing, ScannedFarmController controller) {
        BlockPos p = this.findController(world, origin, facing);
        if (p != null) {
            IFarmBlockController iFarmBlockController = (IFarmBlockController)world.func_175625_s(p);
            controller.setBlocks(p);
            controller.wootMob = iFarmBlockController.getWootMob();
        }
    }

    private void scanRemote(World world, BlockPos origin, EnumFacing facing, ScannedFarmRemote remote) {
        TileEntityMobFactoryCell cell = this.findCell(world, origin);
        if (cell != null) {
            boolean power;
            boolean bl = power = cell.getPowerStation() != null;
            if (power) {
                remote.setPowerPos(new BlockPos((Vec3i)cell.func_174877_v()));
            }
            BlockPos inPos = new BlockPos((Vec3i)cell.func_174877_v()).func_177979_c(1);
            BlockPos outPos = new BlockPos((Vec3i)cell.func_174877_v()).func_177979_c(2);
            TileEntity inTe = world.func_175625_s(inPos);
            TileEntity outTe = world.func_175625_s(outPos);
            if (inTe instanceof TileEntityMobFactoryImporter) {
                remote.setImportPos(inPos);
            }
            if (outTe instanceof TileEntityMobFactoryExporter) {
                remote.setExportPos(outPos);
            }
        }
    }

    private void scanUpgrades(World world, BlockPos origin, EnumFacing facing, EnumMobFactoryTier tier, ScannedFarmUpgrade upgrades) {
        Class upgradeClass;
        BlockPos[] positions;
        if (tier == EnumMobFactoryTier.TIER_ONE) {
            positions = new BlockPos[]{new BlockPos(1, 1, 1), new BlockPos(-1, 1, 1)};
            upgradeClass = UpgradeTotemTierOne.class;
        } else if (tier == EnumMobFactoryTier.TIER_TWO) {
            positions = new BlockPos[]{new BlockPos(1, 1, 1), new BlockPos(-1, 1, 1), new BlockPos(2, 1, 1), new BlockPos(-2, 1, 1)};
            upgradeClass = UpgradeTotemTierTwo.class;
        } else {
            positions = new BlockPos[]{new BlockPos(1, 1, 1), new BlockPos(-1, 1, 1), new BlockPos(2, 1, 1), new BlockPos(-2, 1, 1), new BlockPos(3, 1, 1), new BlockPos(-3, 1, 1)};
            upgradeClass = UpgradeTotemTierThree.class;
        }
        for (BlockPos p : positions) {
            BlockPos offset = BlockPosHelper.rotateFromSouth(p, facing.func_176734_d());
            BlockPos p2 = origin.func_177982_a(offset.func_177958_n(), offset.func_177956_o(), offset.func_177952_p());
            AbstractUpgradeTotem upgradeTotem = AbstractUpgradeTotemBuilder.build(upgradeClass, world, p2);
            if (upgradeTotem == null) continue;
            upgradeTotem.scan();
            if (!upgradeTotem.isValid()) continue;
            ScannedFarmUpgrade.Upgrade upgrade = new ScannedFarmUpgrade.Upgrade();
            upgrade.upgradeTier = upgradeTotem.spawnerUpgradeLevel;
            upgrade.blocks.addAll(upgradeTotem.blockPosList);
            upgrade.upgrade = EnumFarmUpgrade.getFromEnumSpawnerUpgrade(upgradeTotem.spawnerUpgrade);
            upgrades.addUpgrade(upgrade);
        }
    }

    public ScannedFarm2 scanFarm(World world, BlockPos origin, EnumFacing facing, EnumMobFactoryTier tier) {
        ScannedFarm2 farm = new ScannedFarm2();
        if (this.scanTier(world, origin, facing, tier, farm.badBlocks, farm.base.getBlocks())) {
            farm.base.tier = tier;
            this.scanController(world, origin, facing, farm.controller);
            this.scanRemote(world, origin, facing, farm.remote);
            this.scanUpgrades(world, origin, facing, tier, farm.upgrades);
        }
        return farm;
    }

    public ScannedFarm2 scanFarm(World world, BlockPos origin, EnumFacing facing) {
        ScannedFarm2 farm = new ScannedFarm2();
        for (int i = EnumMobFactoryTier.values().length - 1; i >= 0; --i) {
            ScannedFarm2 farm2 = this.scanFarm(world, origin, facing, EnumMobFactoryTier.values()[i]);
            if (!farm2.isValidStructure() || !farm2.isValidCofiguration(world)) continue;
            farm = farm2;
            break;
        }
        return farm;
    }

    public class BadFarmBlockInfo {
        private BlockPos pos;
        private BadBlockReason reason;
        private Block correctBlock;
        private int correctBlockMeta;
        private Block invalidBlock;
        private int invalidBlockMeta;

        public BadFarmBlockInfo(BadBlockReason reason, BlockPos pos) {
            this.reason = reason;
            this.pos = new BlockPos((Vec3i)pos);
        }

        public BadBlockReason getReason() {
            return this.reason;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public void setBlockInfo(Block correctBlock, int correctBlockMeta, Block invalidBlock, int invalidBlockMeta) {
            this.correctBlock = correctBlock;
            this.correctBlockMeta = correctBlockMeta;
            this.invalidBlock = invalidBlock;
            this.invalidBlockMeta = invalidBlockMeta;
        }

        public Block getCorrectBlock() {
            return this.correctBlock;
        }

        public int getCorrectBlockMeta() {
            return this.correctBlockMeta;
        }

        public Block getInvalidBlock() {
            return this.invalidBlock;
        }

        public int getInvalidBlockMeta() {
            return this.invalidBlockMeta;
        }
    }

    public static enum BadBlockReason {
        MISSING_BLOCK,
        WRONG_BLOCK,
        WRONG_STRUCTURE_TYPE;

    }
}

