/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.farmblocks;

import ipsis.Woot;
import ipsis.woot.farmblocks.IFactoryGlue;
import ipsis.woot.farmblocks.IFactoryGlueProvider;
import ipsis.woot.farmblocks.IFarmBlockMaster;
import ipsis.woot.farmblocks.IFarmBlockMasterLocator;
import ipsis.woot.init.ModBlocks;
import ipsis.woot.util.DebugSetup;
import ipsis.woot.util.WorldHelper;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FactoryGlue
implements IFactoryGlue {
    private IFarmBlockMaster master = null;
    private IFarmBlockMasterLocator locater;
    private IFactoryGlue.FactoryBlockType type;
    private IFactoryGlueProvider provider;
    private TileEntity te;

    @Override
    public boolean hasMaster() {
        return this.master != null;
    }

    @Override
    public void clearMaster() {
        if (this.hasMaster()) {
            Woot.debugSetup.trace(DebugSetup.EnumDebugType.MULTIBLOCK, "FactoryGlue:", "clearMaster");
            this.master = null;
            WorldHelper.updateClient(this.te.func_145831_w(), this.te.func_174877_v());
            if (this.type == IFactoryGlue.FactoryBlockType.CELL) {
                WorldHelper.updateNeighbors(this.te.func_145831_w(), this.te.func_174877_v(), ModBlocks.blockCell);
            } else if (this.type == IFactoryGlue.FactoryBlockType.EXPORTER) {
                WorldHelper.updateNeighbors(this.te.func_145831_w(), this.te.func_174877_v(), ModBlocks.blockExporter);
            } else if (this.type == IFactoryGlue.FactoryBlockType.IMPORTER) {
                WorldHelper.updateNeighbors(this.te.func_145831_w(), this.te.func_174877_v(), ModBlocks.blockImporter);
            }
        }
    }

    @Override
    public void setMaster(IFarmBlockMaster master) {
        if (this.master != master) {
            Woot.debugSetup.trace(DebugSetup.EnumDebugType.MULTIBLOCK, "FactoryGlue:", "setMaster");
            this.master = master;
            WorldHelper.updateClient(this.te.func_145831_w(), this.te.func_174877_v());
            if (this.type == IFactoryGlue.FactoryBlockType.CELL) {
                WorldHelper.updateNeighbors(this.te.func_145831_w(), this.te.func_174877_v(), ModBlocks.blockCell);
            } else if (this.type == IFactoryGlue.FactoryBlockType.EXPORTER) {
                WorldHelper.updateNeighbors(this.te.func_145831_w(), this.te.func_174877_v(), ModBlocks.blockExporter);
            } else if (this.type == IFactoryGlue.FactoryBlockType.IMPORTER) {
                WorldHelper.updateNeighbors(this.te.func_145831_w(), this.te.func_174877_v(), ModBlocks.blockImporter);
            }
        }
    }

    public FactoryGlue(IFactoryGlue.FactoryBlockType type, IFarmBlockMasterLocator locator, TileEntity te, IFactoryGlueProvider iFactoryGlueProvider) {
        this.type = type;
        this.locater = locator;
        this.te = te;
        this.provider = iFactoryGlueProvider;
    }

    @Override
    public void onHello(World world, BlockPos pos) {
        Woot.debugSetup.trace(DebugSetup.EnumDebugType.MULTIBLOCK, "FactoryGlue:", "onHello");
        IFarmBlockMaster tmpMaster = this.locater.findMaster(world, pos, this.provider);
        if (tmpMaster != null) {
            tmpMaster.interruptFarmStructure();
        }
    }

    @Override
    public void onGoodbye() {
        Woot.debugSetup.trace(DebugSetup.EnumDebugType.MULTIBLOCK, "FactoryGlue:", "onGoodbye");
        if (this.hasMaster()) {
            this.master.interruptFarmStructure();
        }
    }

    @Override
    public IFactoryGlue.FactoryBlockType getType() {
        return this.type;
    }

    @Override
    public BlockPos getPos() {
        return this.te.func_174877_v();
    }
}

