/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.configuration;

import ipsis.Woot;
import ipsis.woot.configuration.EnumConfigKey;
import ipsis.woot.configuration.IWootConfiguration;
import ipsis.woot.multiblock.EnumMobFactoryTier;
import ipsis.woot.util.DebugSetup;
import ipsis.woot.util.EnumEnchantKey;
import ipsis.woot.util.WootMobName;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.world.World;

public class WootConfigurationManager
implements IWootConfiguration {
    private Map<EnumConfigKey, Integer> integerMap = new HashMap<EnumConfigKey, Integer>();
    private Map<EnumConfigKey, Boolean> booleanMap = new HashMap<EnumConfigKey, Boolean>();
    private Map<String, Integer> integerMobMap = new HashMap<String, Integer>();
    private Map<String, Boolean> booleanMobMap = new HashMap<String, Boolean>();

    private String makeKey(WootMobName wootMobName, EnumConfigKey configKey) {
        return wootMobName.toString() + ":" + configKey.toString();
    }

    @Override
    public boolean getBoolean(EnumConfigKey key) {
        Woot.debugSetup.trace(DebugSetup.EnumDebugType.CONFIG_ACCESS, "getBoolean", (Object)key);
        return this.booleanMap.get((Object)key);
    }

    @Override
    public boolean getBoolean(WootMobName wootMobName, EnumConfigKey key) {
        Woot.debugSetup.trace(DebugSetup.EnumDebugType.CONFIG_ACCESS, "getBoolean", wootMobName + " " + (Object)((Object)key));
        String k = this.makeKey(wootMobName, key);
        if (this.booleanMobMap.containsKey(k)) {
            return this.booleanMobMap.get(k);
        }
        return this.booleanMap.get((Object)key);
    }

    @Override
    public int getInteger(EnumConfigKey key) {
        Woot.debugSetup.trace(DebugSetup.EnumDebugType.CONFIG_ACCESS, "getInteger", (Object)key);
        return this.integerMap.get((Object)key);
    }

    @Override
    public int getInteger(WootMobName wootMobName, EnumConfigKey key) {
        Woot.debugSetup.trace(DebugSetup.EnumDebugType.CONFIG_ACCESS, "getInteger", wootMobName + " " + (Object)((Object)key));
        String k = this.makeKey(wootMobName, key);
        if (this.integerMobMap.containsKey(k)) {
            return this.integerMobMap.get(k);
        }
        return this.integerMap.get((Object)key);
    }

    @Override
    public void setBoolean(EnumConfigKey key, boolean v) {
        Woot.debugSetup.trace(DebugSetup.EnumDebugType.CONFIG_LOAD, "setBoolean", (Object)((Object)key) + " " + v);
        this.booleanMap.put(key, v);
    }

    @Override
    public void setBoolean(WootMobName wootMobName, EnumConfigKey key, boolean v) {
        Woot.debugSetup.trace(DebugSetup.EnumDebugType.CONFIG_LOAD, "setBoolean", wootMobName + " " + (Object)((Object)key) + " " + v);
        if (key.canMobOverride()) {
            String k = this.makeKey(wootMobName, key);
            this.booleanMobMap.put(k, v);
        }
    }

    @Override
    public void setInteger(EnumConfigKey key, int v) {
        Woot.debugSetup.trace(DebugSetup.EnumDebugType.CONFIG_LOAD, "setInteger", (Object)((Object)key) + " " + v);
        this.integerMap.put(key, v);
    }

    @Override
    public void setInteger(WootMobName wootMobName, EnumConfigKey key, int v) {
        Woot.debugSetup.trace(DebugSetup.EnumDebugType.CONFIG_LOAD, "setInteger", wootMobName + " " + (Object)((Object)key) + " " + v);
        if (key.canMobOverride()) {
            String k = this.makeKey(wootMobName, key);
            this.integerMobMap.put(k, v);
        }
    }

    @Override
    public void addToDragonDrops(EnumEnchantKey enchantKey, String itemName, int stackSize, float chance) {
    }

    @Override
    @Nonnull
    public EnumMobFactoryTier getFactoryTier(World world, WootMobName wootMobName) {
        EnumMobFactoryTier tier;
        String key = this.makeKey(wootMobName, EnumConfigKey.FACTORY_TIER);
        if (this.integerMobMap.containsKey(key)) {
            int tierKey = this.integerMobMap.get(key) - 1;
            tier = EnumMobFactoryTier.getTier(tierKey);
        } else {
            int cost = this.getSpawnCost(world, wootMobName);
            tier = cost >= this.getInteger(wootMobName, EnumConfigKey.T4_UNITS_MAX) ? EnumMobFactoryTier.TIER_FOUR : (cost >= this.getInteger(wootMobName, EnumConfigKey.T3_UNITS_MAX) ? EnumMobFactoryTier.TIER_THREE : (cost >= this.getInteger(wootMobName, EnumConfigKey.T2_UNITS_MAX) ? EnumMobFactoryTier.TIER_TWO : EnumMobFactoryTier.TIER_ONE));
        }
        return tier;
    }

    @Override
    public int getSpawnCost(World world, WootMobName wootMobName) {
        String key = this.makeKey(wootMobName, EnumConfigKey.SPAWN_UNITS);
        if (this.integerMobMap.containsKey(key)) {
            return this.integerMobMap.get(key);
        }
        return Woot.mobCosting.getMobSpawnCost(world, wootMobName);
    }

    @Override
    public int getDeathCost(World world, WootMobName wootMobName) {
        String key = this.makeKey(wootMobName, EnumConfigKey.DEATH_XP);
        if (this.integerMobMap.containsKey(key)) {
            return this.integerMobMap.get(key);
        }
        return Woot.wootConfiguration.getInteger(EnumConfigKey.DEATH_XP);
    }
}

