/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.ynot.flamingo;

import com.reddit.user.koppeh.flamingo.TileEntityFlamingo;
import gnu.trove.iterator.TObjectFloatIterator;
import gnu.trove.map.TObjectFloatMap;
import gnu.trove.map.hash.TObjectFloatHashMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mcjty.xnet.api.channels.IControllerContext;
import mcjty.xnet.api.gui.IEditorGui;
import mcjty.xnet.api.gui.IndicatorIcon;
import mcjty.xnet.api.helper.AbstractConnectorSettings;
import mcjty.xnet.api.keys.SidedConsumer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import org.apache.commons.lang3.tuple.Pair;
import pl.asie.ynot.YNot;
import pl.asie.ynot.enums.InsertionMode;
import pl.asie.ynot.flamingo.FlamingoConnectorSettings;
import pl.asie.ynot.traits.TraitedChannelSettings;

public class FlamingoChannelSettings
extends TraitedChannelSettings {
    private TObjectFloatMap<Pair<SidedConsumer, FlamingoConnectorSettings>> sources;
    private List<Pair<SidedConsumer, FlamingoConnectorSettings>> destinations;

    public void tick(int channel, IControllerContext context) {
        this.updateCache(channel, context);
        TObjectFloatIterator it = this.sources.iterator();
        HashSet<BlockPos> sourcePos = new HashSet<BlockPos>();
        float power = 0.0f;
        while (it.hasNext()) {
            TileEntity tile;
            EnumFacing side;
            BlockPos pos;
            it.advance();
            Pair entry2 = (Pair)it.key();
            BlockPos extractorPos = context.findConsumerPosition(((SidedConsumer)entry2.getKey()).getConsumerId());
            if (extractorPos == null || !this.shouldCheck(context, pos = extractorPos.func_177972_a(side = ((SidedConsumer)entry2.getKey()).getSide()), extractorPos, (AbstractConnectorSettings)entry2.getValue()) || !((tile = context.getControllerWorld().func_175625_s(pos)) instanceof TileEntityFlamingo)) continue;
            float oldValue = it.value();
            float newValue = ((TileEntityFlamingo)tile).getWiggleStrength();
            it.setValue(newValue);
            if (!(newValue > oldValue)) continue;
            power += newValue;
            sourcePos.add(pos);
        }
        if (power > 0.0f) {
            List<BlockPos> s = this.destinations.stream().map(entry -> {
                BlockPos extractorPos = context.findConsumerPosition(((SidedConsumer)entry.getKey()).getConsumerId());
                if (extractorPos != null) {
                    EnumFacing side = ((SidedConsumer)entry.getKey()).getSide();
                    BlockPos pos = extractorPos.func_177972_a(side);
                    if (sourcePos.contains(pos)) {
                        return null;
                    }
                    if (!this.shouldCheck(context, pos, extractorPos, (AbstractConnectorSettings)entry.getValue())) {
                        return null;
                    }
                    return pos;
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            float ultimatePower = Math.min(power / (float)s.size(), 40.0f);
            s.forEach(entry -> context.getControllerWorld().func_175641_c(entry, context.getControllerWorld().func_180495_p(entry).func_177230_c(), (int)ultimatePower, (int)(((double)ultimatePower - Math.floor(ultimatePower)) * 256.0)));
        }
    }

    private void updateCache(int channel, IControllerContext context) {
        if (this.sources == null) {
            FlamingoConnectorSettings con;
            this.sources = new TObjectFloatHashMap();
            this.destinations = new ArrayList<Pair<SidedConsumer, FlamingoConnectorSettings>>();
            Map connectors = context.getConnectors(channel);
            for (Map.Entry entry : connectors.entrySet()) {
                con = (FlamingoConnectorSettings)((Object)entry.getValue());
                if (con.insertionMode.get() != InsertionMode.INS) {
                    this.sources.put((Object)Pair.of(entry.getKey(), (Object)((Object)con)), 0.0f);
                }
                if (con.insertionMode.get() == InsertionMode.EXT) continue;
                this.destinations.add((Pair<SidedConsumer, FlamingoConnectorSettings>)Pair.of(entry.getKey(), (Object)((Object)con)));
            }
            connectors = context.getRoutedConnectors(channel);
            for (Map.Entry entry : connectors.entrySet()) {
                con = (FlamingoConnectorSettings)((Object)entry.getValue());
                if (con.insertionMode.get() == InsertionMode.EXT) continue;
                this.destinations.add((Pair<SidedConsumer, FlamingoConnectorSettings>)Pair.of(entry.getKey(), (Object)((Object)con)));
            }
        }
    }

    public void cleanCache() {
        this.sources = null;
        this.destinations = null;
    }

    public int getColors() {
        return 0;
    }

    @Nullable
    public IndicatorIcon getIndicatorIcon() {
        return new IndicatorIcon(YNot.iconGui, 11, 0, 11, 10);
    }

    @Nullable
    public String getIndicator() {
        return null;
    }

    public boolean isEnabled(String tag) {
        return true;
    }

    public void createGui(IEditorGui gui) {
    }
}

