/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminalscompat.modcompat.jei.terminalstorage;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.ingredient.collection.IngredientCollectionPrototypeMap;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentClient;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentItemStackCrafting;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorage;
import org.cyclops.integratedterminalscompat.IntegratedTerminalsCompat;
import org.cyclops.integratedterminalscompat.network.packet.TerminalStorageIngredientItemStackCraftingGridSetRecipe;

public class TerminalStorageRecipeTransferHandler
implements IRecipeTransferHandler<ContainerTerminalStorage> {
    private final IRecipeTransferHandlerHelper recipeTransferHandlerHelper;

    public TerminalStorageRecipeTransferHandler(IRecipeTransferHandlerHelper recipeTransferHandlerHelper) {
        this.recipeTransferHandlerHelper = recipeTransferHandlerHelper;
    }

    public Class<ContainerTerminalStorage> getContainerClass() {
        return ContainerTerminalStorage.class;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(ContainerTerminalStorage container, IRecipeLayout recipeLayout, EntityPlayer player, boolean maxTransfer, boolean doTransfer) {
        if (!recipeLayout.getRecipeCategory().getUid().equals("minecraft.crafting")) {
            return new TransferError();
        }
        if (Objects.equals(container.getSelectedTab(), TerminalStorageTabIngredientComponentItemStackCrafting.NAME.toString())) {
            if (!doTransfer) {
                TerminalStorageTabIngredientComponentClient tabClient = (TerminalStorageTabIngredientComponentClient)container.getTabClient(container.getSelectedTab());
                List unfilteredIngredients = tabClient.getUnfilteredIngredientsView(container.getSelectedChannel());
                IngredientCollectionPrototypeMap hayStack = new IngredientCollectionPrototypeMap(IngredientComponent.ITEMSTACK);
                hayStack.addAll((Iterable)unfilteredIngredients.stream().filter(i -> i.getCraftingOption() == null).map(TerminalStorageTabIngredientComponentClient.InstanceWithMetadata::getInstance).collect(Collectors.toList()));
                ArrayList slotsMissingItems = Lists.newArrayList();
                for (Map.Entry entry : recipeLayout.getItemStacks().getGuiIngredients().entrySet()) {
                    IGuiIngredient ingredient = (IGuiIngredient)entry.getValue();
                    if (ingredient == null || !ingredient.isInput()) continue;
                    int slot = (Integer)entry.getKey();
                    if (ingredient.getAllIngredients().isEmpty()) continue;
                    boolean found = false;
                    for (ItemStack itemStack : ingredient.getAllIngredients()) {
                        if (!hayStack.contains((Object)itemStack, (Object)7)) continue;
                        hayStack.remove((Object)itemStack);
                        found = true;
                        break;
                    }
                    if (found) continue;
                    slotsMissingItems.add(slot);
                }
                if (!slotsMissingItems.isEmpty()) {
                    String message = Translator.translateToLocal((String)"jei.tooltip.error.recipe.transfer.missing");
                    return this.recipeTransferHandlerHelper.createUserErrorForSlots(message, (Collection)slotsMissingItems);
                }
                return null;
            }
            HashMap slottedIngredients = Maps.newHashMap();
            for (Map.Entry entry : recipeLayout.getItemStacks().getGuiIngredients().entrySet()) {
                IGuiIngredient ingredient = (IGuiIngredient)entry.getValue();
                if (ingredient == null || !ingredient.isInput()) continue;
                int slot = (Integer)entry.getKey();
                slottedIngredients.put(slot, ingredient.getAllIngredients());
            }
            IntegratedTerminalsCompat._instance.getPacketHandler().sendToServer((PacketBase)new TerminalStorageIngredientItemStackCraftingGridSetRecipe(container.getSelectedTab(), container.getSelectedChannel(), maxTransfer, slottedIngredients));
            return null;
        }
        return new TransferError();
    }

    public static class TransferError
    implements IRecipeTransferError {
        public IRecipeTransferError.Type getType() {
            return IRecipeTransferError.Type.INTERNAL;
        }

        public void showError(Minecraft minecraft, int mouseX, int mouseY, IRecipeLayout recipeLayout, int recipeX, int recipeY) {
        }
    }
}

